	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef _SYNTHMODULE_H
#define _SYNTHMODULE_H

#include "config.h"
#include "moduleserver.h"

#ifdef HAVE_MINI_STL
#include <ministl/string>
#else
#include <string>
#endif

class SynthModule :public Module
{
	string modulename;
public:
	float **in,**out;
	int in_count, out_count;

	class KSynthesizer *Synthesizer;

	enum ArgType {arg_in,arg_out};

	void setName(string name) {modulename=name;};
	string getName() {return(modulename);};

	string getArgument(int nr, ArgType direction);
	virtual void Initialize(string info) = 0;
	virtual void DeInitialize();
	virtual void getfds(int &infd, int &outfd);
	virtual void Calculate() = 0;
	virtual string getParams() = 0;

	virtual void ProcessData(string data);

	virtual ~SynthModule();

//-- module server support --
	static void *get_MS();
};

#endif
