/***************************************************************************
                          options.h  -  description
                             -------------------
    begin                : Thu Sep 30 1999
    copyright            : (C) 1999 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// options.h
// ktuner v0.5, by Carl van Schaik
// e-mail carl@leg.uct.ac.za
//
// Radiotrack II implementation : Leendert Meyer (leendert@usa.net).
//
// RadioTrack II Protocol : Ben Pfaff

#ifndef OPTIONS_H
#define OPTIONS_H

#include "conf.h"
#include "hardware.h"

#include <qapp.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qtabdlg.h>
#include <qgrpbox.h>
#include <qradiobt.h>
#include <qtablevw.h>
#include <qscrbar.h>
#include <qlcdnum.h>
#include <qbttngrp.h>
#include <qchkbox.h>
#include <qlined.h>

class presetTable : public QTableView
{
public:
    presetTable( QWidget* parent=0, const char* name=0 );
    ~presetTable();

    const char* cellContent( int row, int col ) const;
    void setCellContent( int row, int col, const char* );

    void setNumberOfRows(int);
    void setRowText(int row ,int,QString);
    int getSelectedRow();
    void setSelectedRow(int);

protected:
    void paintCell( QPainter*, int row, int col );
    void mousePressEvent( QMouseEvent* );
    void keyPressEvent( QKeyEvent* );
    void focusInEvent( QFocusEvent* );
    void focusOutEvent( QFocusEvent* );

private:
    int indexOf( int row, int col ) const;
    QString* contents;
    int curRow;
    int curCol;
};

class presetEdit : public QWidget
{
  Q_OBJECT
 public:
  presetEdit(configFile*, QWidget *parent=0, const char *name=0);
  void setChanNum(int);

 signals:
  void edited();

 private slots:
  void update();
  void cancel();

 private:
  QLabel *info, *freq;
  QLineEdit *chName, *chFreq;
  QPushButton *OK, *Cancel;

  int chNum;
  configFile *cf;
};

class presetAdd : public QWidget
{
  Q_OBJECT
 public:
  presetAdd(configFile*, QWidget *parent=0, const char *name=0);
  void setInsertPos(int);
  void setFreq(int);

 signals:
  void edited();

 private slots:
  void update();
  void cancel();

 private:
  QLabel *info, *freq;
  QLineEdit *chName, *chFreq;
  QPushButton *OK, *Cancel;

  int chNum;
  configFile *cf;
};

class optionBox : public QTabDialog
{
Q_OBJECT
 public:
  optionBox(configFile*, radioCard*, QWidget *parent=0, const char *name=0);
  void configure(); 

 signals:
  void optionsUpdate();
  void listenTo(int);

 private slots:
  void optionsSave();
  void optionsCancel();
  void optionsDone();
  void volChg(int);
  void defChg(int);
  void sleepTimeC(int);
  void aHrUp();
  void aHrDn();
  void aMinUp();
  void aMinDn();
  void edit();
  void edited();
  void add();
  void insert();
  void Delete();
  void moveUp();
  void moveDown();
  void sendFreq();
  void aimsPushed();
  void aimsIIPushed();
  void zoltrixPushed();
  void kerneldevPushed();
  void setWarn();

 private:
  void setConf();

  QWidget    *general,
             *presets,
             *alarmtab;
  QButtonGroup *ioGroup,
    //*winStyle,
               *startUp,
               *cardType;
  QGroupBox    *sleepGroup,
               *Settings,
               *tabControls;
  QRadioButton *io20f,
               *io30f,
    //*motif,
    //*windows,
               *aims,
               *aimsII,
               *zoltrix,
               *kerneldev;
  QCheckBox    *verbose,
               *useDef,
               *setVol,
               *setAlarm;
  QScrollBar *sleepTimeB,
             *defVol,
             *defChn;
  QLabel     *sleepLabel,
             *chnName,
             *volText,
             *chnText,
             *hrText,
             *minText,
             *presetLabels,
             *credits,
             *note;
  QLCDNumber *sleepTimeI,
             *defVolI,
             *defChnI;
  QPushButton *hrPlus,
             *hrMinus,
             *minPlus,
             *minMinus,
             *rowEdit,
             *rowDel,
             *rowAdd,
             *rowInsert,
             *rowUp,
             *rowDown,
             *listen;

  presetTable  *table;
  presetEdit   *editBox;
  presetAdd    *addBox;

  int sleepTime,
      alarmHr,
      showWarn,
      alarmMin;
  configFile *cf;

};


#endif
