/***************************************************************************
                          timer.cpp  -  description
                             -------------------
    begin                : Thu Sep 30 1999
    copyright            : (C) 1999 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// timer.cpp
// ktuner v0.1 , Carl van Schaik
// e-mail carl@leg.uct.ac.za

#ifndef TIMER_CPP
#define TIMER_CPP

#include "timer.h"


sleepTimer::sleepTimer( QObject *parent, const char *name )
    : QObject( parent, name )
{
  initMetaObject();                           // initialize meta object
  duration = 0;
  counter = 0;
  state = 0; // not running
}

void sleepTimer::setTimer(int t)
{
  duration = t;
  resetTimer();
}

void sleepTimer::Go()
{
  timer = startTimer( 60000 );  // 1 minute intervals
  state = 1;
  counter = duration;
}

void sleepTimer::resetTimer()
{
  killTimer(timer);
  state = 0;
}

int sleepTimer::isRunning()
{
  return state;
}

void sleepTimer::timerEvent( QTimerEvent *e )
{
  if (state)
    if (counter > 1) counter --;
    else
      {
	state = 0;
	emit timeUp();
	resetTimer();
      }
}

#endif
