// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/MLGPlugin.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:35 $
// $State: Exp $
// **************************************************************

#include "MLGPlugin.h"
#include "InputModuleFile.h"
#include "MacroModuleEditor.h"
#include "LookInfoTypes.h"

MLGPlugin::MLGPlugin(string filename, string menupath)
    : filename(filename)
    , menupath(menupath)
    , is_good(false)
{
    // Create one Module for getting graphics and name!
    InputModuleFile modulefile(filename.c_str());
    if (modulefile.isGood()) {
	LookInfo look_info;
	modulefile.readLookInfo(look_info);
	name = look_info.name;
	grid_size = QSize(look_info.layout_rect.width, look_info.layout_rect.height);
	pixmap = toQ(look_info.preview);
	is_good = modulefile.isGood();
    }
}


bool MLGPlugin::isGood() const
{
    return is_good;
}


string MLGPlugin::getName() const
{
    if (is_good) return name;
    else return string("Broken Modulefile '" + filename + "'");
}


const char *MLGPlugin::menuPath() const
{
    return menupath.c_str();
}


void MLGPlugin::paint(QPainter& p, Module *) // module should always be 0!
{
    if (is_good) p.drawPixmap(0, 0, pixmap);
}


QSize MLGPlugin::gridSize() const
{
    if (is_good) return grid_size;
    else return QSize(2, 2);
}


ModuleLook *MLGPlugin::create(Module *module)
{
    return new MacroModuleLook(0, (MacroModule *)module, false);
}
