// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/MacroModuleEditor.h,v $
// $Revision: 1.2 $
// $Date: 1999/05/13 20:16:33 $
// $State: Exp $
// **************************************************************

#ifndef MacroModuleEditor_h
#define MacroModuleEditor_h

#include <qwidget.h>

#include "MacroModuleLook.h"

/**
  * @short Widget for editing a MacroModuleLook.
  */
class MacroModuleEditor : public QWidget
{
    Q_OBJECT

    /**
     * Underlying MacroModuleLook, which is being edited;
     */
    MacroModuleLook *mml;

public:

    /** 
     * Creates a new MacroModuleEditor. 
     * @param toplevel MusicdrawTopLevel Parent widget.
     * @param macromodule MacroModule that will be edited;
     */
    MacroModuleEditor(QWidget *parent, MacroModuleLook *macromodulelook);

    MacroModuleLook *getMacroModuleLook() { return mml; };

    // Access for MusicdrawToplevel

    bool insertFile(InputModuleFile& imf, const QPoint& offset=QPoint(0,0)) 
	{ return mml->insertFile(imf, offset); };
    bool saveToFile(OutputModuleFile& omf, bool now_not_mod=false, bool sel_only=false)
	{ return mml->saveToFile(omf, now_not_mod, sel_only); };
    bool preparedToDie()
	{ return mml->preparedToDie(); };
    void addMenus(KMenuBar *mb)
	{ mml->addMenus(mb); };
    void addToolbarButtons(KToolBar *tb)
	{ mml->addToolbarButtons(tb); };
    void addStatusbarItems(KStatusBar *sb)
	{ mml->addStatusbarItems(sb); };
    void removeToolbarButtons()
	{ mml->removeToolbarButtons(); };
    void keyPressed(QKeyEvent *e)
	{ mml->keyPressed(e); };
    void  paintEvent(QPaintEvent *e)
	{ mml->paintEvent(e); };
    void mousePressEvent(QMouseEvent *e)   
	{ mml->mousePressEvent(e); };
    void mouseReleaseEvent(QMouseEvent *e)
	{ mml->mouseReleaseEvent(e); };
    void mouseMoveEvent(QMouseEvent *e)
	{ mml->mouseMoveEvent(e); };
    void handleEvent(QEvent *e)
	{ mml->handleEvent(e); };
    
public slots: // emacs can't indent this qt-stuff correctly :-(
    
    void modulesMenuEvent(int module_id) 
	{ mml->modulesMenuEvent(module_id); };
    void insertMacroModule()
	{ mml->insertMacroModule(); };
    void startWireingEvent(int connector_id)
	{ mml->startWireingEvent(connector_id); };
    void finishWireingEvent(int connector_id)
	{ mml->finishWireingEvent(connector_id); };
    void undo()
	{ mml->undo(); };
    void redo()
	{ mml->redo(); };
    void copy()
	{ mml->copy(); };
    void cut()
	{ mml->cut(); };
    void paste()
	{ mml->paste(); };
    void selectAllModules()
	{ mml->selectAllModules(); };
    void rewire()
	{ mml->rewire(); };
    void flipHorizontally()
	{ mml->flipHorizontally(); };
    void flipVertically()
	{ mml->flipVertically(); };
    void editLook()
	{ mml->editLook(); };
    void lookDialog()
	{ mml->lookDialog(); };
    void addToLayout()
	{ mml->addToLayout(); };
    void removeFromLayout()
	{ mml->removeFromLayout(); };
    void play()
	{ mml->play(); };
    void playNextBlock() // target for timer event.
	{ mml->playNextBlock(); };
    void pause()
	{ mml->pause(); };
    void stop()
	{ mml->stop(); };
    void samplingConfiguration()
	{ mml->samplingConfiguration(); };
    void doGeneralUpdate(int n) // index needed because of signal type activated(int)
	{ mml->doGeneralUpdate(n); };
    void doGeneralUpdate()
	{ mml->doGeneralUpdate(); };
    void saveSelectionToFile()
	{ mml->saveSelectionToFile(); };
};


#endif // MacroModuleEditor_h
