// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/modules/MDuration.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:02:16 $
// $State: Exp $
// **************************************************************

#define MODULE_NAME "duration"

#include "ModuleMacros.h"

BEGIN_MODULE_DEFINITION(Duration);
    Slot *sslot_input;
    Slot *nslot_duration;
END_MODULE_DEFINITION(Duration);

class SSDurationOutput : public Signal
{
public:
    SSDurationOutput(MDuration *m) : Signal(SOUND_TYPE, "output", "Input with changed duration", m) {};
    PreparedSignal *prepareSignal(Metainfo *, const Parameterset *);
};


// ---------------------------------------------------------------------------
//                             Implementation
// ---------------------------------------------------------------------------

// #include <math.h>

MDuration::MDuration(string)
{
    addConnector(sslot_input = new Slot(SOUND_TYPE, "input", "Input sound signal", this, 5));
    addConnector(nslot_duration = new Slot(NUMBER_TYPE, "duration", 
					   "Relative duration, 1.0 = no change", this, 14));
    addConnector(new SSDurationOutput(this));
}


PreparedSignal *SSDurationOutput::prepareSignal(Metainfo *mi, const Parameterset *parset)
{
    PreparedNumberSignal *pnsig_duration 
	= getPreparedNumberSignal(this, ((MDuration *)getModule())->nslot_duration, 1.0);
    Number factor = pnsig_duration->getNumber();
    delete pnsig_duration;

    Parameterset parset_input = *parset;
    if (parset->containsDurationFactor()) factor *= parset->getDurationFactor();
    parset_input.setDurationFactor(factor);

    return  ((MDuration *)getModule())->sslot_input->getPreparedSignal(this, mi, &parset_input);
}
