#ifndef DEVICECONTROL_H_INCLUDED
#define DEVICECONTROL_H_INCLUDED

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <unistd.h>
#include <qstring.h>

#include <constants.h>
#include <dspout.h>
#include <pthread.h>

class DSPDeviceClass
{
public:
	int id;
	int pos;
	bool opened;
	bool reqopened;
	bool reqclosed;
	dspout *dspdev;
	QString deviceName;
	QString lastError;

	DSPDeviceClass();
	DSPDeviceClass( int startid, QString startDeviceName );
	~DSPDeviceClass();

	int openDevice();
	int closeDevice();
};

class MIDIDeviceClass
{
public:
	int id;
	bool opened;
	bool reqopened;
	bool reqclosed;
	QString deviceName;
	QString lastError;

	MIDIDeviceClass();
	MIDIDeviceClass( int startid, QString startDeviceName );
	~MIDIDeviceClass();

	int openDevice();
	int closeDevice();
};

class DeviceControl
{
public:
	DeviceControl();
	~DeviceControl();

	pthread_mutex_t mutex;
	pthread_cond_t doneop;

	// DSP stuff
	inline bool isDspMonoDevice() const { return dspMonoDevice; };
	inline bool isDspDeviceOpen() const { return isadeviceopen; };
	void scanDspDevices();

	// For select()
	void setAllDspDescriptors( fd_set *fds );
	void computeHighestDspFd();
	inline int getHighestDspFd() const { return highestdspfd; };

	// Woo DSPs
	DSPDeviceClass *getDspDevice( int reqid );
	void requestOpenDspDevice( int reqid );
	void requestCloseDspDevice( int reqid );
	inline DSPDeviceClass **getDspList() { return dspDevices; };

	// MIDI stuff
	inline bool isMidiDeviceOpen() const { return isamididevopen; };
	inline MIDIDeviceClass **getMidiList() { return midiDevices; };
private:
	// DSP stuff
	DSPDeviceClass *dspDevices[ MAX_DSP_DEVICES ];
	bool dspMonoDevice;    
	bool isadeviceopen;
	int lastDspDevicenum;
	int highestdspfd;

	// MIDI stuff
	MIDIDeviceClass *midiDevices[ MAX_MIDI_DEVICES ];
	bool isamididevopen;
	int lastMidiDevicenum;

	void buildDspDeviceList();
	void buildMidiDeviceList();
};

#endif // DEVICECONTROL_H_INCLUDED
