#include <stdlib.h>
#include <qlayout.h>
#include <globals.h>
#include <deviceselector.h>
#include <deviceselector.moc>

DeviceSelector::DeviceSelector( QWidget *parent )
	: QWidget( parent, 0 )
{
	setCaption( "Device Select" );

	devicelist = new QListView( this );  
	devicelist->addColumn( "ID" );
	devicelist->addColumn( "Open" );
	devicelist->addColumn( "Device Filename" );
	devicelist->addColumn( "Last Error" );
	devicelist->setAllColumnsShowFocus( true );

	openDevice = new QPushButton( this );
	openDevice->setText( "Open Device" );
	openDevice->setMaximumHeight( 20 );
	QObject::connect( openDevice, SIGNAL( pressed() ), this, SLOT( openPressed() ) );

	closeDevice = new QPushButton( this );
	closeDevice->setText( "Close Device" );
	closeDevice->setMaximumHeight( 20 );
	QObject::connect( closeDevice, SIGNAL( pressed() ), this, SLOT( closePressed() ) );

	addDevice = new QPushButton( this );
	addDevice->setText( "Add Device" );
	addDevice->setMaximumHeight( 20 );
	QObject::connect( addDevice, SIGNAL( pressed() ), this, SLOT( addPressed() ) );

	rescanList();
	resize( 250, 150 );
}

void DeviceSelector::rescanList()
{
	QString id, opened;
	DSPDeviceClass **dsplist;
	unsigned int i;

	devicelist->clear();
	dsplist = devcontrol->getDspList();

	for ( i = 0; i < MAX_DSP_DEVICES; i++ ) {
		if ( dsplist[ i ] != NULL ) {
			id.sprintf( "%d", dsplist[ i ]->id );

			if ( dsplist[ i ]->opened == true ) {
				opened.sprintf( "Yes" );
			} else {
				opened.sprintf( "No" );
			}

			(void) new QListViewItem( devicelist, id, opened, dsplist[ i ]->deviceName,
							dsplist[ i ]->lastError );
		}
	}
}

void DeviceSelector::openPressed()
{
	int curid;

	if ( devicelist->currentItem() == 0 ) { return; };
	curid = atoi( devicelist->currentItem()->text( 0 ) );

	devcontrol->requestOpenDspDevice( curid );
	rescanList();

	newDevice( curid );
}

void DeviceSelector::closePressed()
{
	int curid;

	if ( devicelist->currentItem() == 0 ) { return; };
	curid = atoi( devicelist->currentItem()->text( 0 ) );

	devcontrol->requestCloseDspDevice( curid );
	rescanList();
}

void DeviceSelector::addPressed()
{
}

void DeviceSelector::resizeEvent( QResizeEvent * )
{
	devicelist->move( 0, 0 );
	devicelist->resize( width(), height() - 20 );
	openDevice->move( 0, height() - 20 );
	openDevice->resize( width() / 3, 20 );
	closeDevice->move( openDevice->width(), height() - 20 );
	closeDevice->resize( width() / 3, 20 );
	addDevice->move( width() - ( width() / 3 ), height() - 20 );
	addDevice->resize( width() / 3, 20 );
}

LittleDeviceButton::LittleDeviceButton( QWidget *parent )
	: QWidget( parent, 0 )
{
	int curwidth, height;

	curwidth = 5; // Little space in the beginning
	height = parent->height() - 2; // Toolbar shit

	devicelabel = new QLabel( this );
	devicelabel->setText( "Output Device: " );
	devicelabel->resize( 90, height );
	devicelabel->move( curwidth, 0 );

	curwidth += devicelabel->width();

	changedevbutton = new BToolButton( false, this );
	changedevbutton->setText( "-" );
	changedevbutton->resize( 22, height );
	changedevbutton->move( curwidth, 0 );
	QObject::connect( changedevbutton, SIGNAL( pressed() ), this, SLOT( changePressed() ) );

	curwidth += changedevbutton->width();

	resize( curwidth, height );
}

void LittleDeviceButton::changePressed()
{
	if ( devselect == NULL ) {
		devselect = new DeviceSelector( 0 );
		QObject::connect( devselect, SIGNAL( newDevice( int ) ), this, SLOT( newDevice( int ) ) );
	}

	devselect->show();
}

void LittleDeviceButton::newDevice( int newdev )
{
	QString devtext;

	devtext.sprintf( "%d", newdev );
	changedevbutton->setText( devtext );
}

