#ifndef GLOBALSONG_H_INCLUDED
#define GLOBALSONG_H_INCLUDED

#include "constants.h"
#include "samplechannel.h"

#define SONG_CHAN_ON   0
#define SONG_CHAN_MUTE 1
#define SONG_CHAN_SOLO 2

#define SONG_STOPPED 0
#define SONG_PLAYING 1

#define SONG_TYPE_NONE           0
#define SONG_TYPE_SAMP_THUD      1
#define SONG_TYPE_SAMP_TRACKER   2
#define SONG_TYPE_MIDI_NONE    100
#define SONG_TYPE_MIDI_NOTE    101

class songPattern {
public:
	int note[ MAX_BEATS ];
	int index;

	songPattern();
};

class songChannel {
public:
	int type;
	int state;
	int midi_channel;
	int devnum;
	int last_note;
	bool mute;
	bool solo;
	sampleChannel sampledata;
	songPattern data[ MAX_PATTERNS ];

	songChannel();
};

class song {
private:
	// Song information
	songPattern *data[ MAX_CHANNELS ][ MAX_PATTERNS ];

	// Channel Information
	songChannel chan_data[ MAX_CHANNELS ];

	// Song control info
	int state;
	long start_sec;
	long start_usec;
	int curpat;
	int curbeat;

	// Loop Mode info
	bool loop_on;
	int loop_start;
	int loop_end;

	bool solo_mode;

	// Tempo info
	int tempo;
	int usecpb;
	int fpb;

	// These are nice if they're global
	int maxmididev;
	int maxdspdev;
	bool dspdevstate[ MAX_DSP_DEVICES ];

	// Sync Reference information
	int last_sec;
	int last_usec;
	int last_curpat;
	int last_curbeat;
public:
	song();
	void clear();

	// Control
	void startSong();
	void stopSong();
	void setSongPos( int pat, int beat );
	inline int isPlaying() const { return state; }
	inline int getCurPat() const { return curpat; }
	inline int getCurBeat() const { return curbeat; }
	inline void startTime( int *sec, int *usec ) const { *sec = start_sec; *usec = start_usec; }
	void incrBeat();
	void beatAfter( int curp, int curb, int *nextp, int *nextb );
	void getFuturePos( int iter, int *fpat, int *fbeat );

	// Song note information
	int getSongNote( int chan, int pat, int beat );
	int getSongPatternIndex( int chan, int pat );
	void setSongPattern( int chan, int pos, int pat );

	// Pattern Mode Information
	int getPatternNote( int chan, int pat, int beat );
	void setPatternNote( int chan, int pat, int beat, int value );
	int *getNoteDataPtr( int chan, int pat, int beat );

	// Channel Information
	void setChannelType( int chan, int type );
	int getChannelType( int chan );
	void setMidiChannel( int chan, int mchan );
	int getMidiChannel( int chan );
	int getChannelLastNote( int chan );
	void setChannelLastNote( int chan, int note );
	void setChannelDevice( int chan, int devnum );
	int getChannelDevice( int chan );
	bool isChannelMuted( int chan );
	void setChannelMute( int chan, bool mute );
	bool isChannelSolo( int chan );
	void setChannelSolo( int chan, bool solo );
	sampleChannel *getChannelSample( int chan );

	// Solo Mode info
	inline bool isSoloModeActive( void ) const { return solo_mode; };

	// Loop Mode info
	void setLoopPoints( int startpos, int endpos );
	inline void setLoop( bool onoff ) { loop_on = onoff; };
	inline int getLoopStart() const { return loop_start; };
	inline int getLoopEnd() const { return loop_end; };
	inline bool getLoopState() const { return loop_on; };

	// Tempo
	void setTempo( int newtempo );
	inline int getTempo() const { return tempo; }
	inline int getUsecpb() const { return usecpb; }
	inline int getFpb() const { return fpb; }

	// Song load/save
	void saveSong( int fd );
	void loadSong( int fd );

	// Devices
	void setMaxMidiDevice( int maxdevnum );
	int getMaxMidiDevice();
	void setMaxDspDevice( int maxdevnum );
	int getMaxDspDevice();
	bool dspDeviceActive( int devnum );
	void setDspDeviceActive( int devnum, bool state );

	// Sync Reference functions
	void getSyncReferenceData( int *lsec, int *lusec, int *lpat, int *lbeat );
	void setSyncReferenceData( int lsec, int lusec, int lpat, int lbeat );
};

#endif // GLOBALSONG_H_INCLUDED
