#ifndef THUD_H_INCLUDED 
#define THUD_H_INCLUDED 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <ktmainwindow.h>
#include <kspinbox.h>

#include <bbpmselect.h>
#include <bsongposition.h>
#include <deviceselector.h>
#include <thudgrid.h>
#include <dspcontrol.h>

class Thud : public KTMainWindow
{
	Q_OBJECT
public:
	Thud( QWidget *parent = 0, const char *name = 0 );
	virtual ~Thud();

protected slots:
	void invokeHelp();

private:
	KMenuBar   *menuBar;
	KStatusBar *statusBar;
	KToolBar   *toolBar;

	BBPMSelect *bpmselector;
	BSongPosition *songpos;
	LittleDeviceButton *device;
	ThudGrid *grid;

	// ToolBar Buttons
	enum {  PlayFromStartButton,
		PlayButton,
		StopButton,
		RewindButton,
		ForwardButton,
		ButtonSeparator1,
		BPMWidget,
		ButtonSeparator2,
		SongPosition,
		ButtonSeparator3,
		SetDevice };

	dspcontrol *dcontrol;
private slots:
	void toolButtonClicked( int id );
};

#endif // THUD_H_INCLUDED 
