#include <kapp.h>
#include <qpainter.h>
#include <togglecolor.h>
#include <togglecolor.moc>

ToggleColor::ToggleColor( QWidget *parent, QColor *on_color )
	: QFrame( parent, 0 )
{
	onColor = on_color;

//	setFrameStyle( QFrame::Box | QFrame::Raised );
  	setFrameStyle( QFrame::Box | QFrame::Raised );
	setLineWidth( 1 );
	setMidLineWidth( 0 );

	title = new QString( "" );

	setState( false );
}

void ToggleColor::setState( bool newstate )
{
	state = newstate;

	if ( state ) {
		QColorGroup colGrp( this->colorGroup().foreground(), *onColor,
					this->colorGroup().light(), this->colorGroup().dark(), this->colorGroup().mid(),
					this->colorGroup().text(), this->colorGroup().base() );
		QPalette onPalette( colGrp, colGrp, colGrp );

		setPalette( onPalette );
	} else {
		QColorGroup colGrp( this->colorGroup().foreground(), kapp->backgroundColor,
					this->colorGroup().light(), this->colorGroup().dark(), this->colorGroup().mid(),
					this->colorGroup().text(), this->colorGroup().base() );
		QPalette offPalette( colGrp, colGrp, colGrp );

		setPalette( offPalette );
	}

	valueChanged( state );
	repaint();
}

void ToggleColor::setText( QString newtext )
{
	if ( title != NULL ) {
		delete title;
	}

	title = new QString( newtext );
}

void ToggleColor::mousePressEvent( QMouseEvent * )
{
	setState( !state );
}

void ToggleColor::paintEvent( QPaintEvent *pev )
{
	QPainter paint( this );

	if ( title != NULL ) {
		paint.drawText( 3, 15, *title );
	}

	paint.end();

	QFrame::paintEvent( pev );
}

