#include <qpainter.h>
#include <togglepixmap.h>
#include <togglepixmap.moc>

TogglePixmap::TogglePixmap( QWidget *parent, const char *name, QPixmap *on_kp, QPixmap *off_kp )
	: QCheckBox( parent, name )
{
	onPixmap = on_kp;
	offPixmap = off_kp;
	resize( onPixmap->width(), onPixmap->height() );
}

void TogglePixmap::drawButton( QPainter *paint )
{
	if ( isOn() ) {
  		paint->drawPixmap( 0, 0, *onPixmap );
	} else {
  		paint->drawPixmap( 0, 0, (QPixmap &) *offPixmap );
	}
}

WatcherTogglePixmap::WatcherTogglePixmap( QWidget *parent, const char *name, QPixmap *on_kp, QPixmap *off_kp )
	: TogglePixmap( parent, name, on_kp, off_kp )
{
	QObject::connect( this, SIGNAL( toggled( bool ) ), this, SLOT( togged( bool ) ) );
}

void WatcherTogglePixmap::togged( bool newstate )
{
	if ( newstate == false ) {
		*watchptr = -1;
	} else {
		*watchptr = 0;
	}
}

