/**********************************************************************

	--- Qt Architect generated file ---

	File: cselector.cpp
	Last generated: Mon Jun 1 19:11:31 1998

 *********************************************************************/

#include <wintv.h>

#include "cselector.h"
#include "countries.h"
#include <qmsgbox.h>
#include <qtooltip.h> 

#include <kapp.h>
#include <klocale.h>

#ifdef myDEBUG
#define csDEBUG
#endif

#define Inherited cselectordata

cselector::cselector( QWidget* parent, const char* name, rcfile *_rc, v4lxif *_v4lxifP )
  : Inherited( parent, name ),rc(_rc),v4lxifP(_v4lxifP)
{
  int i,aktive;
#ifdef csDEBUG
  debug("cs: init");
#endif

  ch=(char *)malloc(255);
  retc= new channel();
  retc->name=0;
  retc->channelId=0;

  channelbox= new QComboBox(false,this,"listbox");
  channelbox->setGeometry( 55, 40, 70, 30 );
  connect(channelbox,SIGNAL(highlighted(const char *)),
	  this,SLOT(newChanSLOT(const char *)));

#if 1
#ifdef csDEBUG
  debug("cs: country is %s, %d",chan_names[rc->country_id].str,rc->country_id);
#endif
  aktivecntry.change(rc->country_id);
  rc->country_name=QString(chan_names[rc->country_id].str);
  fine=0;
  fineslider->setRange( -aktivecntry.smax(), aktivecntry.smax() );
  fineslider->setSteps( 1, 5 );
#endif

  int ff;
  ff=aktivecntry.firstchan(ch);
  channelbox->insertItem(ch);
  while (ff != aktivecntry.nextchan(ch) )
    channelbox->insertItem(ch);

  // fill in known conuties
  for (i=0; i <= KNOWN_COUNTRIES; i++) {
    cntry->insertItem(chan_names[i].str,i);
  }
  cntry->setCurrentItem(0);

  // fill in supported norms
  int tflags= v4lxifP->getTunerFlags();
  int tmode= v4lxifP->getChannelNorm();
  for (i = 0; norms[i].str != NULL; i++)  // XXXX
    if (tflags & (1<<i)) {
      snorm->insertItem(norms[i].str,i);
      if (tmode == i) aktive=i;
    }
  snorm->setCurrentItem(aktive);

  // fill in known input sources
  for (i = 0; i < v4lxifP->capCapChannelC(); i++) {
    sinput->insertItem(v4lxifP->capChannelName(i),i);
  }

  QToolTip::add(cntry,i18n("select your country"));
  QToolTip::add(b_down,i18n("channel down"));
  QToolTip::add(b_up,i18n("channel up"));
  QToolTip::add(sinput,i18n("input device of TV card"));
  QToolTip::add(snorm,i18n("TV norm"));
  QToolTip::add(fineslider,i18n("fine tune channel"));
  QToolTip::add(b_autoscanup,i18n("scan upwards to channel with good singnal quality"));
  QToolTip::add(b_autoscandown,i18n("scan downwards to channel with good singnal quality"));
  QToolTip::add(b_autoscanstop,i18n("stop scan"));
  QToolTip::add(channelbox,i18n("select channel"));
  noscan=FALSE;
}
cselector::~cselector()
{
  free(ch);
  delete retc;
}
void cselector::setDataSLOT(channel *c)
{
  if (!c) return;

#ifdef csDEBUG
  debug("cs: setData, c->country = %d, rc->country_id = %d, cid = %d, item = %d",
	c->country,rc->country_id,aktivecntry.cid(),cntry->currentItem());
#endif

  retc->frequency=c->frequency;
  retc->country=c->country;
  if ( retc->country == -1 ) {
    cntry->setCurrentItem(rc->country_id);
    newCountrySLOT(rc->country_id);
  } else if ( retc->country != aktivecntry.cid() ) {
    cntry->setCurrentItem(retc->country);
    newCountrySLOT(retc->country);
  } else if ( retc->country != cntry->currentItem() ) {
    cntry->setCurrentItem(retc->country);
  }

  chname->setText(c->name);
  if (retc->name) {
    delete retc->name;
    retc->name=0;
  }
  if ( c->name ) {
    retc->name=new char[strlen(c->name)+1];
    strcpy(retc->name,c->name);
  }

  snorm->setCurrentItem(c->norm);
  retc->norm=c->norm;
  sinput->setCurrentItem(c->input);
  retc->input=c->input;
    
  aktivecntry.setchan(aktivecntry.freqtochan(retc->frequency));
  int finefreq=  -(aktivecntry.activechan(ch) - retc->frequency);
  fineslider->setValue(finefreq);
  lcd1->display(finefreq);
  channelbox->setCurrentItem(aktivecntry.activeindex()-1);

#ifdef csDEBUG
  debug("cs: setData set cid %s",c->channelId);
#endif

  if (retc->channelId) {
    delete retc->channelId;
    retc->channelId=0;
  }
  if ( c->channelId && strcmp(c->channelId,"??") ) {
    retc->channelId=new char[strlen(c->channelId)+1];
    strcpy(retc->channelId,c->channelId);
  } else {
    retc->channelId=new char[strlen(ch)+1];
    strcpy(retc->channelId,ch);
  }
#ifdef csDEBUG
  debug("cs: setData done set cid %s",retc->channelId);
#endif

  bool hastuner= v4lxifP->capChannelTuner(v4lxifP->getChannelActive());
  b_down->setEnabled(hastuner);
  b_up->setEnabled(hastuner);
  cntry->setEnabled(hastuner);
  fineslider->setEnabled(hastuner);
  b_autoscanup->setEnabled(hastuner);
  b_autoscandown->setEnabled(hastuner);
  b_autoscanstop->setEnabled(hastuner);
  channelbox->setEnabled(hastuner);
  snorm->setEnabled(v4lxifP->capChannelNorm(v4lxifP->getChannelActive()));

  emit newRangeSIGNAL(aktivecntry.fmin(),aktivecntry.fmax(),aktivecntry.smax());
  emit frequencyChangedSIGNAL(retc->frequency);
#ifdef csDEBUG
  debug("cs: setData done");
#endif
}
void cselector::channelDownSLOT()
{
  fine=0;
  fineslider->setValue(0);
  lcd1->display(0);
  retc->frequency=aktivecntry.prevchan(ch);

  //retc->channelId=ch;
  if (retc->channelId) delete retc->channelId;
  retc->channelId=new char[strlen(ch)+1];
  strcpy(retc->channelId,ch);

  channelbox->setCurrentItem(aktivecntry.activeindex()-1);
  emit frequencyChangedSIGNAL(retc->frequency);
#ifdef csDEBUG
  debug("cs: new channel: %s %d, % .3f",ch,retc->frequency,retc->frequency/16.0);
#endif
}
void cselector::channelUpSLOT()
{
  fine=0;
  fineslider->setValue(0);
  lcd1->display(0);
  retc->frequency=aktivecntry.nextchan(ch);

  //retc->channelId=ch;
  if (retc->channelId) delete retc->channelId;
  retc->channelId=new char[strlen(ch)+1];
  strcpy(retc->channelId,ch);

  channelbox->setCurrentItem(aktivecntry.activeindex()-1);
  emit frequencyChangedSIGNAL(retc->frequency);
#ifdef csDEBUG
  debug("cs: new channel: %s %d % .3f",ch,retc->frequency,retc->frequency/16.0);
#endif
}
void cselector::channelNameSLOT(const char* name)
{
#ifdef csDEBUG
  //debug("cs: new name: %s",name);
#endif
  if (retc->name) delete retc->name;
  retc->name=new char[strlen(name)+2];
  strcpy(retc->name,name);
#ifdef csDEBUG
  //debug("cs: new name: %s",name);
#endif
}
void cselector::newCountrySLOT(int id)
{
#ifdef csDEBUG
  debug("cs: new country: %s %d",chan_names[id].str,id);
#endif
  aktivecntry.change(id);
  channelbox->clear();

  int ff=aktivecntry.firstchan(ch);
  channelbox->insertItem(ch);
  while ( ff != aktivecntry.nextchan(ch) )
    channelbox->insertItem(ch);

  rc->country_id=id;
  rc->country_name=QString(chan_names[id].str);
  retc->country= id;
  if (aktivecntry.setchan(aktivecntry.freqtochan(retc->frequency))) {
    retc->frequency=aktivecntry.activechan(ch);
  } else {
    retc->frequency=aktivecntry.firstchan(ch);
  }

  if (retc->channelId) delete retc->channelId;
  retc->channelId=new char[strlen(ch)+1];
  strcpy(retc->channelId,ch);

  fineslider->setRange( -aktivecntry.smax(), aktivecntry.smax() );
  fine=0;
  fineslider->setValue(0);
  lcd1->display(0);
#ifdef csDEBUG
  debug("cs: fine tuning range: %d --> %d",-aktivecntry.smax(),aktivecntry.smax());
#endif
  emit frequencyChangedSIGNAL(retc->frequency);
  emit newRangeSIGNAL(aktivecntry.fmin(),aktivecntry.fmax(),aktivecntry.smax());
}
void cselector::newInputSLOT(int id)
{
  retc->input=id;
  emit inputChangedSIGNAL(id);

  snorm->setEnabled(v4lxifP->capChannelNorm(id));
  if (v4lxifP->capChannelNorm(id)) {
    snorm->setCurrentItem(retc->norm);
  }

  bool chHasTuner= v4lxifP->capChannelTuner(id);
  b_down->setEnabled(chHasTuner);
  b_up->setEnabled(chHasTuner);
  cntry->setEnabled(chHasTuner);
  fineslider->setEnabled(chHasTuner);
  b_autoscanup->setEnabled(chHasTuner);
  b_autoscandown->setEnabled(chHasTuner);
  b_autoscanstop->setEnabled(chHasTuner);
  channelbox->setEnabled(chHasTuner);

  if ( !chHasTuner ) {
    if (retc->channelId) delete retc->channelId;
    retc->channelId=new char[6];
    strcpy(retc->channelId,"(cam)");

    //retc->channelId=new char[strlen(v4lxifP->capChannelName(id))+1];
    //strcpy(retc->channelId,v4lxifP->capChannelName(id));

    // hu, well, do we want this??
    chname->setText(v4lxifP->capChannelName(id));
  }

#ifdef csDEBUG
  debug("cs: new input source: %d, has tuner: %s",id,chHasTuner?"yes":"no");   
#endif
}
void cselector::newNormSLOT(int id)
{
  retc->norm=id;
  emit normChangedSIGNAL(retc->norm);
#ifdef csDEBUG
  debug("cs: new norm: %d",id);   
#endif
}
void cselector::newFineSLOT(int f)
{
  if (fine != f) {
    fine=f;
    retc->frequency=aktivecntry.activechan(ch)+f;
    emit frequencyChangedSIGNAL(retc->frequency);
    lcd1->display(fine);
#ifdef csDEBUG
    debug("cs: new fine freq: %d",f);   
#endif
  }
}
void cselector::newChanSLOT(const char *name)
{
#ifdef csDEBUG
  debug("cs: new channel (box): %s, fr %d, fi %d, % .3f",name,retc->frequency,fine,retc->frequency/16.0);   
#endif
  fine=0;
  if (!aktivecntry.setchan(name)) fatal("hardcore error 00002");
  retc->frequency=aktivecntry.cftofreq((char*)name,0);
  aktivecntry.freqtochan(retc->frequency);
  emit frequencyChangedSIGNAL(retc->frequency);

  fineslider->setValue(0);
  lcd1->display(0);

  if (retc->channelId) delete retc->channelId;
  retc->channelId=new char[strlen(name)+1];
  strcpy(retc->channelId,name);

#ifdef csDEBUG
  debug("cs: new channel done");   
#endif
}

void cselector::autoScanDownSLOT()
{
  quality= 0;
  tc= aktivecntry.activeindex();
  sdir=-1;
  
  if (sdir) {
    channelDownSLOT();
#ifdef csDEBUG
    debug("cs: new channel: %d",aktivecntry.activeindex());
#endif
     QTimer::singleShot( TIMEWAIT, this, SLOT(autoScanCheckSLOT()) );
  }
}
void cselector::autoScanStopSLOT()
{
  sdir=0;
}
void cselector::autoScanUpSLOT()
{
  quality= 0;
  tc= aktivecntry.activeindex();
  sdir=1;
  
  if (sdir) {
    channelUpSLOT();
#ifdef csDEBUG
    debug("cs: new channel: %d",aktivecntry.activeindex());
#endif
     QTimer::singleShot( TIMEWAIT, this, SLOT(autoScanCheckSLOT()) );
  }
}
void cselector::autoScanCheckSLOT()
{
  quality = v4lxifP->getTunerSignal();
  if ((quality <= SIGQUALITY) && (tc != aktivecntry.activeindex())) {
    switch (sdir) {
    case -1: autoScanDownSLOT();
      break;
    case 1: autoScanUpSLOT();
      break;
    }
  }
}
#include "cselector.moc"





