#ifndef ppmvideoclip_h
#define ppmvideoclip_h

#include <videoclip.h>

#ifdef HAVE_LIBJPEG
#ifdef __cplusplus
extern "C" {          // jpeglib is pure C 
#endif
# include "jpeglib.h"
#ifdef __cplusplus
}
#endif
#endif

/*------------------------------------------------------------------------------*/

class ppmVideoClip : public videoClip
{
public:
  ppmVideoClip();
  // ~ppmVideoClip();

  int open(char *filename, struct MOVIE_PARAMS *par);
  int writeframe(char * data);
  int close();

  int nframes() { return frames; }

protected:
  void patch_up(char *name);

private:
  int frame_bytes, screen_bytes;
  unsigned char *framebuf;
  int rc;
  
  char header[80];
  FILE *fp;

#ifdef HAVE_LIBJPEG
  struct jpeg_compress_struct cinfo;
  struct jpeg_error_mgr jerr;
  int i;
  unsigned char *line;
#endif
};

#endif ppmvideoclip_h





