/* 
    xWinTV using Bt848 frame grabber driver

    Copyright (C) 1998 Moritz Wenk (wenk@mathematik.uni-kl.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef lswidget_included
#define lswidget_included

// uncomment to enable drag & drop
//#define DRAGDROP

#include <wintv.h>

#include <qapp.h>
#include <qlist.h>
#include <qpixmap.h>
#include <qwidget.h>
#include <qlistview.h> 
#include <qtooltip.h>
#include <qpopmenu.h>
#include <qbutton.h>
#include <qpushbutton.h> 
#include <qslider.h> // use KSlider in later versions of KDE

#include <kapp.h>
#include <ktoolbar.h>
#include <ktopwidget.h>

#include <rcfile.h>
#include <channel.h>
#include <mixer.h>
#include <v4lxif.h>

/* ------------------------------------------------------------------------------*/
/* ------------------------------------------------------------------------------*/

class winSlider : public QWidget
{
  Q_OBJECT
public:
  winSlider ( int _min=0, int _max=100, int _val=0, 
	      bool _stereo= false, bool _muteable= false, 
	      QPixmap * pix= NULL, QWidget * parent=0, const char * name=0 );
  ~winSlider ();

  bool isSplited() { return splited; }
  bool isMuted() { return muted; }
  bool isEnabled() { return mm; }

public slots:
  void setLValue( int );
  void setRValue( int );
  void split( bool );  // true: both, false: one slider
  void mute( bool );
  void setEnabled( bool ); // true: enabled, false: disabled

signals:
  void valueChanged( int, int );
  void splitChanged( bool );
  void muteChanged( bool );

private slots:
  void valueLChangedI( int );
  void valueRChangedI( int );
  void popupSLOT( int id );

protected:
  void resizeEvent ( QResizeEvent * );
  bool eventFilter( QObject *o, QEvent *e );

private:
  QSlider *sleft,*sright;
  QPopupMenu *sPopup;
  QLabel * icon;
  int sid[10];
  int lval,rval;
  int min,max;
  int yoff;
  bool muteable,stereo;
  bool splited,muted; 
  bool mm;
};

/* ------------------------------------------------------------------------------*/
/* ------------------------------------------------------------------------------*/

class winMixer : public QWidget
{
  Q_OBJECT
public:
  winMixer( rcfile * _rc= 0, QWidget * parent=0, const char * name=0 );
  ~winMixer();

  void setV4lifP( v4lxif * _if ) { v4l=_if; }

  mixer * getVolMixMixerP() { return mvol; }

public slots:
  void setVolume( int, int );
  void setTreble( int, int );
  void setBass( int, int );
  void showMixer();
  void volMute( bool );

signals:
  void volChanged( int, int );
  void volLChanged( int );
  void volRChanged( int );
  void volMuteChanged( bool );

private slots:
  void vol( int, int );
  void bass( int, int );
  void treble( int, int );
  void changeSize( bool );
  void volMuteI( bool );
  
protected:
  void resizeEvent ( QResizeEvent * );

private:
  rcfile * rc;
  winSlider * volmix;
  winSlider * treblemix;
  winSlider * bassmix;
  mixer * mvol;
  mixer * mtreble;
  mixer * mbass;
  v4lxif * v4l;
  QPushButton * logo;
  QPixmap logopm;

  int xoff;
  int logowidth,logoheight;
};

/* ------------------------------------------------------------------------------*/
/* ------------------------------------------------------------------------------*/

class winListBox : public QListView
{
  Q_OBJECT
public:
  winListBox ( QWidget * parent=0, const char * name=0 ) : QListView ( parent,name ), 
    pressedButton( 0 ), oldY(0), itemWasMoved( false ), cursorChanged( false )
    {  setMouseTracking (true); }

  void setCPopup(QPopupMenu *sp) { cPopup=sp; }

protected:
  void mouseReleaseEvent ( QMouseEvent * me);
#ifdef DRAGDROP
  void mousePressEvent ( QMouseEvent * me);
#endif
  void mouseMoveEvent ( QMouseEvent * me);

signals:
  void moveItemSIGNAL( QListViewItem *, QListViewItem * );

private:
  QPopupMenu *cPopup;
  QListViewItem *toMoveItem, *lastVisItem;
  int pressedButton;
  int oldY;
  bool itemWasMoved;
  bool cursorChanged;
};

/* ------------------------------------------------------------------------------*/
/* ------------------------------------------------------------------------------*/

class winWidget : public QWidget
{
  Q_OBJECT
public:
  winWidget(QWidget* parent = NULL, const char* name = NULL);
  ~winWidget();

  void setCPopup(QPopupMenu *cp) { cPopup=cp;channelList->setCPopup(cPopup); }

public slots:
  void insertItem ( const channel* info, bool ins );  
  void removeItem ( int index ); 
  void changeItem ( const char * text, int index ); 
  void repaintItem();
  void setCurrentItem ( int index );  
  void centerCurrentItem ();  
  void clear();

protected slots:
  void highlightedSLOT(QListViewItem * item);
  void channelEditSelectSLOT(QListViewItem * item);
  void moveItemSLOT( QListViewItem *, QListViewItem * );

protected:
  void resizeEvent( QResizeEvent * );

signals:
  void highlighted(int id);
  void channelEditSelectSIGNAL();
  void moveItemSIGNAL( int from, int to);

private:
  winListBox* channelList;

  QList<QListViewItem> aChannelList;

  QPopupMenu *cPopup;

  bool inserting;
};

/* ------------------------------------------------------------------------------*/
/* ------------------------------------------------------------------------------*/

class winTVChannelWidget : public KTopLevelWidget
{
  Q_OBJECT
public:
  winTVChannelWidget(QWidget* parent = NULL,const char* name = NULL, rcfile *_rc=NULL );
  ~winTVChannelWidget();

  void setPopup(QPopupMenu *cp);

public slots:
  void newChannelListSLOT(QList<channel> *clist);
  void activeChannelChangedSLOT();
  void toggleVisibilitySLOT( QPoint *to );

protected slots:
  void buttonsSLOT(int);
  void channelSelectedEmitSLOT(int);
  void channelEditEmitSLOT();
  void moveItemSLOT(int from, int to);

signals:
  void channelSelectedSIGNAL();
  void addChannelSIGNAL();
  void editChannelSIGNAL();
  void deleteChannelSIGNAL();
  void copyChannelSIGNAL();
  void pasteChannelSIGNAL();

private:
  winWidget *channelbox;
  KToolBar *toolbar;

  QPixmap  pm;
  QPixmap  ch_add_xpm, ch_edit_xpm, ch_delete_xpm, mup_xpm, mdown_xpm, cs_xpm;
  
  rcfile *rc;

  QList<channel> *clistp;

  bool inserting;
};

#endif










