/* 
    xWinTV using Bt848 frame grabber driver

    Copyright (C) 1998 Moritz Wenk (wenk@mathematik.uni-kl.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <wintv.h>
#include <qfiledlg.h> 
#include <qmsgbox.h>

#include <kapp.h>
#include <kiconloader.h>
#include <klocale.h>

#include <wintvvclip.h>

#ifdef myDEBUG
#define vcDEBUG
#endif

#define SB_FRAMES_TXT 1
#define SB_FRAMES     2
#define SB_FLOST_TXT  3
#define SB_FLOST      4
#define SB_FPS_TXT    5
#define SB_FPS        6

/* ------------------------------------------------------------------------------*/
/* ------------------------------------------------------------------------------*/

winTVVClipWidget::winTVVClipWidget(QWidget* parent, const char* name, rcfile *_rc)
  :  KTopLevelWidget( name ),rc(_rc)
{
#ifdef vcDEBUG
  debug("vc: begin of init");
#endif

  setCaption((const char*)(QString("kWinTV - Video Clip Streamer")));
  // set icon
  KIconLoader *loader = kapp->getIconLoader();

  pm = loader->loadIcon("kwintv_logo.xpm");
  setIcon(pm);
  setIconText("kWinTV - Video Clip Streamer");

  /////////////////////////////////////////////////////////////////////////////
  statusbar= new KStatusBar(this,"statusbar");
  statusbar->insertItem("frames:",SB_FRAMES_TXT);
  statusbar->insertItem("000000",SB_FRAMES);
  statusbar->insertItem("frames lost:",SB_FLOST_TXT);
  statusbar->insertItem("000000",SB_FLOST);
  statusbar->insertItem("fps",SB_FPS_TXT);
  statusbar->insertItem("000000",SB_FPS);
  
  setStatusBar(statusbar);

  /////////////////////////////////////////////////////////////////////////////
  QPopupMenu *filemenu=new QPopupMenu;
  filemenu->insertItem(i18n("Save &As"),this,SLOT(saveAsSLOT()));
  filemenu->insertSeparator();
  filemenu->insertItem(i18n("&Close"),this,SLOT(toggleVClipSLOT()));

  QPopupMenu *optionsmenu=new QPopupMenu;
  optionsmenu->insertItem(i18n("Show/Hide Statusbar"),this,SLOT(toggleStatusBarSLOT()));
  optionsmenu->insertSeparator();
  optionsmenu->insertItem(i18n("&Options"),this,SLOT(optionsSLOT()));

  // menu bar  
  KMenuBar *menubar = new KMenuBar( this, "kwintv -- MenuBar --" );
  menubar->insertItem(i18n("&File"),filemenu);
  menubar->insertItem(i18n("&Options"),optionsmenu);
  setMenu(menubar);

  /////////////////////////////////////////////////////////////////////////////
  vclip= new cvclip(this,rc);
  setView(vclip);

  /////////////////////////////////////////////////////////////////////////////
  par.video_format=rc->vc_format;
  par.width=rc->vc_width;
  par.height=rc->vc_height;
  par.fps=rc->vc_fps;
  if (rc->vc_audiocapture) par.channels=rc->vc_channels; 
  else par.channels=0;
  par.audio_format=rc->vc_audioformat;
  par.bits=rc->vc_bits;
  par.rate=rc->vc_rate;
  strcpy(par.filename,(const char *)rc->vc_tempName);
  par.video_clip=rc->vc_video_clip;

  /////////////////////////////////////////////////////////////////////////////
  QString name(par.filename);
  name.append(VIDNAME);
  if ( rc->vc_video_clip ) name.append("xxxxx");
  name.append(formats[rc->vc_video_clip].format[rc->vc_format].ext);
  vclip->cvsetfileSLOT((const char *)name);

  /////////////////////////////////////////////////////////////////////////////
  // set up ctab dialogs
  tab= new vtab();
  cvvideo= new cvclipvideo(tab);
  cvaudio= new cvclipaudio(tab);
  tab->addTab(cvvideo,"Video");
  tab->addTab(cvaudio,"Audio");

  tab->setCancelButton();
  tab->setOkButton();
  tab->setDefaultButton();

  /////////////////////////////////////////////////////////////////////////////
  // connect everything
  connect(vclip,SIGNAL(cvcloseSIGNAL()),this,SLOT(toggleVClipSLOT()));
  connect(vclip,SIGNAL(cvoptionsSIGNAL()),this,SLOT(optionsSLOT()));
  connect(vclip,SIGNAL(cvstartcaptureSIGNAL()),this,SLOT(vclipSLOT()));

  // connect ctab dialog apply, cancel, default
  connect(tab,SIGNAL(applyButtonPressed()),this,SLOT(applyTabSLOT())); 
  connect(tab,SIGNAL(cancelButtonPressed()),this,SLOT(cancelTabSLOT())); 
  connect(tab,SIGNAL(defaultButtonPressed()),this,SLOT(defaultTabSLOT()));

  clip=TRUE;

  //setMinimumSize( 200, 100 );
  resize( vclip->width(), vclip->height()+menubar->height()+statusbar->height() );
}

/* ------------------------------------------------------------------------------*/

winTVVClipWidget::~winTVVClipWidget()
{
#ifdef vcDEBUG
  debug("vc: destroying winTVVClipWidget");
#endif

  delete statusbar;
  delete cvvideo;
  delete cvaudio;
  delete tab;

#ifdef vcDEBUG
  debug("vc: winTVVClipWidget destroyed");
#endif
}

/* ------------------------------------------------------------------------------*/

void winTVVClipWidget::toggleVClipSLOT()
{
  statusbar->changeItem("000000",SB_FRAMES);
  statusbar->changeItem("000000",SB_FLOST);
  statusbar->changeItem("000000",SB_FPS);
  if (!clip) {
    vclip->cvsetbtextSLOT("Start Capture");
    emit endVClipSIGNAL();
    clip=TRUE;
  }
  if (isVisible()) hide();
  else show();
}

/* ------------------------------------------------------------------------------*/

void winTVVClipWidget::optionsSLOT()
{
  cvvideo->vcsetdataSLOT(rc);
  cvaudio->vcsetdataSLOT(rc);
  tab->show();
}

/* ------------------------------------------------------------------------------*/

void winTVVClipWidget::saveAsSLOT()
{
  QString fileName = 
    QFileDialog::getSaveFileName(".",QString("*")+QString(par.extension),this,NULL);
  if ( !fileName.isNull() ) {                 // got a file name
    // copy tmp avi file to file filename
    if (system((const char *)QString("mv ")+QString(par.filename)+QString(" ")+fileName))
      QMessageBox::warning( this, "kWinTV",i18n("Was unable to move file %s to file %s"),
			    par.filename,(const char *)fileName);  
  }
}

/* ------------------------------------------------------------------------------*/

void winTVVClipWidget::toggleStatusBarSLOT()
{
  if ( statusbar->isVisible() ) statusbar->hide();
  else statusbar->show();
  updateRects();
}

/* ------------------------------------------------------------------------------*/

void winTVVClipWidget::vclipSLOT()
{
#ifdef vcDEBUG
  debug("vc: video clip: %s",clip?"start":"stop");
#endif
  if (clip) {     // start capturing
    clip=FALSE;
    vclip->cvsetbtextSLOT("Stop Capture");
    if (rc->vc_audiocapture) 
      par.channels=cvaudio->getData()->vc_channels;
    else // no audio 
      par.channels=0;
    par.width=rc->vc_width;
    par.height=rc->vc_height;
    emit startVClipSIGNAL(&par);
  } else {         // end capturing
    clip=TRUE;
    vclip->cvsetbtextSLOT("Start Capture");
    emit endVClipSIGNAL();
  }
  
}

// =============================================================================== 

void winTVVClipWidget::frameVClipSLOT(int c)
{
  statusbar->changeItem(dummy.setNum(c),SB_FRAMES);
}

// =============================================================================== 

void winTVVClipWidget::framelostVClipSLOT(int c)
{
  statusbar->changeItem(dummy.setNum(c),SB_FLOST);
}

void winTVVClipWidget::statVideoClipFrameSLOT(double d)
{
   statusbar->changeItem(dummy.setNum(d),SB_FPS);
}

void winTVVClipWidget::applyTabSLOT()
{
  if (rc->vc_audiocapture) par.channels=cvaudio->getData()->vc_channels;
  else par.channels=0;
  rc->vc_channels=cvaudio->getData()->vc_channels;
  rc->vc_bits=par.bits=cvaudio->getData()->vc_bits;
  rc->vc_rate=par.rate=cvaudio->getData()->vc_rate;

  rc->vc_fps=par.fps=cvvideo->getData()->vc_fps;
  rc->vc_video_clip=par.video_clip=cvvideo->getData()->vc_video_clip;
  rc->vc_format=par.video_format=cvvideo->getData()->vc_format;
  strcpy(par.filename,cvvideo->getPrefix());
  rc->vc_tempName=par.filename;

  QString name(par.filename);
  name.append(VIDNAME);
  if ( rc->vc_video_clip ) name.append("xxxxx");
  name.append(formats[rc->vc_video_clip].format[rc->vc_format].ext);
  vclip->cvsetfileSLOT((const char *)name);
}
void winTVVClipWidget::defaultTabSLOT()
{
  cvvideo->vcsetdataSLOT(rc);
  cvaudio->vcsetdataSLOT(rc);
}
void winTVVClipWidget::cancelTabSLOT()
{
  if (rc->vc_audiocapture) par.channels=rc->vc_channels; 
  else par.channels=0;
}
// =============================================================================== 
// =============================================================================== 
// =============================================================================== 
// never change the next line!
#include "wintvvclip.moc"

// end of file










