/* 
    kwintv using Bt848 frame grabber driver

    Copyright (C) 1998 Moritz Wenk (wenk@mathematik.uni-kl.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef winvtxmainincluded
#define winvtxmainincluded

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qpixmap.h>
#include <qwidget.h>
#include <qpainter.h> 

#include <kapp.h>
#include <kbutton.h>
#include <ktoolbar.h>
#include <ktopwidget.h>
#include <kstatusbar.h>

#ifdef HAVE_KDE11
#include <kaccel.h>        // KDE 1.1
#include <kkeydialog.h>
#else
#include <kkeyconf.h>      // KDE 1.0
#endif

#include <parsecl.h>

#ifdef __cplusplus
extern "C" {          // jpeglib is pure C 
#endif
#include <sys/vtx.h>
#include <fileio.h>
#ifdef __cplusplus
}
#endif

struct _page_ref {
  int page;
  QRect rect;
  int fga,bga;
};

class pagedir;
class cachedir;

class winVTXMainWidget : public KTopLevelWidget
{

  Q_OBJECT

public:
  winVTXMainWidget( parsecl * pcl = 0, QWidget* parent = 0, const char* name = 0 );
  ~winVTXMainWidget();

public slots:
  void showVTXPageSLOT( vtxpage_t * page );

protected slots:
 
signals:
 
  
private slots:
  void closeRequestSLOT();
  void loadVTXSLOT();
  void saveAsVTXSLOT();
  void exportAsSLOT(int);
  
  void newCPageSLOT(const char *);
  void newCSubPageSLOT(const char *);

  void buttonsSLOT(int);
  void newFontSLOT(int);

  void newProgramSLOT( const char * );

protected:
  void paintEvent( QPaintEvent * );
  void mouseReleaseEvent ( QMouseEvent * );
  //  void mousePressEvent ( QMouseEvent * );

private:
  void showVTXPage( vtxpage_t * page, bool insert = true );

  void insertPageToCombos( int p, int sp );

  void setNewFontSize( int size );  // size = 12,18,24
 
private:
  // the toolbars
  KToolBar* toolbar, *ctoolbar;
  KMenuBar* menubar;
  KStatusBar* statusbar;

  QPixmap  pm;

  QPopupMenu *fmenu;

  QWidget *vtxout;
  QPainter *vtxp;
  QPixmap *vtxmap;

  char dummy[2];
  
  int fm_width,fm_height;

  int currFSize;
  int currPage,currSubPage,lastPage,lastSubPage;
  
  QString currProgram;
  QString cacheDir;

  int vtx_charset;
  int yoffset,ytoffset;
  bool inInitPhase;

  QList <struct _page_ref> pagelist;
  
  pagedir * pages;
  cachedir * channels;

  vtxpage_t * cpagep;

  QStrList *cplist,*csplist;
};


#endif

