/************************************************************
        Copyright (c) 1998 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/

#include "scopeDialog.h"
#include "scopeDialog.moc"
#include "advancedDialog.h"
#include <qlayout.h>


scopeDialog::scopeDialog (scopeAddresses *sa,QWidget* parent, const char* name) 
                        : QDialog ( parent, name, TRUE, 634880 )
{

  QBoxLayout *topLayout = new QVBoxLayout(this, 10);
  QBoxLayout *buttonLayout = new QHBoxLayout();

  IP_poolBox = new QGroupBox(i18n("IP Address Pool"),this);
  IP_poolBox->setFixedSize(550,270);
  topLayout->addWidget(IP_poolBox,10);

  LeasesBox = new QGroupBox(i18n("Default Lease Duration"),this);
  LeasesBox->setFixedSize(550,90);
  topLayout->addWidget(LeasesBox, 10);

  MaxLeasesBox = new QGroupBox(i18n("Maximum Lease Duration"),this);
  MaxLeasesBox->setFixedSize(550,90);
  topLayout->addWidget(MaxLeasesBox, 10);

  topLayout->addLayout(buttonLayout);

  QFont font( "helvetica", 10, 50, 0 );
  font.setStyleHint( (QFont::StyleHint)0 );
  font.setCharSet( (QFont::CharSet)0 );

  Help_Button = new QPushButton(i18n("Help"), this);
  Help_Button->setMinimumSize(Help_Button->sizeHint());
  connect( Help_Button, SIGNAL(clicked()), SLOT(Help_Click()) );
  buttonLayout->addWidget(Help_Button);
  Help_Button->setEnabled(false);

  buttonLayout->addStretch(10);

  Advanced_Button = new QPushButton(i18n("Advanced"), this);
  Advanced_Button->setMinimumSize(Advanced_Button->sizeHint());
  connect( Advanced_Button, SIGNAL(clicked()), SLOT(Advanced_Click()) );
  buttonLayout->addWidget(Advanced_Button);

  Ok_Button = new QPushButton(i18n("Ok"), this);
  Ok_Button->setMinimumSize(Ok_Button->sizeHint());
  connect( Ok_Button, SIGNAL(clicked()), SLOT(OK_Click()) );
  buttonLayout->addWidget(Ok_Button);

  Cancel_Button = new QPushButton(i18n("Cancel"), this);
  Cancel_Button->setMinimumSize(Cancel_Button->sizeHint());
  connect( Cancel_Button, SIGNAL(clicked()), SLOT(Cancel_Click()) );
  buttonLayout->addWidget(Cancel_Button);
  
  Subnet_Label = new QLabel(i18n("Subnet:"), IP_poolBox);
  Mask_Label = new QLabel(i18n("Subnet Mask:"), IP_poolBox);
  Routers_Label = new QLabel(i18n("Routers:"), IP_poolBox);
  DomainName_Label = new QLabel(i18n("Domain Name:"), IP_poolBox);
  NameServers_Label = new QLabel(i18n("Name Servers:"), IP_poolBox);
  NetbiosNameServers_Label = new QLabel(i18n("Wins Servers:"), IP_poolBox);
  Range_Label = new QLabel(i18n("Inclusion Range:"), IP_poolBox);
  Ex_Start_IP_Label = new QLabel(i18n("Start Address:"), IP_poolBox);
  Ex_End_IP_Label = new QLabel(i18n("End Address:"), IP_poolBox);

  AddButton = new QPushButton(i18n("Add ->"), IP_poolBox);
  RemoveButton = new QPushButton(i18n("<- Remove"), IP_poolBox);

  buttonSize = AddButton->sizeHint().width();
  if(buttonSize < RemoveButton->sizeHint().width())
    buttonSize = RemoveButton->sizeHint().width();
  
  widthSize = Subnet_Label->sizeHint().width();
  if(widthSize < Mask_Label->sizeHint().width())
    widthSize = Mask_Label->sizeHint().width();
  if(widthSize < Routers_Label->sizeHint().width())
    widthSize = Routers_Label->sizeHint().width();
  if(widthSize < Ex_Start_IP_Label->sizeHint().width())
    widthSize = Ex_Start_IP_Label->sizeHint().width();
  if(widthSize < Ex_End_IP_Label->sizeHint().width())
    widthSize = Ex_End_IP_Label->sizeHint().width();

  domainSize = DomainName_Label->sizeHint().width();
  if(widthSize < NameServers_Label->sizeHint().width())
    widthSize = NameServers_Label->sizeHint().width();
  if(widthSize < NetbiosNameServers_Label->sizeHint().width())
    widthSize = NetbiosNameServers_Label->sizeHint().width();

  Subnet_Label->setGeometry(10,20,widthSize,Subnet_Label->sizeHint().height());
  Mask_Label->setGeometry(10,45,widthSize,Mask_Label->sizeHint().height());
  Routers_Label->setGeometry(10,70,widthSize,Routers_Label->sizeHint().height());
  DomainName_Label->setGeometry(10,95,domainSize,DomainName_Label->sizeHint().height());
  NameServers_Label->setGeometry(10,120,domainSize,NameServers_Label->sizeHint().height());
  NetbiosNameServers_Label->setGeometry(10,145,domainSize,NetbiosNameServers_Label->sizeHint().height());
  Range_Label->setGeometry(10,170,Range_Label->sizeHint().width(),Range_Label->sizeHint().height());
  Ex_Start_IP_Label->setGeometry(10,190,widthSize,Ex_Start_IP_Label->sizeHint().height());
  Ex_End_IP_Label->setGeometry(10,210,widthSize,Ex_End_IP_Label->sizeHint().height());

  Subnet_Edit1 = new QLineEdit(IP_poolBox);
  Subnet_Edit1->setGeometry((widthSize+20), 20,25, 20 );
  Subnet_Edit1->setFont( font );
  Subnet_Edit1->setMaxLength(3);

  Subnet_Edit2 = new QLineEdit(IP_poolBox);
  Subnet_Edit2->setGeometry((widthSize+46), 20,25, 20 );
  Subnet_Edit2->setFont( font );
  Subnet_Edit2->setMaxLength(3);

  Subnet_Edit3 = new QLineEdit(IP_poolBox);
  Subnet_Edit3->setGeometry((widthSize+72), 20,25, 20 );
  Subnet_Edit3->setFont( font );
  Subnet_Edit3->setMaxLength(3);

  Subnet_Edit4 = new QLineEdit(IP_poolBox);
  Subnet_Edit4->setGeometry((widthSize+98), 20,25, 20 );
  Subnet_Edit4->setFont( font );
  Subnet_Edit4->setMaxLength(3);

  Mask_Edit1 = new QLineEdit(IP_poolBox);
  Mask_Edit1->setGeometry((widthSize+20), 45,25, 20 );
  Mask_Edit1->setFont( font );
  Mask_Edit1->setMaxLength(3);

  Mask_Edit2 = new QLineEdit(IP_poolBox);
  Mask_Edit2->setGeometry((widthSize+46), 45,25, 20 );
  Mask_Edit2->setFont( font );
  Mask_Edit2->setMaxLength(3);

  Mask_Edit3 = new QLineEdit(IP_poolBox);
  Mask_Edit3->setGeometry((widthSize+72), 45,25, 20 );
  Mask_Edit3->setFont( font );
  Mask_Edit3->setMaxLength(3);

  Mask_Edit4 = new QLineEdit(IP_poolBox);
  Mask_Edit4->setGeometry((widthSize+98), 45,25, 20 );
  Mask_Edit4->setFont( font );
  Mask_Edit4->setMaxLength(3);
  
  Routers_Edit = new QLineEdit(IP_poolBox);
  Routers_Edit->setGeometry((domainSize+20), 70,((widthSize+buttonSize+150)-(domainSize+40)), 20);
  Routers_Edit->setFont( font );

  DomainName_Edit = new QLineEdit(IP_poolBox);
  DomainName_Edit->setGeometry((domainSize+20), 95,((widthSize+buttonSize+150)-(domainSize+40)), 20 );
  DomainName_Edit->setFont( font );

  NameServers_Edit = new QLineEdit(IP_poolBox);
  NameServers_Edit->setGeometry((domainSize+20), 120,((widthSize+buttonSize+150)-(domainSize+40)), 20 );
  NameServers_Edit->setFont( font );

  NetbiosNameServers_Edit = new QLineEdit(IP_poolBox);
  NetbiosNameServers_Edit->setGeometry((domainSize+20), 145,((widthSize+buttonSize+150)-(domainSize+40)), 20 );
  NetbiosNameServers_Edit->setFont( font );

  Ex_Start_IP_Edit1 = new QLineEdit(IP_poolBox);
  Ex_Start_IP_Edit1->setGeometry((widthSize+20), 190,25, 20 );
  Ex_Start_IP_Edit1->setFont( font );
  Ex_Start_IP_Edit1->setMaxLength(3);

  Ex_Start_IP_Edit2 = new QLineEdit(IP_poolBox);
  Ex_Start_IP_Edit2->setGeometry((widthSize+46), 190,25, 20 );
  Ex_Start_IP_Edit2->setFont( font );
  Ex_Start_IP_Edit2->setMaxLength(3);

  Ex_Start_IP_Edit3 = new QLineEdit(IP_poolBox);
  Ex_Start_IP_Edit3->setGeometry((widthSize+72), 190,25, 20 );
  Ex_Start_IP_Edit3->setFont( font );
  Ex_Start_IP_Edit3->setMaxLength(3);

  Ex_Start_IP_Edit4 = new QLineEdit(IP_poolBox);
  Ex_Start_IP_Edit4->setGeometry((widthSize+98), 190,25, 20 );
  Ex_Start_IP_Edit4->setFont( font );
  Ex_Start_IP_Edit4->setMaxLength(3);

  Ex_End_IP_Edit1 = new QLineEdit(IP_poolBox);
  Ex_End_IP_Edit1->setGeometry((widthSize+20), 210,25, 20 );
  Ex_End_IP_Edit1->setFont( font );
  Ex_End_IP_Edit1->setMaxLength(3);

  Ex_End_IP_Edit2 = new QLineEdit(IP_poolBox);
  Ex_End_IP_Edit2->setGeometry((widthSize+46), 210,25, 20 );
  Ex_End_IP_Edit2->setFont( font );
  Ex_End_IP_Edit2->setMaxLength(3);

  Ex_End_IP_Edit3 = new QLineEdit(IP_poolBox);
  Ex_End_IP_Edit3->setGeometry((widthSize+72), 210,25, 20 );
  Ex_End_IP_Edit3->setFont( font );
  Ex_End_IP_Edit3->setMaxLength(3);

  Ex_End_IP_Edit4 = new QLineEdit(IP_poolBox);
  Ex_End_IP_Edit4->setGeometry((widthSize+98), 210,25, 20 );
  Ex_End_IP_Edit4->setFont( font );
  Ex_End_IP_Edit4->setMaxLength(3);
  
  connect( Subnet_Edit1, SIGNAL(textChanged(const char*)), SLOT(Subnet_change1(const char*)));
  connect( Subnet_Edit2, SIGNAL(textChanged(const char*)), SLOT(Subnet_change2(const char*)));
  connect( Subnet_Edit3, SIGNAL(textChanged(const char*)), SLOT(Subnet_change3(const char*)));
  connect( Subnet_Edit4, SIGNAL(textChanged(const char*)), SLOT(Subnet_change4(const char*)));
  connect( Ex_Start_IP_Edit1, SIGNAL(textChanged(const char*)), SLOT(Ex_Start_IP_change1(const char*)));
  connect( Ex_Start_IP_Edit2, SIGNAL(textChanged(const char*)), SLOT(Ex_Start_IP_change2(const char*)));
  connect( Ex_Start_IP_Edit3, SIGNAL(textChanged(const char*)), SLOT(Ex_Start_IP_change3(const char*)));
  connect( Ex_Start_IP_Edit4, SIGNAL(textChanged(const char*)), SLOT(Ex_Start_IP_change4(const char*)));
  connect( Ex_End_IP_Edit1, SIGNAL(textChanged(const char*)), SLOT(Ex_End_IP_change1(const char*)));
  connect( Ex_End_IP_Edit2, SIGNAL(textChanged(const char*)), SLOT(Ex_End_IP_change2(const char*)));
  connect( Ex_End_IP_Edit3, SIGNAL(textChanged(const char*)), SLOT(Ex_End_IP_change3(const char*)));
  connect( Ex_End_IP_Edit4, SIGNAL(textChanged(const char*)), SLOT(Ex_End_IP_change4(const char*)));



  AddButton->setGeometry((widthSize+140),175,buttonSize,AddButton->sizeHint().height());
  RemoveButton->setGeometry((widthSize+140),205,buttonSize,RemoveButton->sizeHint().height());

  connect( AddButton, SIGNAL(clicked()), SLOT(Add_Click()) );
  connect( RemoveButton, SIGNAL(clicked()), SLOT(Remove_Click()) );

  exclude_Label = new QLabel(i18n("Included Addresses:"), IP_poolBox);
  exclude_Label->setGeometry((widthSize+buttonSize+150),20, exclude_Label->sizeHint().width(), exclude_Label->sizeHint().height());

  excludeBox = new QListBox(IP_poolBox);
  excludeBox->setGeometry((widthSize+buttonSize+150),40,(550-(widthSize+buttonSize+160)),170);

  Default_Radio = new QRadioButton(i18n("Default"), LeasesBox);
  Unlimited_Radio = new QRadioButton(i18n("Unlimited"), LeasesBox);
  Limited_Radio = new QRadioButton(i18n("Limited To:"), LeasesBox);

  bg = new QButtonGroup();
  bg->insert(Unlimited_Radio);
  bg->insert(Limited_Radio);
  bg->insert(Default_Radio);
  
  Default_Radio->setGeometry( 10, 20,  Default_Radio->sizeHint().width(), Default_Radio->sizeHint().height());
  Unlimited_Radio->setGeometry( 10, 40,  Unlimited_Radio->sizeHint().width(), Unlimited_Radio->sizeHint().height());
  Limited_Radio->setGeometry( 10, 60, Limited_Radio->sizeHint().width(), Limited_Radio->sizeHint().height());

  radioSize = Unlimited_Radio->sizeHint().width();
  if(radioSize < Limited_Radio->sizeHint().width())
    radioSize = Limited_Radio->sizeHint().width();

  daySpinBox = new KNumericSpinBox(LeasesBox);
  daySpinBox->setRange(0,365);
  hourSpinBox = new KNumericSpinBox(LeasesBox);
  hourSpinBox->setRange(0,24);
  minSpinBox = new KNumericSpinBox(LeasesBox);
  minSpinBox->setRange(0,60);
 
  dayLabel = new QLabel(i18n("Day(s)"), LeasesBox);
  hourLabel = new QLabel(i18n("Hour(s)"), LeasesBox);
  minLabel = new QLabel(i18n("Minutes"), LeasesBox);

  dayLabel->setFixedSize(dayLabel->sizeHint());
  hourLabel->setFixedSize(hourLabel->sizeHint());
  minLabel->setFixedSize(minLabel->sizeHint());

  dayLabel->setGeometry((radioSize+70), 60, dayLabel->sizeHint().width(), dayLabel->sizeHint().height());
  hourLabel->setGeometry((radioSize+130+dayLabel->sizeHint().width()), 60, hourLabel->sizeHint().width(), hourLabel->sizeHint().height());
  minLabel->setGeometry((radioSize+190+dayLabel->sizeHint().width()+hourLabel->sizeHint().width()), 60, minLabel->sizeHint().width(), minLabel->sizeHint().height());

  daySpinBox->setGeometry((radioSize+20), 60, 40, daySpinBox->sizeHint().height());
  hourSpinBox->setGeometry((radioSize+80+dayLabel->sizeHint().width()), 60, 40, hourSpinBox->sizeHint().height());
  minSpinBox->setGeometry((radioSize+140+dayLabel->sizeHint().width()+hourLabel->sizeHint().width()), 60, 40, minSpinBox->sizeHint().height());

  // Max Lease Duration

  Default_Radio2 = new QRadioButton(i18n("Default"), MaxLeasesBox);
  Unlimited_Radio2 = new QRadioButton(i18n("Unlimited"), MaxLeasesBox);
  Limited_Radio2 = new QRadioButton(i18n("Limited To:"), MaxLeasesBox);

  bg2 = new QButtonGroup();
  bg2->insert(Unlimited_Radio2);
  bg2->insert(Limited_Radio2);
  bg2->insert(Default_Radio2);
  
  Default_Radio2->setGeometry( 10, 20,  Default_Radio2->sizeHint().width(), Default_Radio2->sizeHint().height());
  Unlimited_Radio2->setGeometry( 10, 40,  Unlimited_Radio2->sizeHint().width(), Unlimited_Radio2->sizeHint().height());
  Limited_Radio2->setGeometry( 10, 60, Limited_Radio2->sizeHint().width(), Limited_Radio2->sizeHint().height());

  radioSize = Unlimited_Radio2->sizeHint().width();
  if(radioSize < Limited_Radio2->sizeHint().width())
    radioSize = Limited_Radio2->sizeHint().width();

  daySpinBox2 = new KNumericSpinBox(MaxLeasesBox);
  daySpinBox2->setRange(0,365);
  hourSpinBox2 = new KNumericSpinBox(MaxLeasesBox);
  hourSpinBox2->setRange(0,24);
  minSpinBox2 = new KNumericSpinBox(MaxLeasesBox);
  minSpinBox2->setRange(0,60);
 
  dayLabel2 = new QLabel(i18n("Day(s)"), MaxLeasesBox);
  hourLabel2 = new QLabel(i18n("Hour(s)"), MaxLeasesBox);
  minLabel2 = new QLabel(i18n("Minutes"), MaxLeasesBox);

  dayLabel2->setFixedSize(dayLabel2->sizeHint());
  hourLabel2->setFixedSize(hourLabel2->sizeHint());
  minLabel2->setFixedSize(minLabel2->sizeHint());

  dayLabel2->setGeometry((radioSize+70), 60, dayLabel2->sizeHint().width(), dayLabel2->sizeHint().height());
  hourLabel2->setGeometry((radioSize+130+dayLabel2->sizeHint().width()), 60, hourLabel2->sizeHint().width(), hourLabel2->sizeHint().height());
  minLabel2->setGeometry((radioSize+190+dayLabel2->sizeHint().width()+hourLabel2->sizeHint().width()), 60, minLabel2->sizeHint().width(), minLabel2->sizeHint().height());

  daySpinBox2->setGeometry((radioSize+20), 60, 40, daySpinBox2->sizeHint().height());
  hourSpinBox2->setGeometry((radioSize+80+dayLabel2->sizeHint().width()), 60, 40, hourSpinBox2->sizeHint().height());
  minSpinBox2->setGeometry((radioSize+140+dayLabel2->sizeHint().width()+hourLabel2->sizeHint().width()), 60, 40, minSpinBox2->sizeHint().height());

  sac = sa;
  
  setFixedSize(50,50);
  init();
  topLayout->activate();
}


scopeDialog::~scopeDialog()
{
}

void scopeDialog::init()
{
  caption.append(i18n("Scope Properties - "));
  setCaption((const char*)caption);

  Subnet_Edit1->setFocus();
  Default_Radio->setChecked(true);
  daySpinBox->setValue(0);
  hourSpinBox->setValue(0);
  minSpinBox->setValue(0);
  Default_Radio2->setChecked(true);
  daySpinBox2->setValue(0);
  hourSpinBox2->setValue(0);
  minSpinBox2->setValue(0);
  DomainName_Edit->setText(sac->domainName);
  NameServers_Edit->setText(sac->nameServers);
  NetbiosNameServers_Edit->setText(sac->netbiosNameServers);
  Subnet_Edit1->setText(getIP(0,(const char*)sac->subnet));
  Subnet_Edit2->setText(getIP(1,(const char*)sac->subnet));
  Subnet_Edit3->setText(getIP(2,(const char*)sac->subnet));
  Subnet_Edit4->setText(getIP(3,(const char*)sac->subnet));
  Mask_Edit1->setText(getIP(0,(const char*)sac->subnetMask));
  Mask_Edit2->setText(getIP(1,(const char*)sac->subnetMask));
  Mask_Edit3->setText(getIP(2,(const char*)sac->subnetMask));
  Mask_Edit4->setText(getIP(3,(const char*)sac->subnetMask));  
  Routers_Edit->setText(sac->routers);

  if(sac->leaseDurations == 0)
    Unlimited_Radio->setChecked(true);
  else if(sac->leaseDurations > 0)
    {
      tmpint = sac->leaseDurations;
      while(tmpint-(24*3600) >= 0)
	{
	  daySpinBox->setValue((daySpinBox->getValue()+1));
	  tmpint-=(24*3600);
	}
      while((tmpint-3600) >= 0)
	{
	  hourSpinBox->setValue((hourSpinBox->getValue()+1));
	  tmpint-=3600;
	}
      while((tmpint-60) >= 0)
	{
	  minSpinBox->setValue((minSpinBox->getValue()+1));
	  tmpint-=60;
	}
      Limited_Radio->setChecked(true);
    }
  else
    Default_Radio->setChecked(true);

  // Max lease duration

   if(sac->maxLeaseDurations == 0)
    Unlimited_Radio2->setChecked(true);
  else if(sac->maxLeaseDurations > 0)
    {
      tmpint = sac->maxLeaseDurations;
      while(tmpint-(24*3600) >= 0)
	{
	  daySpinBox2->setValue((daySpinBox2->getValue()+1));
	  tmpint-=(24*3600);
	}
      while((tmpint-3600) >= 0)
	{
	  hourSpinBox2->setValue((hourSpinBox2->getValue()+1));
	  tmpint-=3600;
	}
      while((tmpint-60) >= 0)
	{
	  minSpinBox2->setValue((minSpinBox2->getValue()+1));
	  tmpint-=60;
	}
      Limited_Radio2->setChecked(true);
    }
  else
    Default_Radio2->setChecked(true);


  QString tmp;
  for (tmp=sac->include->first();tmp!=0;tmp=sac->include->next()) {
    excludeBox->insertItem((const char*)tmp);
  }
  caption.remove(0,caption.length());
  caption = i18n("Scope Properties - ") + sac->subnet;
  setCaption((const char*)caption);

  update();
}

void scopeDialog::Help_Click()
{
}

void scopeDialog::OK_Click()
{
  sac->domainName = DomainName_Edit->text();
  sac->nameServers = NameServers_Edit->text();
  sac->netbiosNameServers = NetbiosNameServers_Edit->text();
  sac->subnet = putIP(Subnet_Edit1->text(), Subnet_Edit2->text(), Subnet_Edit3->text(), Subnet_Edit4->text());
  sac->subnetMask = putIP(Mask_Edit1->text(), Mask_Edit2->text(), Mask_Edit3->text(), Mask_Edit4->text());
  sac->routers = Routers_Edit->text();
  if(Limited_Radio->isChecked())
    sac->leaseDurations = daySpinBox->getValue()*24*3600+hourSpinBox->getValue()*3600+minSpinBox->getValue()*60;
  else if(Unlimited_Radio->isChecked())
    sac->leaseDurations = 0;
  else
    sac->leaseDurations = -1;
  if(Limited_Radio2->isChecked())
    sac->maxLeaseDurations = daySpinBox2->getValue()*24*3600+hourSpinBox2->getValue()*3600+minSpinBox2->getValue()*60;
  else if(Unlimited_Radio2->isChecked())
    sac->maxLeaseDurations = 0;
  else
    sac->maxLeaseDurations = -1;

  close();
}

void scopeDialog::Cancel_Click()
{
  close();
}

void scopeDialog::Advanced_Click()
{
  advancedDialog *s = new advancedDialog(sac,this, "s");
  s->show();
}

void scopeDialog::Add_Click()
{
  QString str,str1;
  str.append(Ex_Start_IP_Edit1->text());
  str = str.stripWhiteSpace();
  str.append(".");
  str.append(Ex_Start_IP_Edit2->text()); 
  str = str.stripWhiteSpace();
  str.append(".");
  str.append(Ex_Start_IP_Edit3->text());
  str = str.stripWhiteSpace();
  str.append(".");
  str.append(Ex_Start_IP_Edit4->text());
  str = str.stripWhiteSpace();
  str1.append(Ex_End_IP_Edit1->text());
  str1 = str1.stripWhiteSpace();
  str1.append(".");
  str1.append(Ex_End_IP_Edit2->text()); 
  str1 = str1.stripWhiteSpace();
  str1.append(".");
  str1.append(Ex_End_IP_Edit3->text());
  str1 = str1.stripWhiteSpace();
  str1.append(".");
  str1.append(Ex_End_IP_Edit4->text());
  str1 = str1.stripWhiteSpace();
  str = str+"-"+str1;
  excludeBox->insertItem((const char*)str);
  sac->include->append((const char*)str);
}

void scopeDialog::Remove_Click()
{
  if(excludeBox->currentItem() != -1)
    {
      sac->include->remove(excludeBox->currentItem());
      excludeBox->removeItem(excludeBox->currentItem());
    }
}


void scopeDialog::Subnet_change1(const char * name)
{
  if (strlen(name) == 3) Subnet_Edit2->setFocus();
}
 
void scopeDialog::Subnet_change2(const char * name)
{
  if (strlen(name) == 3) Subnet_Edit3->setFocus();
  else if (strlen(name) == 0) Subnet_Edit1->setFocus();
}

void scopeDialog::Subnet_change3(const char * name)
{
  if (strlen(name) == 3) Subnet_Edit4->setFocus();
  else if (strlen(name) == 0) Subnet_Edit2->setFocus();
}

void scopeDialog::Subnet_change4(const char * name)
{
  if (strlen(name) == 0)  Subnet_Edit3->setFocus();
  else if (strlen(name) == 3) 
    {
      QString str, str1;
      caption.remove(0,caption.length());
      str.append(Subnet_Edit1->text());
      str = str.stripWhiteSpace();
      str.append(".");
      str.append(Subnet_Edit2->text()); 
      str = str.stripWhiteSpace();
      str.append(".");
      str.append(Subnet_Edit3->text());
      str = str.stripWhiteSpace();
      str.append(".");
      str.append(Subnet_Edit4->text());
      str = str.stripWhiteSpace();
      caption = i18n("Scope Properties - ") + str;
      setCaption((const char*)caption);
      Mask_Edit1->setText("255");
      Mask_Edit2->setText("255");
      Mask_Edit3->setText("255");
      Mask_Edit4->setText("0");
      str1.append(Subnet_Edit3->text());
      str1 = str1.stripWhiteSpace();
      if(str1.toInt() == 0)
	{
	  Mask_Edit2->setText("255");
	  Mask_Edit3->setText("0");
	}
      str1.append(Subnet_Edit2->text());
      str1 = str1.stripWhiteSpace();
      if(str1.toInt() == 0)
	{
	  Mask_Edit2->setText("0");
	  Mask_Edit3->setText("0");
	}
      str = Subnet_Edit1->text();
      str = str.stripWhiteSpace();
      str.append(".");
      str.append(Subnet_Edit2->text());
      str = str.stripWhiteSpace();
      str.append(".");
      str.append(Subnet_Edit3->text());
      str = str.stripWhiteSpace();
      str.append(".1");
      Routers_Edit->setText((const char*)str);

      update();
      DomainName_Edit->setFocus();
    }

}


void scopeDialog::Ex_Start_IP_change1(const char * name)
{
  if (strlen(name) == 3) Ex_Start_IP_Edit2->setFocus();
}
 
void scopeDialog::Ex_Start_IP_change2(const char * name)
{
  if (strlen(name) == 3) Ex_Start_IP_Edit3->setFocus();
  else if (strlen(name) == 0) Ex_Start_IP_Edit1->setFocus();
}

void scopeDialog::Ex_Start_IP_change3(const char * name)
{
  if (strlen(name) == 3) Ex_Start_IP_Edit4->setFocus();
  else if (strlen(name) == 0) Ex_Start_IP_Edit2->setFocus();
}

void scopeDialog::Ex_Start_IP_change4(const char * name)
{
  if (strlen(name) == 3) 
    {
      if(strcmp(Ex_End_IP_Edit1->text(), ""))
	Ex_End_IP_Edit4->setFocus();
      else
	Ex_End_IP_Edit1->setFocus();
    }
  else if (strlen(name) == 0) Ex_Start_IP_Edit3->setFocus();
}

void scopeDialog::Ex_End_IP_change1(const char * name)
{
  if (strlen(name) == 3) Ex_End_IP_Edit2->setFocus();
}
 
void scopeDialog::Ex_End_IP_change2(const char * name)
{
  if (strlen(name) == 3) Ex_End_IP_Edit3->setFocus();
  else if (strlen(name) == 0) Ex_End_IP_Edit1->setFocus();
}

void scopeDialog::Ex_End_IP_change3(const char * name)
{
  if (strlen(name) == 3) Ex_End_IP_Edit4->setFocus();
  else if (strlen(name) == 0) Ex_End_IP_Edit2->setFocus();
}

void scopeDialog::Ex_End_IP_change4(const char * name)
{
  if (strlen(name) == 3) AddButton->setFocus();
  else if (strlen(name) == 0) Ex_End_IP_Edit3->setFocus();
}

void scopeDialog::update()
{
  Ex_Start_IP_Edit1->setText(Subnet_Edit1->text());
  Ex_Start_IP_Edit2->setText(Subnet_Edit2->text());
  Ex_Start_IP_Edit3->setText(Subnet_Edit3->text());
  Ex_End_IP_Edit1->setText(Subnet_Edit1->text());
  Ex_End_IP_Edit2->setText(Subnet_Edit2->text());
  Ex_End_IP_Edit3->setText(Subnet_Edit3->text());

  Subnet_Edit1->setCursorPosition(0);
  Subnet_Edit2->setCursorPosition(0);
  Subnet_Edit3->setCursorPosition(0);
  Subnet_Edit4->setCursorPosition(0);
  Mask_Edit1->setCursorPosition(0);
  Mask_Edit2->setCursorPosition(0);
  Mask_Edit3->setCursorPosition(0);
  Ex_Start_IP_Edit1->setCursorPosition(0);
  Ex_Start_IP_Edit2->setCursorPosition(0);
  Ex_Start_IP_Edit3->setCursorPosition(0);
  Ex_End_IP_Edit1->setCursorPosition(0);
  Ex_End_IP_Edit2->setCursorPosition(0);
  Ex_End_IP_Edit3->setCursorPosition(0);
}

QString scopeDialog::getIP(int a,const char *text)
{
  QString tmp, tmp1;
  tmp.append(text);
  tmp1 = tmp.left(tmp.find("."));
  if(a == 0)
    return(tmp1);
  tmp = tmp.remove(0,tmp.find(".")+1);

  tmp1 = tmp.left(tmp.find("."));
  if(a == 1)
    return(tmp1);
  tmp = tmp.remove(0,tmp.find(".")+1);

  tmp1 = tmp.left(tmp.find("."));
  if(a == 2)
    return(tmp1);
  tmp = tmp.remove(0,tmp.find(".")+1);

  tmp1 = tmp.left(tmp.find("."));
  if(a == 3)
    return(tmp1);
  return(0);
}

QString scopeDialog::putIP(QString a, QString b, QString c, QString d)
{
  QString tmp;
  tmp.append(a);
  tmp = tmp.stripWhiteSpace();
  tmp.append(".");
  tmp.append(b); 
  tmp = tmp.stripWhiteSpace();
  tmp.append(".");
  tmp.append(c);
  tmp = tmp.stripWhiteSpace();
  tmp.append(".");
  tmp.append(d);
  tmp = tmp.stripWhiteSpace();
  return(tmp);
}
