#include <iostream.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include "ClientSocket.h"
#include "ClientSocket.moc"

ClientSocket::ClientSocket() : Socket()
{
}

ClientSocket::ClientSocket(int Sd) : Socket()
{
  sd = Sd;
  struct  sockaddr_in sockAddrIn;
  int size=sizeof(sockAddrIn);
  getsockname(sd, (struct sockaddr*)&sockAddrIn, &size);
  localPort = ntohs(sockAddrIn.sin_port);
  localInAddr.forHost(sockAddrIn.sin_addr.s_addr);
  getpeername(sd, (struct sockaddr*)&sockAddrIn, &size);
  peerPort = ntohs(sockAddrIn.sin_port);
  inAddr.forHost(sockAddrIn.sin_addr.s_addr);
}

ClientSocket::ClientSocket(const char* host, int port) : Socket()
{
  peerPort = port;
  if (!inAddr.forHost(host))
     return;
}


ClientSocket::~ClientSocket()
{
  Close();
}

int ClientSocket::Open(const char* host, int port)
{
  peerPort = port;
  if (!host)
     return 0;
  if (!inAddr.forHost(host))
     return 0;
  return Open();
}

int ClientSocket::Open()
{
#ifdef EDEBUG
  cout << "ClientSocket::Open()"<<endl;
#endif
   struct  sockaddr_in sockAddrIn;

   if (peerPort < 0){
      return -1;
   }
   if (!inAddr.getHostAddress()){
      return -1;
   }

   bzero((char *) &sockAddrIn, sizeof(sockAddrIn));
   sockAddrIn.sin_port   =  htons(peerPort);
   sockAddrIn.sin_family =  inAddr.getFamily();
   sockAddrIn.sin_addr.s_addr = inAddr.getAddress();
   if ((sd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
      return -1;
   if (sd==0)
      sd = ::dup(sd);
   setsockopt(sd, SOL_SOCKET, SO_LINGER,    0, 0);
   setsockopt(sd, SOL_SOCKET, SO_REUSEADDR, 0, 0);
   setsockopt(sd, SOL_SOCKET, SO_KEEPALIVE, 0, 0);

   if (::connect(sd, (struct sockaddr*) &sockAddrIn, sizeof(sockAddrIn)) < 0){
      close(sd);
      sd = -1;
      return -1;
   }
   int size=sizeof(sockAddrIn);
   getsockname(sd, (struct sockaddr*)&sockAddrIn, &size);
   localPort = ntohs(sockAddrIn.sin_port);
   localInAddr.forHost(sockAddrIn.sin_addr.s_addr);

#ifdef EDEBUG
  cout << "ClientSocket::Open()....Ok"<<endl;
#endif

   return sd;     
}

void ClientSocket::Close()
{
  if (sd!=-1){
     ::close(sd);
     sd=-1;
  }
}




