#include <qdir.h>
#include "lineDialog.h"
#include "StringToken.h"
#include "channelPage.h"
#include "ircClient.h"
#include "ircDefine.h"
#include <qregexp.h>
#include <qdatetm.h> 
#include "kiconloader.h"
#include <iostream.h>
#include <qlayout.h>
#include "ircApp.h"

CtrButton::CtrButton(ChannelPage* c, QWidget* p, const char* name) :
  QWidget(p, name)
{
  mChannelPage = c;
  mChannel     = mChannelPage->getClient();
  mClient      = mChannel->client;

  QVBoxLayout* vLayout = new QVBoxLayout(this, 0);
  QPushButton* btn;
  btn=new QPushButton("Op/Deop",       this);
  vLayout->addWidget(btn);
  btn->setFixedHeight(20);
  connect(btn, SIGNAL(clicked()),
	  SLOT(opClicked()));

  btn=new QPushButton("Voice/Devoice", this);
  vLayout->addWidget(btn);
  btn->setFixedHeight(20);
  connect(btn, SIGNAL(clicked()),
	  SLOT(voiceClicked()));

  btn=new QPushButton("Kick",          this);
  vLayout->addWidget(btn);
  btn->setFixedHeight(20);
  connect(btn, SIGNAL(clicked()),
	  SLOT(kickClicked()));

  btn=new QPushButton("Ban",           this);
  vLayout->addWidget(btn);
  btn->setFixedHeight(20);
  connect(btn, SIGNAL(clicked()),
	  SLOT(banClicked()));

  btn=new QPushButton("Action Config", this);
  vLayout->addWidget(btn);
  btn->setFixedHeight(20);
  connect(btn, SIGNAL(clicked()),
	  SLOT(configClicked()));
  vLayout->activate();
}

void CtrButton::opClicked()
{
  QList<char>* list = mChannelPage->nickListBox->getSelected();
  if (list->count()>0){
     QString nick;
     for (nick=list->first();nick!=0L;nick=list->next()){
         ChannelUser* cu=mChannel->cuList->find(nick);
	 if (cu==0L)
	    continue;
	 QString txt="";
	 if (cu->haveOp()){
	    txt=ircapp->readEntry("ChannelDeopAction", "");
	    if (txt.isEmpty())
	       txt="/MODE "+QString(mChannel->name())+" -o "+nick;
	 }
	 else{
	    txt=ircapp->readEntry("ChannelOpAction", "");
	    if (txt.isEmpty())
	       txt="/MODE "+QString(mChannel->name())+" +o "+nick;
	 }
	 mClient->slotInputParse(txt);
     }
  }
}

void CtrButton::voiceClicked()
{
  QList<char>* list = mChannelPage->nickListBox->getSelected();
  if (list->count()>0){
     QString nick;
     for (nick=list->first();nick!=0L;nick=list->next()){
         ChannelUser* cu=mChannel->cuList->find(nick);
	 if (cu==0L)
	    continue;
	 QString txt="";
	 if (cu->haveVoice()){
	    txt=ircapp->readEntry("ChannelDevoiceAction", "");
	    if (txt.isEmpty())
	       txt="/MODE "+QString(mChannel->name())+" -v "+nick;
	 }
	 else{
	    txt=ircapp->readEntry("ChannelVoiceAction", "");
	    if (txt.isEmpty())
	       txt="/MODE "+QString(mChannel->name())+" +v "+nick;
	 }
	 mClient->slotInputParse(txt);
     }
  }
}

void CtrButton::kickClicked()
{
  QList<char>* list = mChannelPage->nickListBox->getSelected();
  if (list->count()>0){
     QString nick;
     for (nick=list->first();nick!=0L;nick=list->next()){
	 QString msg=ircapp->readEntry("KickMessage","");
	 QString txt=ircapp->readEntry("ChannelKickAction", "");
	 if (txt.isEmpty())
	    txt="/KICK "+QString(mChannel->name())+" "+nick+" "+msg;
	 mClient->slotInputParse(txt);
     }
  }
}

void CtrButton::banClicked()
{
  QList<char>* list = mChannelPage->nickListBox->getSelected();
  if (list->count()>0){
     QString nick;
     for (nick=list->first();nick!=0L;nick=list->next()){
	 QString txt=ircapp->readEntry("ChannelBanAction", "");
	 if (txt.isEmpty()){
	    QString ban=mClient->makeBan(nick);
	    txt="/MODE "+QString(mChannel->name())+" +b "+ban;
	 }
	 mClient->slotInputParse(txt);
     }
  }
}

void CtrButton::configClicked()
{
  mClient->slotInputParse(QString("/SHOW OpActionDialog"));
}

ChannelPage::ChannelPage(IrcClient* Client, QWidget* parent, const char* Name) :
             OutputPage(Client, parent, Name)
{
#ifdef EDEBUG
  cout << "ChannelPage Konstruktor:"<<Name<<endl;
#endif

  idTbMode  = idTbCounter++;
  idTbBan   = idTbCounter++;
  idTbTopic = idTbCounter++;
  idTbSelection = idTbCounter++;
  chanClient     = client->channel->find(Name);
  if (!chanClient){
     cout << "Channel Object: " << Name <<" cannot be found" << endl;
     return;
  }

  panWidget->installEventFilter(this);

  QVBoxLayout* listLayout  = new QVBoxLayout(panWidget,0);

  nickListBox = new IrcListBox(panWidget);
  listLayout->addWidget(nickListBox);
  panner->setSeparatorPos(80);

  ctrButton = new CtrButton(this, panWidget);
  listLayout->addWidget(ctrButton);
  listLayout->activate();

  connect(inpCmd, 
	  SIGNAL(signReturn(const char*)), 
	  chanClient, 
	  SLOT  (slotInputParse(const char*)));
  connect(chanClient, 
	  SIGNAL(signWriteMsg(int, const char*, bool)), 
	  SLOT(slotWriteMsg  (int, const char*, bool)));
  connect(chanClient, 
	  SIGNAL(signAddUser(const char*)), 
	  this, 
	  SLOT  (slotAddUser(const char*)));
  connect(chanClient, 
	  SIGNAL(signDelUser(const char*)), 
	  this, 
	  SLOT  (slotDelUser(const char*)));
  connect(chanClient, 
	  SIGNAL(signChangeUserMode(const char*, const char*)), 
	  this, 
	  SLOT  (slotChangeUserMode(const char*, const char*)));
  connect(chanClient, 
	  SIGNAL(signChangeNick(const char*, const char*)), 
	  this, 
	  SLOT  (slotChangeNick(const char*, const char*)));

  connect(&chanClient->getMode(),
	   SIGNAL(signAddMode(char, const char*)),
	   this,
	   SLOT  (slotAddMode(char, const char*)));
  connect(&chanClient->getMode(),
	  SIGNAL(signDelMode(char, const char*)),
	  this,
	  SLOT  (slotDelMode(char, const char*)));
  connect(chanClient,
	  SIGNAL(signTopic(const char*, const char*)),
	  this,
	  SLOT  (slotTopic(const char*, const char*)));

  createMenu();
  createToolbar();
  createPopup();
  QString value=ircapp->readEntry("ChannelMultiSelection", "No");
  if (value=="Yes"){
     nickListBox->setMultiSelection(true);
     toolbar->toggleButton(idTbSelection);
  }
  else{
     nickListBox->setMultiSelection(false);
  }

  nickListBox->setDragSelect(FALSE);
  nickListBox->setSmoothScrolling(FALSE);
  nickListBox->show();

}

ChannelPage::~ChannelPage()
{
#ifdef EDEBUG
  cout << "Destruktor ChannelPage" << endl;
#endif;
}

void ChannelPage::createPopup()
{
  IrcPopup* popup;
  if (!(popup = client->popup.find("Channel")))
     popup = client->popup.find("Default");

  if (popup){
     connect(ircHtml()->htmlWidget(),
	     SIGNAL(popupMenu (const char*, const QPoint&)),
	     this,
	     SLOT  (slotChannelPopup (const char*, const QPoint&))); 

     connect(popup,
	     SIGNAL(signPopup(const char*)),
	     this,
	     SLOT  (slotChannelPopupAction(const char*)));
  }

  if (!(popup = client->popup.find("UserList")))
     popup = client->popup.find("Default");

  if (popup){
     connect(nickListBox,
	     SIGNAL(signMouseRightPress(const QPoint&)),
	     this,
	     SLOT  (slotUserListPopup  (const QPoint&))); 

     connect(popup,
	     SIGNAL(signPopup(const char*)),
	     this,
	     SLOT  (slotUserListPopupAction(const char*)));
  }
}

void ChannelPage::slotAddUser(const char* Nick)
{
#ifdef EDEBUG
  cout << "ChannelPage::slotAddUser:"<<Nick<<endl;
#endif
  //static int start=0;
  nickListBox->inSort(Nick);
  //nickListBox->repaint();
  //if (start==0){
  resizeEvent(0L);
     // start=1;
     //}
}

void ChannelPage::slotDelUser(const char* Nick)
{
#ifdef EDEBUG
  cout << "ChannelPage::slotDelUser:"<<Nick<<endl;
#endif
  QString n;
  for (uint i=0;i<nickListBox->count();i++){
    StringToken token(nickListBox->text(i));
    n = token.nextToken(" +@");
    if (n==Nick){
       nickListBox->removeItem(i);
       return;
    }
  }
}

void ChannelPage::slotChangeUserMode(const char* Nick, const char* Mode)
{
  QString n;
  QString mode=Mode;
  for (uint i=0;i<nickListBox->count();i++){
    StringToken token(nickListBox->text(i));
    n = token.nextToken(" +@");
    if (n==Nick){
       mode += n;
       nickListBox->removeItem(i);
       nickListBox->inSort(mode);
       if (!stricmp(Nick, client->currentNick()))
	  resizeEvent(0L);
       return;
    }
  }
}

void ChannelPage::slotChangeNick(const char* Nick, const char* NewNick)
{
  QString nick = Nick;
  QString nnick= NewNick;
  QString mode="";

  for (uint i=0;i<nickListBox->count();i++){
    QString mnick=nickListBox->text(i);
    StringToken token(nickListBox->text(i));
    QString lnick = token.nextToken(" +@");
    if (lnick==nick){
        int id=mnick.find('+', 0, FALSE);
	if (id>=0&&id<=1)
	   mode += '+';
	id=mnick.find('@', 0, FALSE);
	if (id>=0&&id<=1)
	   mode += '@';
	mode += nnick;
	nickListBox->removeItem(i);
	nickListBox->inSort(mode);
	return;
    }
  }
}

void ChannelPage::slotChannelPopup(const char*, const QPoint& pos)
{
#ifdef EDEBUG
  cout <<"ChannelPage::slotChannelPopup:"+QString(chanClient->name())<<endl;
#endif
  IrcPopup* popup = client->popup.find("Channel");
  if (!popup)
     return;
  QPopupMenu* pu=popup->find("Main");
  if (pu){
    pu->popup(pos);
  }
}

void ChannelPage::slotChannelPopupAction(const char* Action)
{  
  if ( IsSelected()==true && isActiveWindow()==true)
     chanClient->slotInputParse(Action);

  return;
}

void ChannelPage::slotUserListPopup(const QPoint& pos)
{
#ifdef EDEBUG
  cout <<"ChannelPage::slotUserListPopup:"+QString(chanClient->name())<<endl;
#endif
  IrcPopup* popup = client->popup.find("UserList");
  if (!popup)
     return;
  QPopupMenu* pu=popup->find("Main");
  if (pu){
    pu->popup(pos);
  }
}

void ChannelPage::slotUserListPopupAction(const char* Action)
{  
  if (IsSelected()==false)
     return;

  StringToken t(Action);
  QString o   = Action;

  int idx;
  
  QList<char>* list = nickListBox->getSelected();
  if (list->count()>0){
     QString nick;
     for (nick=list->first();nick;nick=list->next()){
         idx=0;
	 QString c = (const char*)o;
	 idx = -1;
	 while((idx=c.find('$', idx+1, FALSE))>=0){
	   if (idx!=0 && c[idx-1]=='\\')
	      continue;
	   if (c[idx+1]=='u')
	      c.replace(idx, 2, nick);
	 }
	 chanClient->slotInputParse(c);
     }
  }
  else
     chanClient->slotInputParse(o);
}

void ChannelPage::Init()
{

}

void ChannelPage::createMenu()
{
  menu.setAutoDelete (false);

  QPopupMenu*  pm;
  menu.insert("mode", pm=new QPopupMenu);
  pm->setCheckable(TRUE);

  connect (pm, 
	   SIGNAL(activated(int)), 
	   this, 
	   SLOT  (slotModeMenu(int)));
	   
  idModeP = pm->insertItem("Private    ");
  idModeS = pm->insertItem("Secret     ");
  idModeM = pm->insertItem("Moderated  ");
  idModeT = pm->insertItem("Topic Limit");
  idModeI = pm->insertItem("Invite only");
  idModeN = pm->insertItem("No PrivMsg ");
  idModeK = pm->insertItem("Key        ");
  idModeL = pm->insertItem("Limit      ");
  for (uint i=0;i<pm->count();i++){
      int id=pm->idAt(i);
      pm->setItemChecked(id, 0);
  }

  menu.insert("ban", pm=new QPopupMenu);
  pm->setCheckable(TRUE);
  connect (pm, 
	   SIGNAL(activated(int)), 
	   this, 
	   SLOT  (slotBanMenu(int)));

  menu.insert("topic", pm=new QPopupMenu);
  pm->setCheckable(TRUE);
  idTopicSet = pm->insertItem("Set");
  idTopicRequest = pm->insertItem("Request");
  idTopicIs  = pm->insertItem("Topic is:");
  idTopicBy  = pm->insertItem("Set by  :");
  connect (pm, 
	   SIGNAL(activated(int)), 
	   this, 
	   SLOT  (slotTopicMenu(int)));
}

void ChannelPage::createToolbar()
{
  QPixmap      pix;
  KIconLoader* loader = ircapp->getIconLoader();

  pix = loader->loadIcon("keirc-channel-mode-toolbar.xpm");
  toolbar->insertButton(pix, idTbMode, SIGNAL(pressed()), 
			this, SLOT(slotModePopup()), TRUE, "Channel Mode");

  pix = loader->loadIcon("keirc-channel-ban-toolbar.xpm");
  toolbar->insertButton(pix, idTbBan, SIGNAL(pressed()), 
			this, SLOT(slotBanPopup()), TRUE, "Channel Ban");

  pix = loader->loadIcon("keirc-channel-topic-toolbar.xpm");
  toolbar->insertButton(pix, idTbTopic, SIGNAL(pressed()), 
			this, SLOT(slotTopicPopup()), TRUE, "Channel Topic");

  toolbar->insertSeparator();
  pix = loader->loadIcon("keirc-channel-multiselection-toolbar.xpm");
  toolbar->insertButton(pix, idTbSelection, TRUE, "Multi selection");
  toolbar->setToggle(idTbSelection);
  toolbar->addConnection (idTbSelection, SIGNAL(toggled(bool)), this, SLOT(slotToggleSelection(bool)));
}

void ChannelPage::slotModePopup()
{
  toolbar->setButton(idTbMode, false);
  QRect  r = toolbar->getButton(idTbMode)->geometry();
  QPoint p = r.bottomLeft(); 
  menu["mode"]->popup(mapToGlobal(p));
}

void ChannelPage::slotBanPopup()
{
  toolbar->setButton(idTbBan, false);
  QRect  r = toolbar->getButton(idTbBan)->geometry();
  QPoint p = r.bottomLeft(); 
  menu["ban"]->popup(mapToGlobal(p));
}

void ChannelPage::slotTopicPopup()
{
  toolbar->setButton(idTbTopic, false);
  QRect  r = toolbar->getButton(idTbTopic)->geometry();
  QPoint p = r.bottomLeft(); 
  menu["topic"]->popup(mapToGlobal(p));
}

void ChannelPage::slotModeMenu(int id)
{
#ifdef EDEBUG
  cout << "ChannelPage::slotModeMenu:"<<id<<endl;
#endif
  QString s = menu["mode"]->text(id);
  QString st;
  if (menu["mode"]->isItemChecked(id))
     st="-";
  else
     st="+";
  st.insert(1, s[0]);
  st = st.lower();
  if (st[0]=='-' && st[1]=='k'){
     QString k=chanClient->getMode().key();
     st += " "+k;
  }
  else if (st[0]=='+' && st[1]=='k'){
    SingleDialog dk("Key : ", "", "Key Dialog");
    if (dk.exec() ) {
       QString e = dk.getText(TRUE);
       if (e.isNull() || e.isEmpty())
	  return;
       StringToken t(e);
       QString k=t.nextToken();
       st += " "+k;
    }
    else
       return;
  }
  else if (st[0]=='+' && st[1]=='l'){
    SingleDialog d("Limit : ","","Limit Dialog");
    if (d.exec() ) {
       QString e = d.getText(TRUE);
       if (e.isNull() || e.isEmpty())
	  return;
       StringToken t(e);
       QString k=t.nextToken();
       bool status=1;
       if (k.toInt(&status)<1 || status==0)
	  return;
       st += " "+k;
    }
    else
       return;
  }
  client->getSocket().sendMode(QString(chanClient->name())+" "+st);

}

void ChannelPage::slotBanMenu(int id)
{
  QString s = menu["ban"]->text(id);
  QString st="-b";
  st = st +" "+s;
  client->getSocket().sendMode(QString(chanClient->name())+" "+st);
}

void ChannelPage::slotTopicMenu(int id)
{
  if (id==idTopicSet){
    SingleDialog dlg("Topic :","", "Type new topic");
    if (dlg.exec()){
       QString t=dlg.getText();
       if (!t.isEmpty())
	  client->getSocket().sendTopic(QString(chanClient->name())+" "+t);
    }
  }
  else if(id==idTopicRequest){
    client->getSocket().sendTopic(QString(chanClient->name()));
  }
}


void ChannelPage::slotTopic(const char* txt, const char* by)
{
  QString topic=txt;
  QString t;
  t = "Topic is: "+topic;
  menu["topic"]->changeItem(t, idTopicIs);
  StringToken tt(by);
  QString setby=tt.nextToken();
  QString ds   =tt.nextToken();
  if (!ds.isEmpty()){
     QDateTime dt;
     dt.setTime_t(ds.toUInt());
     setby += " "+dt.toString();
  }
  t = "Set by: "+setby;
  menu["topic"]->changeItem(t, idTopicBy);
}

void ChannelPage::slotModeLimit()
{
}

void ChannelPage::slotExit(MDIWindow*)
{
  if (client->state)
     chanClient->slotInputParse("/PART "+QString(chanClient->name()));
  client->delChannel(chanClient->name(), false);
}

void ChannelPage::slotAddMode(char c, const char* txt)
{
#ifdef EDEBUG
  cout << "slotAddMode " << c << ":" << txt << endl;
#endif

  QPopupMenu* pm=menu["mode"];
  if (c=='p')
     pm->setItemChecked(idModeP, 1);
  else if (c=='s')
     pm->setItemChecked(idModeS, 1);
  else if (c=='m')
     pm->setItemChecked(idModeM, 1);
  else if (c=='t')
     pm->setItemChecked(idModeT, 1);
  else if (c=='i')
     pm->setItemChecked(idModeI, 1);
  else if (c=='n')
     pm->setItemChecked(idModeN, 1);
  else if (c=='k'){
     QString s = "Key        ";
     s += " "+QString(txt);
     pm->changeItem(s, idModeK);
     pm->setItemChecked(idModeK, 1);
  }
  else if (c=='l'){
     QString s = "Limit      ";
     s += " "+QString(txt);
     pm->changeItem(s, idModeL);
     pm->setItemChecked(idModeL, 1);
  }
  else if (c=='b' && txt){
     QString s=txt;
     s=s.stripWhiteSpace();
     if (s.isNull())
        return;
     int id=menu["ban"]->insertItem(s);
     menu["ban"]->setItemChecked(id, 1);
  }
}

void ChannelPage::slotDelMode(char c, const char* txt)
{
#ifdef EDEBUG
  cout << "slotDelMode " << c << ":" << txt << endl;
#endif
  QPopupMenu* pm;
  pm = menu["mode"];
  if (c=='p')
     pm->setItemChecked(idModeP, 0);
  else if (c=='s')
     pm->setItemChecked(idModeS, 0);
  else if (c=='m')
     pm->setItemChecked(idModeM, 0);
  else if (c=='t')
     pm->setItemChecked(idModeT, 0);
  else if (c=='i')
     pm->setItemChecked(idModeI, 0);
  else if (c=='n')
     pm->setItemChecked(idModeN, 0);
  else if (c=='k'){
     QString key = "Key        ";
     pm->changeItem(key, idModeK);
     pm->setItemChecked(idModeK, 0);
  }
  else if (c=='l'){
     QString lim = "Limit      ";
     pm->changeItem(lim, idModeL);
     pm->setItemChecked(idModeL, 0);
  }
  else if (c=='b' && txt){
     QString s=txt;
     s=s.stripWhiteSpace();
     for (uint i=0;i<menu["ban"]->count();i++){
       int id=menu["ban"]->idAt(i);
       if (id < 0)
	  continue;
       if (!menu["ban"]->text(id))
	  continue;
       if (!stricmp(s, menu["ban"]->text(id))){
	 menu["ban"]->removeItem(id);
	 return;
       }
     }
  }
}

void ChannelPage::slotToggleSelection(bool state)
{
  ircapp->writeEntry( "ChannelMultiSelection",   state ? "Yes" : "No" );
  nickListBox->setMultiSelection(state);
}

IrcChannel* ChannelPage::getClient()
{
  return chanClient;
}


void ChannelPage::slotWriteMsg(int type, const char* txt, bool parse)
{
  htmlMsg->slotWrite(type, txt, parse);
  if (!IsSelected())
    emit signNewMsg();
}

bool ChannelPage::eventFilter ( QObject *, QEvent *e )
{
  if (e->type() == Event_Resize){
     resizeEvent( (QResizeEvent *)e );
  }

  return false;
}

void ChannelPage::resizeEvent(QResizeEvent* e)
{
  OutputPage::resizeEvent(e);

  ChannelUser* cu=chanClient->cuList->find(client->currentNick());
  int h = panWidget->height();
  int w = panWidget->width();
  bool flag=false;

  if (cu!=0L){
    if (cu->haveOp()){
       flag = true;
       h    = h-100;
    }
  }
  
  nickListBox->setGeometry(0, 0,
			   w, h);

  if (flag){
    ctrButton->setGeometry(0, h,
			    w, 100);
     ctrButton->show();
  }
  else
     ctrButton->hide();
}

#include "channelPage.moc"
