#include <iostream.h>
#include "ircDefine.h"
#include "fontOpt.h"
#include "fontOpt.moc"

#include <klocale.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qapp.h>
#include <X11/Xlib.h>
#include <kapp.h>

FontOpt::FontOpt( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  QHBoxLayout* horLayout  = new QHBoxLayout(this, 10);
  QVBoxLayout* lVerLayout = new QVBoxLayout(0);
  horLayout->addLayout(lVerLayout, 10);

  QGroupBox* gb = new QGroupBox("Font Options", this);
  lVerLayout->addWidget(gb, 1);

  readOptions();

  QLabel*    label;
  QComboBox* cb; 
  QBoxLayout* vlayout;
  QBoxLayout* hlayout;
  vlayout = new QVBoxLayout(gb, 15);
  vlayout->addSpacing(gb->fontMetrics().height());

  hlayout = new QHBoxLayout(5);
  vlayout->addLayout(hlayout);
  label = new QLabel( klocale->translate("Text Font:"), gb);
  hlayout->addWidget(label, 2);
  cb = new QComboBox( false, gb);
  hlayout->addWidget(cb, 4);
  getFontList(textFonts, "-*-*-*-*-*-*-*-*-*-*-p-*-*-*" );
  cb->insertStrList   (&textFonts );
  QStrListIterator sit(textFonts );
  int i;
  for (i = 0; sit.current(); ++sit, i++ ){
    if ( !stricmp( textFName, sit.current() ) ){
        cb->setCurrentItem( i );
	break;
    }
  }
  connect (cb,   SIGNAL(activated    (const char * )),
	   this, SLOT  (slotTextFName(const char * )) );
  cb = new QComboBox( false, gb);
  hlayout->addWidget(cb, 1);
  QString s;
  int minSize=3;
  int maxSize=8;
  for (i=minSize;i<=maxSize;i++){
     s.sprintf("%d", i);
     cb->insertItem(s);
  }
  for (i = 0; (i+minSize)<=maxSize; i++ ){
    if ( textFSize==i+minSize){
        cb->setCurrentItem( i );
	break;
    }
  }
  connect (cb,   SIGNAL(activated    (const char * )),
	   this, SLOT  (slotTextFSize(const char * )) );



  hlayout = new QHBoxLayout(5);
  vlayout->addLayout(hlayout);
  label = new QLabel( klocale->translate("Info Font:"), gb);
  hlayout->addWidget(label, 2);
  cb = new QComboBox( false, gb);
  hlayout->addWidget(cb, 4);
  getFontList(infoFonts, "-*-*-*-*-*-*-*-*-*-*-p-*-*-*" );
  cb->insertStrList   (&infoFonts );
  sit=QStrListIterator(infoFonts);
  for (i = 0; sit.current(); ++sit, i++ ){
    if ( !stricmp( infoFName, sit.current() ) ){
        cb->setCurrentItem( i );
	break;
    }
  }
  connect (cb,   SIGNAL(activated    (const char * )),
	   this, SLOT  (slotInfoFName(const char * )) );
  cb = new QComboBox( false, gb);
  hlayout->addWidget(cb, 1);
  for (i=minSize;i<=maxSize;i++){
     s.sprintf("%d", i);
     cb->insertItem(s);
  }
  for (i = 0; (i+minSize)<=maxSize; i++ ){
    if ( textFSize==i+minSize){
        cb->setCurrentItem( i );
	break;
    }
  }
  connect (cb,   SIGNAL(activated    (const char * )),
	   this, SLOT  (slotInfoFSize(const char * )) );

  hlayout = new QHBoxLayout(5);
  vlayout->addLayout(hlayout);
  label = new QLabel( klocale->translate("Message Font:"), gb);
  hlayout->addWidget(label, 2);
  cb = new QComboBox( false, gb);
  hlayout->addWidget(cb, 4);
  getFontList(msgFonts, "-*-*-*-*-*-*-*-*-*-*-p-*-*-*" );
  cb->insertStrList   (&msgFonts );
  sit=QStrListIterator(msgFonts );
  for (i = 0; sit.current(); ++sit, i++ ){
    if ( !stricmp( msgFName, sit.current() ) ){
        cb->setCurrentItem( i );
	break;
    }
  }
  connect (cb,   SIGNAL(activated    (const char * )),
	   this, SLOT  (slotMsgFName(const char * )) );
  cb = new QComboBox( false, gb);
  hlayout->addWidget(cb, 1);
  for (i=minSize;i<=maxSize;i++){
     s.sprintf("%d", i);
     cb->insertItem(s);
  }
  for (i = 0; (i+minSize)<=maxSize; i++ ){
    if ( textFSize==i+minSize){
        cb->setCurrentItem( i );
	break;
    }
  }
  connect (cb,   SIGNAL(activated    (const char * )),
	   this, SLOT  (slotMsgFSize(const char * )) );

  hlayout = new QHBoxLayout(5);
  vlayout->addLayout(hlayout);
  label = new QLabel( klocale->translate("Error Font:"), gb);
  hlayout->addWidget(label, 2);
  cb = new QComboBox( false, gb);
  hlayout->addWidget(cb, 4);
  getFontList(errorFonts, "-*-*-*-*-*-*-*-*-*-*-p-*-*-*" );
  cb->insertStrList   (&errorFonts );
  sit=QStrListIterator(errorFonts );
  for (i = 0; sit.current(); ++sit, i++ ){
    if ( !stricmp( errorFName, sit.current() ) ){
        cb->setCurrentItem( i );
	break;
    }
  }
  connect (cb,   SIGNAL(activated    (const char * )),
	   this, SLOT  (slotErrorFName(const char * )) );
  cb = new QComboBox( false, gb);
  hlayout->addWidget(cb, 1);
  for (i=minSize;i<=maxSize;i++){
     s.sprintf("%d", i);
     cb->insertItem(s);
  }
  for (i = 0; (i+minSize)<=maxSize; i++ ){
    if ( textFSize==i+minSize){
        cb->setCurrentItem( i );
	break;
    }
  }
  connect (cb,   SIGNAL(activated    (const char * )),
	   this, SLOT  (slotErrorFSize(const char * )) );

  hlayout = new QHBoxLayout(5);
  vlayout->addLayout(hlayout);
  label = new QLabel( klocale->translate("Action Font:"), gb);
  hlayout->addWidget(label, 2);
  cb = new QComboBox( false, gb);
  hlayout->addWidget(cb, 4);
  getFontList(actionFonts, "-*-*-*-*-*-*-*-*-*-*-p-*-*-*" );
  cb->insertStrList   (&actionFonts );
  sit=QStrListIterator(actionFonts );
  for (i = 0; sit.current(); ++sit, i++ ){
    if ( !stricmp( actionFName, sit.current() ) ){
        cb->setCurrentItem( i );
	break;
    }
  }
  connect (cb,   SIGNAL(activated    (const char * )),
	   this, SLOT  (slotActionFName(const char * )) );
  cb = new QComboBox( false, gb);
  hlayout->addWidget(cb, 1);
  for (i=minSize;i<=maxSize;i++){
     s.sprintf("%d", i);
     cb->insertItem(s);
  }
  for (i = 0; (i+minSize)<=maxSize; i++ ){
    if ( textFSize==i+minSize){
        cb->setCurrentItem( i );
	break;
    }
  }
  connect (cb,   SIGNAL(activated    (const char * )),
	   this, SLOT  (slotActionFSize(const char * )) );
  
  vlayout->activate();
  lVerLayout->addStretch(1);
  horLayout->addStretch(5);
  horLayout->activate();
  show();
}

FontOpt::~FontOpt()
{
#ifdef EDEBUG
  cout << "Destruktor FontOpt" << endl;
#endif
}                                

void FontOpt::readOptions()
{
  KConfig *config = kapp->getConfig();
  config->setGroup( "kEirc Option" );

  QString fs;
  fs = config->readEntry("TextFontSize");
  if ( !fs.isEmpty() ){
     textFSize = fs.toInt();
  }
  else
     textFSize = 4;
  fs = config->readEntry("MsgFontSize");
  if ( !fs.isEmpty() ){
     msgFSize = fs.toInt();
  }
  else
     msgFSize = 4;
  fs = config->readEntry("InfoFontSize");
  if ( !fs.isEmpty() ){
     infoFSize = fs.toInt();
  }
  else
     infoFSize = 4;
  fs = config->readEntry("ActionFontSize");
  if ( !fs.isEmpty() ){
     actionFSize = fs.toInt();
  }
  else
     actionFSize = 4;
  fs = config->readEntry("ErrorFontSize");
  if ( !fs.isEmpty() ){
     errorFSize = fs.toInt();
  }
  else
     errorFSize = 4;

  textFName = config->readEntry( "TextFont" );
  if ( textFName.isEmpty() )
     textFName = "times";
  
  msgFName = config->readEntry( "MsgFont" );
  if ( msgFName.isEmpty() )        
     msgFName = "times";

  infoFName = config->readEntry( "InfoFont" );
  if ( infoFName.isEmpty() )        
     infoFName = "times";

  actionFName = config->readEntry( "ActionFont" );
  if ( actionFName.isEmpty() )        
     actionFName = "times";

  errorFName = config->readEntry( "ErrorFont" );
  if ( errorFName.isEmpty() )        
     errorFName = "times";
}
     

void FontOpt::getFontList( QStrList &list, const char *pattern )
{
        int num;

        char **xFonts = XListFonts( qt_xdisplay(), pattern, 200, &num );

        for ( int i = 0; i < num; i++ ){
	    addFont( list, xFonts[i] );
        }

        XFreeFontNames( xFonts );
}


void FontOpt::addFont( QStrList &list, const char *xfont )
{
  const char *ptr = strchr( xfont, '-' );
  if ( !ptr )
     return;

  ptr = strchr( ptr + 1, '-' );
  if ( !ptr )
     return;

  QString font = ptr + 1;

  int pos;
  if ( ( pos = font.find( '-' ) ) > 0 ){
     font.truncate( pos );
     
     if ( font.find( "open look", 0, false ) >= 0 )
        return;

     QStrListIterator it( list );
         
     for ( ; it.current(); ++it )
        if ( it.current() == font )
	   return;
     
     list.append( font );
  }
}         


void FontOpt::slotTextFSize(const char* s)
{
  QString size=s;
  if (textFName!=size.toInt()){
      KConfig *config = kapp->getConfig();
      config->setGroup( "kEirc Option" );
      textFSize = size.toInt();
      QString fs;
      fs.setNum( textFSize );
      config->writeEntry( "TextFontSize", fs );
      emit signFontSize(textFSize, TYPE_TEXT);
      config->sync();
  }
}

void FontOpt::slotMsgFSize (const char* s)
{
  QString size=s;
  if (msgFName!=size.toInt()){
      KConfig *config = kapp->getConfig();
      config->setGroup( "kEirc Option" );
      msgFSize = size.toInt();
      QString fs;
      fs.setNum( msgFSize );
      config->writeEntry( "MsgFontSize", fs );
      emit signFontSize(msgFSize, TYPE_MSG);
      config->sync();
  }
}

void FontOpt::slotInfoFSize (const char* s)
{
  QString size=s;
  if (infoFName!=size.toInt()){
      KConfig *config = kapp->getConfig();
      config->setGroup( "kEirc Option" );
      infoFSize = size.toInt();
      QString fs;
      fs.setNum( infoFSize );
      config->writeEntry( "InfoFontSize", fs );
      emit signFontSize(infoFSize, TYPE_INFO);
      config->sync();
  }
}

void FontOpt::slotActionFSize (const char* s)
{
  QString size=s;
  if (actionFName!=size.toInt()){
      KConfig *config = kapp->getConfig();
      config->setGroup( "kEirc Option" );
      actionFSize = size.toInt();
      QString fs;
      fs.setNum( actionFSize );
      config->writeEntry( "ActionFontSize", fs );
      emit signFontSize(actionFSize, TYPE_ACTION);
      config->sync();
  }
}

void FontOpt::slotErrorFSize(const char* s)
{
  QString size=s;
  if (errorFName!=size.toInt()){
      KConfig *config = kapp->getConfig();
      config->setGroup( "kEirc Option" );
      errorFSize = size.toInt();
      QString fs;
      fs.setNum( errorFSize );
      config->writeEntry( "ErrorFontSize", fs );
      emit signFontSize(errorFSize, TYPE_ERROR);
      config->sync();
  }
}


void FontOpt::slotTextFName( const char *n )
{
  if (textFName!=n){
      KConfig *config = kapp->getConfig();
      config->setGroup( "kEirc Option" );
      textFName = n;
      config->writeEntry( "TextFont", textFName );
      emit signFontName(textFName, TYPE_TEXT);
      config->sync();
  }
}

void FontOpt::slotMsgFName ( const char *n )
{
  if (msgFName!=n){
      KConfig *config = kapp->getConfig();
      config->setGroup( "kEirc Option" );
      msgFName = n;
      config->writeEntry( "MsgFont", msgFName );
      emit signFontName(msgFName, TYPE_MSG);
      config->sync();
  }
}


void FontOpt::slotInfoFName ( const char *n )
{
  if (infoFName!=n){
      KConfig *config = kapp->getConfig();
      config->setGroup( "kEirc Option" );
      infoFName = n;
      config->writeEntry( "InfoFont", infoFName );
      emit signFontName(infoFName, TYPE_INFO);
      config->sync();
  }
}

void FontOpt::slotActionFName ( const char *n )
{
  if (actionFName!=n){
      KConfig *config = kapp->getConfig();
      config->setGroup( "kEirc Option" );
      actionFName = n;
      config->writeEntry( "ActionFont", actionFName );
      emit signFontName(actionFName, TYPE_ACTION);
      config->sync();
  }
}

void FontOpt::slotErrorFName ( const char *n )
{
  if (errorFName!=n){
      KConfig *config = kapp->getConfig();
      config->setGroup( "kEirc Option" );
      errorFName = n;
      config->writeEntry( "ErrorFont", errorFName );
      emit signFontName(errorFName, TYPE_ERROR);
      config->sync();
  }
}


