#ifndef __IRCMSGPAGE_H__
#define __IRCMSGPAGE_H__

#include "ircClient.h"
#include <qevent.h>
#include <qframe.h>
#include <qlistbox.h>
#include <kpanner.h>
#include "ircHtml.h"
#include "ircLine.h"
#include "ircClient.h"
#include "ircPopup.h"
#include "ircListBox.h"
#include "outputPage.h"

class IrcMsgPage : public OutputPage
{
  Q_OBJECT
protected:
  IrcListBox* listBox;
protected:
  void resizeEvent (QResizeEvent*);
  void createPopup ();
  void createToolbar();
public slots:
  void slotPopup(const char*, const QPoint&);
  void slotPopupAction(const char*);
  void slotConnect    (IrcServer*);
  void slotDisconnect (IrcServer*);
  void slotUpdateListBox(const char*, int flag);
  virtual void slotWriteOnActive(int type, const char* txt, bool Filter);
  void slotWriteMsg(int type, const char* txt, bool parse=true);
public:
  IrcMsgPage(IrcClient* Client, QWidget* parent, const char* Name=NULL);
  ~IrcMsgPage();
};

#endif 
