#ifndef __IRCPOPUP_H__
#define __IRCPOPUP_H__

#include <qobject.h>
#include <qstrlist.h>
#include <qlist.h>
#include <qstring.h>
#include <qdict.h>
#include <qpopmenu.h>

class PopupClue : public QObject
{
  Q_OBJECT
protected:
  QPopupMenu*  pu;
  QDict<char>* action;
signals:
  void signAction(const char*);
public slots:
  void slotAction(int);
public:
  PopupClue(const char* Name);
  ~PopupClue();
  QPopupMenu* popup();
  int add(const char* Name, const char* Value, int Id);
  int add(const char* Name, QPopupMenu* pu, int Id);
};

class IrcPopup : public QObject
{
  Q_OBJECT
protected:
  QString path;
  QString entry;
  QDict<PopupClue>* popup;
  QStrIList         list;
signals:
  void signPopup(const char* Action);
  void signUpdateData();
protected:
  void init();
public slots:
  void slotPopup(const char* Action);
  void slotUpdateData();
public:
  IrcPopup();
  IrcPopup(const char* ENtry, const char* File);
  ~IrcPopup();
  int     load (const char* File=0);
  int     save (const char* File=0);
  QPopupMenu* find(const char* Name);
  QString    getPath();
  QStrIList* getList();
  void clear();
};

#endif







