#include <stdlib.h>
#include <iostream.h>
#include <qlined.h>
#include <qfiledlg.h> 
#include <qfileinf.h> 
#include <qtooltip.h> 
#include "fileReader.h"
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include "ircDefine.h"
#include "listPage.h"
#include "listPage.moc"
#include "ircApp.h"

ListPage::ListPage(QStrList* list, const char* Title, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  this->list = list;
  QHBoxLayout* horLayout = new QHBoxLayout(this, 10);
  QGroupBox* gb = new QGroupBox(Title, this);
  horLayout->addWidget(gb);
  QVBoxLayout* vbox=new QVBoxLayout(gb, 10);
  QHBoxLayout* hbox=new QHBoxLayout(5);
  vbox->addSpacing(gb->fontMetrics().height());
  vbox->addLayout(hbox);

  lePath = new QLineEdit(gb);
  hbox->addWidget(lePath, 10);
  lePath->setFixedHeight(25);
  lePath->setText("");
  QPushButton* btn = new QPushButton(" File ", gb);
  hbox->addWidget(btn);
  btn->setFixedSize(100, 25);

  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotOpenFileDialog()));

  mLineEdit = new QMultiLineEdit(gb);
  vbox->addWidget(mLineEdit, 10);
  mLineEdit->setMinimumWidth(250);
  vbox->activate();

  vbox = new QVBoxLayout(0);
  horLayout->addLayout(vbox);

  vbox->addSpacing(gb->fontMetrics().height());

  btn = new QPushButton(" Apply ", this);
  vbox->addWidget(btn, 0, AlignLeft);
  btn->setFixedSize(100, 25);
  QToolTip::add(btn, "Apply and Save");

  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));

  btn = new QPushButton(" Save as", this);
  vbox->addWidget(btn, 0, AlignLeft);
  btn->setFixedSize(100, 25);
  QToolTip::add(btn, "Apply and Save As");
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotSaveAs()));
  vbox->addStretch(10);

  horLayout->activate();
  show();
}

ListPage::~ListPage()
{
#ifdef EDEBUG
  cout << "Destruktor ListPage" << endl;
#endif
}

void ListPage::load()
{
  QString item;
  mLineEdit->setAutoUpdate(FALSE);
  mLineEdit->clear();
  for (item=list->first();item;item=list->next()){
     mLineEdit->append(item);
  }
  mLineEdit->setAutoUpdate(TRUE);
  mLineEdit->repaint(FALSE);
}

void ListPage::slotOpenFileDialog()
{
  QString p=lePath->text();
  if (p.isEmpty())
     p=path;
  QFileInfo fi(p);
  QString dir = fi.dirPath(TRUE);
  QString fileName = QFileDialog::getOpenFileName(dir, filter);
  if (!fileName.isEmpty()){
     FileReader fr(list, entry, fileName);
     if (!fr.load(fileName))
        return;
     lePath->setText(fileName);
     load();
  }
}

void ListPage::slotApply()
{
  QString p=lePath->text();
  if (p.isEmpty()){
     p=path;
     lePath->setText(path);
  }

  if (!p)
     return;
  QFile f(p);
  if (!f.open(IO_WriteOnly))
     return;
  path = p;
  QTextStream ts(&f);
  for (int i=0;i<mLineEdit->numLines();i++){
      QString s=mLineEdit->textLine(i);
      s=s.stripWhiteSpace();
      ts << s << endl;
  }
  f.close();
  FileReader fr(list, entry, path);
  fr.load();
}

void ListPage::slotSaveAs()
{
  QString p=lePath->text();
  if (p.isEmpty())
     p=path;
  QFileInfo fi(p);
  QString dir = fi.dirPath(TRUE);
  QString fileName = QFileDialog::getSaveFileName(dir, filter);
  if (!fileName.isEmpty()){
     lePath->setText(fileName);
     slotApply();
  }
}



