#include <stdlib.h>
#include <iostream.h>
#include <qlined.h>
#include <qfiledlg.h> 
#include <qfileinf.h> 
#include <qtooltip.h> 
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include "lineDialog.h"
#include "kmsgbox.h"
#include "fileReader.h"
#include "ircDefine.h"
#include "ircUser.h"
#include "onUserListPage.h"
#include "onUserListPage.moc"
#include "ircApp.h"

void OnUserPage::Init()
{
  checkBox.setAutoDelete(false);
  checkText.setAutoDelete(true);
  lineEdit.setAutoDelete(true);
}

OnUserPage::OnUserPage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  Init();
  this->client=client;
  
  horLayout = new QHBoxLayout(this, 10);
  createBox();
  createPushButton();
  horLayout->activate();
  readConfig();
  show();
}

OnUserPage::~OnUserPage()
{
#ifdef EDEBUG
  cout << "Destruktor OnUserPage" << endl;
#endif
}


void OnUserPage::createBox()
{
  QString entry;
  QVBoxLayout*  verLayout = new QVBoxLayout(10);
  horLayout->addLayout(verLayout);
  QButtonGroup* bg = new QButtonGroup("Flood Protection", this);

  verLayout->addWidget(bg);

  QVBoxLayout* vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());
  QHBoxLayout* hbox = new QHBoxLayout(10);
  vbox->addLayout(hbox);

  QCheckBox* cb;
  checkText.append(entry=qstrdup("FloodProtectionActivate"));
  checkBox.insert(entry, cb = new QCheckBox("Flood Protection activate", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  hbox->addWidget(cb);

  QLabel*    label;
  QLineEdit* edit;

  hbox = new QHBoxLayout(10);
  vbox->addLayout(hbox);
  label = new QLabel("Protection: max. Lines ", bg);
  hbox->addWidget(label, 10);
  label->setFixedHeight(25);
  lineEdit.insert("FLOOD_MAXLINE", edit=new QLineEdit(bg));
  hbox->addWidget(edit);
  edit->setFixedSize(30, 25);
  label = new QLabel(" for ", bg);
  hbox->addWidget(label);
  label->setFixedSize(40, 25);
  lineEdit.insert("FLOOD_SECOND", edit=new QLineEdit(bg));
  hbox->addWidget(edit);
  edit->setFixedSize(30, 25);
  label = new QLabel(" Seconds ", bg);
  hbox->addWidget(label, 4);
  label->setFixedHeight(25);

  vbox->addSpacing(10);
  vbox->activate();

  verLayout->addStretch(10);
}

void OnUserPage::createPushButton()
{
  horLayout->addSpacing(10);
  QPushButton* btn;
  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  horLayout->addWidget(btn, 0, AlignLeft|AlignTop);
  btn->setFixedSize(80, 30);
}

void OnUserPage::readConfig()
{
  QString check;
  QString entry;
  QString value;
  for (entry=checkText.first();entry;entry=checkText.next()){
      value = ircapp->readEntry(entry, "Yes");
      if (value=="Yes")
	 checkBox[entry]->setChecked(1);
      ircapp->writeEntry(entry, value);
  }
  entry = "FLOOD_SECOND"; value = ircapp->readEntry(entry, "1");
  lineEdit[entry]->setText(value);
  entry = "FLOOD_MAXLINE"; value = ircapp->readEntry(entry, "3");
  lineEdit[entry]->setText(value);
}

void OnUserPage::slotApply()
{
#ifdef EDEBUG
  cout << "OnUserPage::slotApply:"<<endl;
#endif
  QString entry;
  QString value;
  QCheckBox* cb;

  for (entry=checkText.first();entry;entry=checkText.next()){
      cb=checkBox[entry];
      if (!cb)
	 continue;
      if (cb->isChecked())
	 value="Yes";
      else
	 value="No";
      ircapp->writeEntry(entry, value);
  }
  entry = "FLOOD_SECOND";
  ircapp->writeEntry(entry, lineEdit[entry]->text());
  entry = "FLOOD_MAXLINE";
  ircapp->writeEntry(entry, lineEdit[entry]->text());
}


FriendListPage::FriendListPage(FriendList* list, QWidget *parent, const char *name ) : 
  QWidget(parent, name)
{
#ifdef EDEBUG
  cout << "FriendListPage Konstruktor"<<endl;
#endif
  fList = list;

  horLayout  = new QHBoxLayout(this, 0);
  horLayout->addSpacing(10);
  lVerLayout = new QVBoxLayout(5);
  horLayout->addLayout(lVerLayout,10);

  createListBox();
  lVerLayout->addSpacing(30);

  rVerLayout = new QVBoxLayout(0);
  horLayout->addLayout(rVerLayout,1);
  createButton();

  horLayout->activate();

  readConfig();
  show();
#ifdef EDEBUG
  cout << "FriendListPage Konstruktor ...Ok" << endl;
#endif
}

FriendListPage::~FriendListPage()
{
#ifdef EDEBUG
  cout << "Destruktor FriendListPage" << endl;
#endif
}


void FriendListPage::createListBox()
{
#ifdef EDEBUG
  cout << "FriendListPage::createListBox" << endl;
#endif

  QFrame* listFrame = new QFrame(this);
  listFrame->setLineWidth(2);
  listFrame->setFrameStyle(QFrame::Panel|QFrame::Sunken);

  lVerLayout->addWidget(listFrame, 10);

  QVBoxLayout* vbox = new QVBoxLayout(listFrame, 3);;

  listBox   = new KTabListBox(listFrame, "listBox", 3);
  vbox->addWidget(listBox);
  listBox->setColumn(0, "Username");
  listBox->setColumn(1, "Level");
  listBox->setColumn(2, "Channel");
  listBox->setColumnWidth(0, 150);
  listBox->setColumnWidth(1,  75);
  listBox->setColumnWidth(2, 100);
  listBox->setSeparator  (':');
  vbox->activate();

  lVerLayout->addSpacing(10);
  checkBox = new QCheckBox("Friend List Activate", this);
  lVerLayout->addWidget(checkBox, 1);
}

void FriendListPage::createButton()
{
#ifdef EDEBUG
  cout << "FriendListPage::createBotton" << endl;
#endif
  QPushButton* btn;

  btn = new QPushButton(" Add ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotAdd()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);
  btn = new QPushButton(" Edit ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotEdit()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  btn = new QPushButton(" Delete ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotDelete()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  rVerLayout->addSpacing(10);

  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);
  rVerLayout->addStretch(10);
}

void FriendListPage::readConfig()
{
#ifdef EDEBUG
  cout << "FriendListPage::readConfig" << endl;
#endif
  QString entry = "FriendListPath";
  QString path  = "FriendUser.list";
  QStrIList list;
  FileReader fr(&list, entry, path);
  if (!fr.load())
     return;

  QString s;
  int i=0;
  for (s=list.first();list.current()!=0L;list.next()){
      s=list.current();
      listBox->appendItem(s);
      QString u = listBox->text(i, 0);
      QString l = listBox->text(i, 1);
      QString c = listBox->text(i, 2);
      fList->addUser(u, l.toInt(), c);
      i++;
  }
  fList->setUpdate(false);

  entry = "FriendListActivate";
  QString value = ircapp->readEntry(entry, "No");
  if (value=="Yes")
     checkBox->setChecked(1);
  else
     checkBox->setChecked(0);
}

void FriendListPage::slotAdd()
{
  LineDialog ldlg(this, "", TRUE, "Add FriendUser");
  QStrList ll, le;
  ll.setAutoDelete(true);
  ll.append("Username :");
  ll.append("Level :");
  ll.append("Channel :");
  
  ldlg.setText(ll, le);
  if (ldlg.exec()){
     QString f = ldlg.getText(0);
     QString p = ldlg.getText(1);
     QString c = ldlg.getText(2);
     
     if (f.isEmpty() || p.isEmpty())
        return;
     FriendUser* fu=fList->addUser(f, p.toInt(), c);
     if (fu==0L)
        return;
     char s = listBox->separator();
     listBox->appendItem(fu->getIdent()+s+p+s+fu->getChannel());
     listBox->setCurrentItem(-1);
  } 
}

void FriendListPage::slotEdit()
{
  int idx = listBox->currentItem();
  if (idx<0)
     return;
  LineDialog ldlg(this, "", TRUE, "Edit FriendUser");
  QStrList ll, le;
  ll.setAutoDelete(true);
  le.setAutoDelete(true);
  ll.append("Username :");
  ll.append("Level :");
  ll.append("Channel :");
  le.append(listBox->text(idx, 0));
  le.append(listBox->text(idx, 1));
  le.append(listBox->text(idx, 2));
  ldlg.setText(ll, le);
  if (ldlg.exec()){
     QString f = ldlg.getText(0);
     QString p = ldlg.getText(1);
     QString c = ldlg.getText(2);
     if (f.isEmpty() || p.isEmpty())
        return;
     fList->delUser(listBox->text(idx, 0));
     FriendUser* fu=fList->addUser(f, p.toInt(), c);
     if (fu!=0L){
        char s = listBox->separator();
	listBox->changeItem(fu->getIdent()+s+p+s+fu->getChannel(), idx);
	listBox->setCurrentItem(idx);
     }
     else{
        listBox->removeItem(idx);
	listBox->setCurrentItem(-1);
     }
  } 
}

void FriendListPage::slotDelete()
{
  int idx = listBox->currentItem();
  if (idx>=0){
     fList->delUser(listBox->text(idx, 0));
     listBox->removeItem(idx);
     listBox->setCurrentItem(-1);
  }
  
}

void FriendListPage::slotApply()
{
  QString entry = "FriendListPath";
  QString path  = "FriendUser.list";
  QString value = ircapp->readPathEntry(entry, path);

  
  QFile f(value);
  if (!f.open(IO_WriteOnly))
     return;
  ircapp->writeEntry(entry, value);
  QTextStream ts(&f);
  ts.device()->at(0);
  for (uint i=0;i<listBox->count();i++){
     QString f = listBox->text(i, 0);
     QString p = listBox->text(i, 1);
     QString c = listBox->text(i, 2);
     QString s = f+listBox->separator()+p+listBox->separator()+c;
     ts << s << endl;
  }
  entry = "FriendListActivate";
  if (checkBox->isChecked())
     ircapp->writeEntry(entry, "Yes");
  else
     ircapp->writeEntry(entry, "No");
}

void FriendListPage::slotCurrentPage(const char* page)
{
  if (!stricmp(page, name())){
     if (!fList->getUpdate())
        return;
     listBox->clear();
     FriendUser* fu;
     QList<FriendUser> uList=fList->getUserList();
     for (fu=uList.first();fu!=0L;fu=uList.next()){
        QString u = fu->getIdent();
	QString l;
	l.setNum(fu->getLevel());
	QString s=u+listBox->separator()+l;
	listBox->appendItem(s);
     }
     fList->setUpdate(false);
  }
  QString entry = "FriendListActivate";
  QString value = ircapp->readEntry(entry, "No");
  if (value=="Yes")
    checkBox->setChecked(1);
  else
    checkBox->setChecked(0);
} 


// **************************************************************
// BanListPage
// **************************************************************
BanListPage::BanListPage(BanList* list, QWidget *parent, const char *name ) : 
  QWidget(parent, name)
{
#ifdef EDEBUG
  cout << "BanListPage Konstruktor"<<endl;
#endif
  bList = list;

  horLayout  = new QHBoxLayout(this, 0);
  horLayout->addSpacing(10);
  lVerLayout = new QVBoxLayout(5);
  horLayout->addLayout(lVerLayout, 10);

  createListBox();
  lVerLayout->addSpacing(30);

  rVerLayout = new QVBoxLayout(0);
  horLayout->addLayout(rVerLayout,1);
  createButton();

  horLayout->activate();

  readConfig();
  show();
#ifdef EDEBUG
  cout << "BanListPage Konstruktor ...Ok" << endl;
#endif
}

BanListPage::~BanListPage()
{
#ifdef EDEBUG
  cout << "Destruktor BanListPage" << endl;
#endif
}


void BanListPage::createListBox()
{
#ifdef EDEBUG
  cout << "BanListPage::createListBox" << endl;
#endif

  QFrame* listFrame = new QFrame(this);
  listFrame->setLineWidth(2);
  listFrame->setFrameStyle(QFrame::Panel|QFrame::Sunken);

  lVerLayout->addWidget(listFrame, 10);

  QVBoxLayout* vbox = new QVBoxLayout(listFrame, 3);;

  listBox   = new KTabListBox(listFrame, "listBox", 3);
  vbox->addWidget(listBox);
  listBox->setColumn(0, "Username");
  listBox->setColumn(1, "Level");
  listBox->setColumn(2, "Channel");
  listBox->setColumnWidth(0, 150);
  listBox->setColumnWidth(1,  75);
  listBox->setColumnWidth(2, 100);
  listBox->setSeparator  (':');
  vbox->activate();

  lVerLayout->addSpacing(10);
  checkBox = new QCheckBox("Ban List Activate", this);
  lVerLayout->addWidget(checkBox, 1);
}

void BanListPage::createButton()
{
#ifdef EDEBUG
  cout << "BanListPage::createBotton" << endl;
#endif
  QPushButton* btn;

  btn = new QPushButton(" Add ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotAdd()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);
  btn = new QPushButton(" Edit ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotEdit()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  btn = new QPushButton(" Delete ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotDelete()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  rVerLayout->addSpacing(10);

  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);
  rVerLayout->addStretch(10);
}

void BanListPage::readConfig()
{
#ifdef EDEBUG
  cout << "BanListPage::readConfig" << endl;
#endif
  QString entry = "BanListPath";
  QString path  = "BanUser.list";
  QStrIList list;
  FileReader fr(&list, entry, path);
  if (!fr.load())
     return;

  QString s;
  int i=0;
  for (s=list.first();list.current()!=0L;list.next()){
      s=list.current();
      listBox->appendItem(s);
      QString u = listBox->text(i, 0);
      QString l = listBox->text(i, 1);
      QString c = listBox->text(i, 2);
      bList->addUser(u, l.toInt(), c);
      i++;
  }
  bList->setUpdate(false);

  entry = "BanListActivate";
  QString value = ircapp->readEntry(entry, "No");
  if (value=="Yes")
     checkBox->setChecked(1);
  else
     checkBox->setChecked(0);
}

void BanListPage::slotAdd()
{
  LineDialog ldlg(this, "", TRUE, "Add BanUser");
  QStrList ll, le;
  ll.setAutoDelete(true);
  ll.append("Username :");
  ll.append("Level :");
  ll.append("Channel :");
  ldlg.setText(ll, le);
  if (ldlg.exec()){
     QString f = ldlg.getText(0);
     QString p = ldlg.getText(1);
     QString c = ldlg.getText(2);

     if (f.isEmpty() || p.isEmpty())
        return;
     BanUser* fu=bList->addUser(f, p.toInt(), c);
     if (fu==0L)
        return;
     char s = listBox->separator();
     listBox->appendItem(fu->getIdent()+s+p+s+fu->getChannel());
     listBox->setCurrentItem(-1);
  } 
}

void BanListPage::slotEdit()
{
  int idx = listBox->currentItem();
  if (idx<0)
     return;
  LineDialog ldlg(this, "", TRUE, "Edit BanUser");
  QStrList ll, le;
  ll.setAutoDelete(true);
  le.setAutoDelete(true);
  ll.append("Username :");
  ll.append("Level :");
  ll.append("Channel :");
  le.append(listBox->text(idx, 0));
  le.append(listBox->text(idx, 1));
  le.append(listBox->text(idx, 2));
  ldlg.setText(ll, le);
  if (ldlg.exec()){
     QString f = ldlg.getText(0);
     QString p = ldlg.getText(1);
     QString c = ldlg.getText(2);
     if (f.isEmpty() || p.isEmpty())
        return;
     bList->delUser(listBox->text(idx, 0));
     BanUser* fu=bList->addUser(f, p.toInt(), c);
     if (fu!=0L){
        char s = listBox->separator();
	listBox->changeItem(fu->getIdent()+s+p+s+fu->getChannel(), idx);
	listBox->setCurrentItem(idx);
     }
     else{
        listBox->removeItem(idx);
	listBox->setCurrentItem(-1);
     }
  } 
}

void BanListPage::slotDelete()
{
  int idx = listBox->currentItem();
  if (idx>=0){
     bList->delUser(listBox->text(idx, 0));
     listBox->removeItem(idx);
     listBox->setCurrentItem(-1);
  }
  
}

void BanListPage::slotApply()
{
  QString entry = "BanListPath";
  QString path  = "BanUser.list";
  QString value = ircapp->readPathEntry(entry, path);

  
  QFile f(value);
  if (!f.open(IO_WriteOnly))
     return;
  ircapp->writeEntry(entry, value);
  QTextStream ts(&f);
  ts.device()->at(0);
  for (uint i=0;i<listBox->count();i++){
     QString f = listBox->text(i, 0);
     QString p = listBox->text(i, 1);
     QString c = listBox->text(i, 2);
     char r = listBox->separator();
     QString s = f+r+p+r+c;
     ts << s << endl;
  }
  entry = "BanListActivate";
  if (checkBox->isChecked())
     ircapp->writeEntry(entry, "Yes");
  else
     ircapp->writeEntry(entry, "No");
}

void BanListPage::slotCurrentPage(const char* page)
{
#ifdef EDEBUG
  cout << "BanListPage::slotCurrentPage():"<<page<<":"<<name()<<endl;
#endif
  if (!stricmp(page, name())){
     if (!bList->getUpdate())
        return;
     listBox->clear();
     BanUser* bu;
     for (bu=bList->first();bu!=0L;bu=bList->next()){
        QString u = bu->getIdent();
	QString l;l.setNum(bu->getLevel());
	QString c = bu->getChannel();
	char r = listBox->separator();
	QString s=u+r+l+r+c;
	listBox->appendItem(s);
     }
     bList->setUpdate(false);
  }
  QString entry = "BanListActivate";
  if (checkBox->isChecked())
    ircapp->writeEntry(entry, "Yes");
  else
    ircapp->writeEntry(entry, "No");
} 


// **************************************************************
// IgnoreListPage
// **************************************************************
IgnListPage::IgnListPage(IgnoreList* list, QWidget *parent, const char *name ) : 
  QWidget(parent, name)
{
#ifdef EDEBUG
  cout << "IgnListPage Konstruktor"<<endl;
#endif
  iList = list;

  horLayout  = new QHBoxLayout(this, 0);
  horLayout->addSpacing(10);

  lVerLayout = new QVBoxLayout(5);
  horLayout->addLayout(lVerLayout,10);

  createListBox();
  lVerLayout->addSpacing(30);

  rVerLayout = new QVBoxLayout(0);
  horLayout->addLayout(rVerLayout,1);
  createButton();

  horLayout->activate();

  readConfig();
  show();
#ifdef EDEBUG
  cout << "IgnListPage Konstruktor ...Ok" << endl;
#endif
}

IgnListPage::~IgnListPage()
{
#ifdef EDEBUG
  cout << "Destruktor IgnListPage" << endl;
#endif
}


void IgnListPage::createListBox()
{
#ifdef EDEBUG
  cout << "IgnListPage::createListBox" << endl;
#endif

  QFrame* listFrame = new QFrame(this);
  listFrame->setLineWidth(2);
  listFrame->setFrameStyle(QFrame::Panel|QFrame::Sunken);

  lVerLayout->addWidget(listFrame, 10);

  QVBoxLayout* vbox = new QVBoxLayout(listFrame, 3);

  listBox   = new KTabListBox(listFrame, "listBox", 3);
  vbox->addWidget(listBox);
  listBox->setColumn(0, "Username");
  listBox->setColumn(1, "Flag");
  listBox->setColumn(2, "Seconds");
  listBox->setColumnWidth(0, 150);
  listBox->setColumnWidth(1,  75);
  listBox->setColumnWidth(2, 100);
  listBox->setSeparator  (':');
  vbox->activate();

  lVerLayout->addSpacing(10);
  checkBox = new QCheckBox("Ignore List Activate", this);
  lVerLayout->addWidget(checkBox, 1);
}

void IgnListPage::createButton()
{
#ifdef EDEBUG
  cout << "IgnListPage::createBotton" << endl;
#endif
  QPushButton* btn;

  btn = new QPushButton(" Add ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotAdd()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);
  btn = new QPushButton(" Edit ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotEdit()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  btn = new QPushButton(" Delete ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotDelete()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  rVerLayout->addSpacing(10);

  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);
  rVerLayout->addStretch(10);
}

void IgnListPage::readConfig()
{
#ifdef EDEBUG
  cout << "IgnListPage::readConfig" << endl;
#endif
  QString entry = "IgnListPath";
  QString path  = "IgnUser.list";
  QStrIList list;
  FileReader fr(&list, entry, path);
  if (!fr.load())
     return;

  QString s;
  int i=0;
  for (s=list.first();list.current()!=0L;list.next()){
      s=list.current();
      listBox->appendItem(s);
      QString u = listBox->text(i, 0);
      QString l = listBox->text(i, 1);
      QString c = listBox->text(i, 2);
      iList->addUser(u, l, c.toULong());
      i++;
  }
  iList->setUpdate(false);

  entry = "IgnListActivate";
  QString value = ircapp->readEntry(entry, "No");
  if (value=="Yes")
     checkBox->setChecked(1);
  else
     checkBox->setChecked(0);
}

void IgnListPage::slotAdd()
{
  LineDialog ldlg(this, "", TRUE, "Add Ignore User");
  QStrList ll, le;
  ll.setAutoDelete(true);
  ll.append("Username :");
  ll.append("Flag :");
  ll.append("Seconds :");
  ldlg.setText(ll, le);
  if (ldlg.exec()){
     QString f = ldlg.getText(0);
     QString p = ldlg.getText(1);
     QString c = ldlg.getText(2);
     if (f.isEmpty() || p.isEmpty())
        return;
     IgnoreUser* iu=iList->addUser(f, p, c.toULong());
     if (iu==0L)
        return;
     char s = listBox->separator();
     QString se; se.setNum(iu->getSecond());
     listBox->appendItem(iu->getIdent()+s+iu->getIgnFlag()+s+se);
     listBox->setCurrentItem(-1);
  } 
}

void IgnListPage::slotEdit()
{
  int idx = listBox->currentItem();
  if (idx<0)
     return;
  LineDialog ldlg(this, "", TRUE, "Edit Ignore User");
  QStrList ll, le;
  ll.setAutoDelete(true);
  le.setAutoDelete(true);
  ll.append("Username :");
  ll.append("Flag :");
  ll.append("Seconds :");
  le.append(listBox->text(idx, 0));
  le.append(listBox->text(idx, 1));
  le.append(listBox->text(idx, 2));
  ldlg.setText(ll, le);
  if (ldlg.exec()){
     QString f = ldlg.getText(0);
     QString p = ldlg.getText(1);
     QString c = ldlg.getText(2);
     if (f.isEmpty() || p.isEmpty())
        return;
     iList->delUser(listBox->text(idx, false));
     IgnoreUser* iu=iList->addUser(f, p, c.toULong());
     if (iu!=0L){
        char s = listBox->separator();
	QString se;se.setNum(iu->getSecond());
	listBox->changeItem(iu->getIdent()+s+iu->getIgnFlag()+s+se, idx);
	listBox->setCurrentItem(idx);
     }
     else{
        listBox->removeItem(idx);
	listBox->setCurrentItem(-1);
     }
  } 
}

void IgnListPage::slotDelete()
{
  int idx = listBox->currentItem();
  if (idx>=0){
     iList->delUser(listBox->text(idx, 0));
     listBox->removeItem(idx);
     listBox->setCurrentItem(-1);
  }
  
}

void IgnListPage::slotApply()
{
  QString entry = "IgnListPath";
  QString path  = "IgnUser.list";
  QString value = ircapp->readPathEntry(entry, path);

  
  QFile f(value);
  if (!f.open(IO_WriteOnly))
     return;
  ircapp->writeEntry(entry, value);
  QTextStream ts(&f);
  ts.device()->at(0);
  IgnoreUser* iu;
  for (iu=iList->first();iu!=0L && (iu->getSecond()>0);iu=iList->next()){
     QString f = iu->getIdent();
     QString p = iu->getIgnFlag();
     QString se; 
     se.setNum(iu->getSecond());
     if (iu->getSecond()>0)
        continue;
     char c = listBox->separator();
     QString s = f+c+p+c+se;
     ts << s << endl;
  }
  entry = "IgnListActivate";
  if (checkBox->isChecked())
    ircapp->writeEntry(entry, "Yes");
  else
    ircapp->writeEntry(entry, "No");
}

void IgnListPage::slotCurrentPage(const char* page)
{
  if (!stricmp(page, name())){
     if (!iList->getUpdate())
        return;
     listBox->clear();
     IgnoreUser* iu;
     for (iu=iList->first();iu!=0L;iu=iList->next()){
        QString u = iu->getIdent();
	QString l = iu->getIgnFlag();
	QString se;
	se.setNum(iu->getSecond());
	char c = listBox->separator();
	QString s=u+c+l+c+se;
	listBox->appendItem(s);
     }
     iList->setUpdate(false);
  }
  QString entry = "IgnListActivate";
  QString value = ircapp->readEntry(entry, "No");
  if (value=="Yes")
    checkBox->setChecked(1);
  else
    checkBox->setChecked(0);
} 



