#include "ircClient.h"
#include <iostream.h>
#include <qlayout.h>
#include "StringToken.h"
#include "optPrefDialog.h"
#include "startActionPage.h"
#include "fontOpt.h"
#include "colorOpt.h"
#include "aliasPage.h"
#include "popupPage.h"
#include "startConfigPage.h"
#include "isonPage.h"
#include "onBrowserPage.h"
#include "onWebServerPage.h"
#include "onPrivMsgPage.h"
#include "onChannelPage.h"
#include "onMediaPage.h"
#include "onCTCPSoundPage.h"
#include "onDCCChatPage.h"
#include "onDCCFilePage.h"
#include "onProxyPage.h"
#include "onUserListPage.h"
#include "onEventPage.h"

#ifdef TCL
#include "tclSwitchPage.h"
#include "onTclPage.h"
#endif

#include <iostream.h>
#include <qlayout.h>

OptPref::OptPref(IrcClient* Client, QWidget* parent, const char* Name):
  PageTab(Client, parent, Name)
{
#ifdef EDEBUG
  cout << "Konstruktor OptPref" << endl;
#endif
  createTreeListItem();
  panner->setSeparatorPos(125);
}

OptPref::~OptPref()
{
#ifdef EDEBUG
  cout << "Destruktor OptPref" << endl;
#endif
}

void OptPref::createTreeListItem()
{
  int i=0;
  QString s;

  int idx = treeList->count();
  s = "Startup";
  treeList->insertItem(s, 0, -1);
  treeList->setCurrentItem(idx);
  
    s = "StartAction";
    treeList->addChildItem(s, 0, idx);
    StartActPage* sap = new StartActPage(client, pageWidget, s);
    page->insert(s, sap);

    s = "StartConfig";
    treeList->addChildItem(s, 0, idx);
    StartConfigPage* cp = new StartConfigPage(client, pageWidget, s);
    page->insert(s, cp);
    connect(this,
	    SIGNAL(signCurrentPage(const char*)),
	    cp,
	    SLOT  (slotCurrentPage(const char*)));

  s = "Color";
  treeList->insertItem(s, 0, i++, 0);
  ColorOpt* co = new ColorOpt(pageWidget);
  page->insert(s, co);

  s = "Font";
  treeList->insertItem(s, 0, i++, 0);
  FontOpt* fo = new FontOpt(pageWidget);
  page->insert(s, fo);

  s = "Alias";
  treeList->insertItem(s, 0, i++, 0);
  AliasPage* ap = new AliasPage(client->alias, pageWidget);
  page->insert(s, ap);

  s = "Ison";
  treeList->insertItem(s, 0, i++, 0);
  IsonPage* iop = new IsonPage(client, pageWidget);
  page->insert(s, iop);

  s = "Browser";
  treeList->insertItem(s, 0, i++, 0);
  OnBrowserPage* obp = new OnBrowserPage(client, pageWidget);
  page->insert(s, obp);

  s = "MediaPlayer";
  treeList->insertItem(s, 0, i++, 0);
  OnMediaPage* omp = new OnMediaPage(client, pageWidget);
  page->insert(s, omp);

  s = "OnEventOutput";
  treeList->insertItem(s, 0, i++, 0);
  OnEventOutputPage* oeop = new OnEventOutputPage(client, pageWidget);
  page->insert(s, oeop);
 
  s = "Popup";
  treeList->insertItem(s, 0, i++, 0);
  idx = i;
  treeList->setCurrentItem(idx);
  
    s = "MainPopup";
    treeList->addChildItem(s, 0, idx);
    IrcPopup* ip = client->popup.find("Main");
    PopupPage* pp;
    if (ip){
       pp = new PopupPage(ip, "Main", pageWidget);
       page->insert(s, pp);
    }

    s = "ChannelPopup";
    treeList->addChildItem(s, 0, idx);
    ip = client->popup.find("Channel");
    if (ip){
       pp = new PopupPage(ip, "Channel", pageWidget);
       page->insert(s, pp);
    }

    s = "UserListPopup";
    treeList->addChildItem(s, 0, idx);
    ip = client->popup.find("UserList");
    if (ip){
       pp = new PopupPage(ip, "UserList", pageWidget);
       page->insert(s, pp);
    }

    s = "PrivMsgPopup";
    treeList->addChildItem(s, 0, idx);
    ip = client->popup.find("PrivMsg");
    if (ip){
       pp = new PopupPage(ip, "PrivMsg", pageWidget);
       page->insert(s, pp);
    }

    s = "DCCChatPopup";
    treeList->addChildItem(s, 0, idx);
    ip = client->popup.find("DCCChat");
    if (ip){
       pp = new PopupPage(ip, "DCCChat", pageWidget);
       page->insert(s, pp);
    }

    s = "DCCFilePopup";
    treeList->addChildItem(s, 0, idx);
    ip = client->popup.find("DCCFile");
    if (ip){
       pp = new PopupPage(ip, "DCCFile", pageWidget);
       page->insert(s, pp);
    }

    s = "InputPopup";
    treeList->addChildItem(s, 0, idx);
    ip = client->popup.find("Input");
    if (ip){
       pp = new PopupPage(ip, "Input", pageWidget);
       page->insert(s, pp);
    }

    s = "DefaultPopup";
    treeList->addChildItem(s, 0, idx);
    ip = client->popup.find("Default");
    if (ip){
       pp = new PopupPage(ip, "Default", pageWidget);
       page->insert(s, pp);
    }
  
  s = "PrivMsg";
  treeList->insertItem(s, 0, i++, 0);
  idx = i;
  treeList->setCurrentItem(idx);
    s = "PrivMsgPopup";
    treeList->addChildItem(s, 0, idx);

    s = "OnPrivMsg";
    treeList->addChildItem(s, 0, idx);
    OnPrivMsgPage* opp = new OnPrivMsgPage(client, pageWidget, s);
    page->insert(s, opp);
    connect(this,
	    SIGNAL(signCurrentPage(const char*)),
	    opp,
	    SLOT  (slotCurrentPage(const char*)));

  s = "Channel";
  treeList->insertItem(s, 0, i++, 0);
  idx = i;
  OnChannelAction* occ = new OnChannelAction(client, pageWidget);
  page->insert(s, occ);

  treeList->setCurrentItem(idx);
    s = "ChannelPopup";
    treeList->addChildItem(s, 0, idx);
    s = "UserListPopup";
    treeList->addChildItem(s, 0, idx);

    s = "OnInvite";
    treeList->addChildItem(s, 0, idx);
    OnInvitePage* oip = new OnInvitePage(client, pageWidget, s);
    page->insert(s, oip);
    connect(this,
	    SIGNAL(signCurrentPage(const char*)),
	    oip,
	    SLOT  (slotCurrentPage(const char*)));

    s = "OnKick";
    treeList->addChildItem(s, 0, idx);
    OnKickPage* okp = new OnKickPage(client, pageWidget, s);
    page->insert(s, okp);
    connect(this,
	    SIGNAL(signCurrentPage(const char*)),
	    okp,
	    SLOT  (slotCurrentPage(const char*)));

  s = "DCC";
  treeList->insertItem(s, 0, i++, 0);
  idx = i;
  treeList->setCurrentItem(idx);
    s = "DCCChatPopup";
    treeList->addChildItem(s, 0, idx);

    s = "DCCFilePopup";
    treeList->addChildItem(s, 0, idx);
    
    s = "OnDCCChat";
    treeList->addChildItem(s, 0, idx);
    OnDCCChatPage* odcp = new OnDCCChatPage(client, pageWidget, s);
    page->insert(s, odcp);
    connect(this,
	    SIGNAL(signCurrentPage(const char*)),
	    odcp,
	    SLOT  (slotCurrentPage(const char*)));

    s = "OnDCCFile";
    treeList->addChildItem(s, 0, idx);
    OnDCCFilePage* odfp = new OnDCCFilePage(client, pageWidget, s);
    page->insert(s, odfp);
    connect(this,
	    SIGNAL(signCurrentPage(const char*)),
	    odfp,
	    SLOT  (slotCurrentPage(const char*)));
    
  s = "CTCP";
  treeList->insertItem(s, 0, i++, 0);
  idx = i;
  treeList->setCurrentItem(idx);
    s = "OnCTCPSound";
    treeList->addChildItem(s, 0, idx);
    OnCTCPSoundPage* ocsp = new OnCTCPSoundPage(client, pageWidget, s);
    page->insert(s, ocsp);
    connect(this,
	    SIGNAL(signCurrentPage(const char*)),
	    ocsp,
	    SLOT  (slotCurrentPage(const char*)));

  s = "OnUserList";
  treeList->insertItem(s, 0, i++, 0);
  OnUserPage* ousp=new OnUserPage(client, pageWidget, s);
  page->insert(s, ousp);
  idx = i;
  treeList->setCurrentItem(idx);
    s = "FriendList";
    treeList->addChildItem(s, 0, idx);
    FriendListPage* frlp = new FriendListPage(client->friendList, pageWidget, s);
    page->insert(s, frlp);
    connect(this,
	    SIGNAL(signCurrentPage(const char*)),
	    frlp,
	    SLOT  (slotCurrentPage(const char*)));

    s = "BanList";
    treeList->addChildItem(s, 0, idx);
    BanListPage* balp = new BanListPage(client->banList, pageWidget, s);
    page->insert(s, balp);
    connect(this,
	    SIGNAL(signCurrentPage(const char*)),
	    balp,
	    SLOT  (slotCurrentPage(const char*)));

    s = "IgnoreList";
    treeList->addChildItem(s, 0, idx);
    IgnListPage* iglp = new IgnListPage(client->ignList, pageWidget, s);
    page->insert(s, iglp);
    connect(this,
	    SIGNAL(signCurrentPage(const char*)),
	    iglp,
	    SLOT  (slotCurrentPage(const char*)));

  s = "OnWebServer";
  treeList->insertItem(s, 0, i++, 0);
  idx = i;
  treeList->setCurrentItem(idx);
    s = "WebServerConfig";
    treeList->addChildItem(s, 0, idx);
    OnWebServerPage* owsp = new OnWebServerPage(client->webServer, pageWidget);
    page->insert(s, owsp);

    s = "MimeTypes";
    treeList->addChildItem(s, 0, idx);
    MimeTypePage* mtp = new MimeTypePage(client->webServer->mimeTypes, pageWidget);
    page->insert(s, mtp);  

  slotSetPage(idx);
}

void OptPref::loadScript()
{
  QString s;
  int i = treeList->currentItem();
  int idx;
#ifdef TCL
  s = "TCLScript";
  treeList->insertItem(s, 0, i++, 0);
  TclSwitchPage* tsp=new TclSwitchPage(client, pageWidget);
  page->insert(s, tsp);
  idx = i;
  treeList->setCurrentItem(idx);
    s = "Loading Tcl Script";
    treeList->addChildItem(s, 0, idx);
    OnTclPage* tclp = new OnTclPage(client, pageWidget);
    page->insert(s, tclp);
#endif
  slotSetPage(0);
}


OptPrefDialog::OptPrefDialog(IrcClient* Client, QWidget* parent, const char* Name) :
  QDialog(parent, Name, FALSE)
{
#ifdef EDEBUG
  cout << "Konstruktor OptPrefDialog" << endl;
#endif
  setCaption("Preferences Dialog");

  QVBoxLayout* vbox = new QVBoxLayout(this, 10);
  optPref = new OptPref(Client, this, Name);
  vbox->addWidget(optPref, 10);
  QFrame* lineFrame = new QFrame(this);
  lineFrame->setFrameStyle( QFrame::HLine | QFrame::Sunken );
  lineFrame->setLineWidth(1);
  lineFrame->setMidLineWidth(1);
  vbox->addWidget(lineFrame);
  lineFrame->setFixedHeight(10);
  QHBoxLayout* hbox = new QHBoxLayout(0);
  vbox->addLayout(hbox);
  hbox->addStretch(10);
  QPushButton* btn=new QPushButton(" Ok ", this);
  hbox->addWidget(btn);
  btn->setFixedSize(100, 25);
  hbox->addStretch(10);
  connect(btn, SIGNAL(clicked()),
	  this,SLOT  (accept()));

  vbox->activate();
  setFixedWidth(650);
  setMinimumHeight(450);
#ifdef EDEBUG
  cout << "Konstruktor OptPrefDialog...Ok" << endl;
#endif
}

OptPrefDialog::~OptPrefDialog()
{
  
}

void OptPrefDialog::show(const char* name)
{
#ifdef EDEBUG
  cout << "OptPrefDialog::show"<<endl;
#endif
  QPoint p=pos();
  move(p);

  if (name){
     KTreeListItem* item;
     for (uint i=0;i<optPref->treeList->count();i++){
        item = optPref->treeList->itemAt(i);
	if (!stricmp(name, item->getText())){
	   optPref->slotSetPage(i);
	   optPref->treeList->expandItem(i);
	   break;
	}
     } 
  }

  if (isVisible())
     raise();
  else
     QDialog::show();
}

QWidget* OptPrefDialog::getPage(const char* name)
{
  return optPref->getPage(name);
}

