#include <stdlib.h>
#include <iostream.h>
#include <qpushbt.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include "kprocess.h"
#include "kmsgbox.h"
#include "StringToken.h"
#include "ircDefine.h"
#include "ircClient.h"
#include "lineDialog.h"
#include "onMediaPage.h"
#include "onMediaPage.moc"
#include "ircApp.h"

OnMediaPage::OnMediaPage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget(parent, name)
{
#ifdef EDEBUG
  cout << "OnMediaPage Konstruktor"<<endl;
#endif
  this->client=client;

  horLayout  = new QHBoxLayout(this, 10);
  lVerLayout = new QVBoxLayout(5);
  horLayout->addLayout(lVerLayout,5);

  createPlayerBox();
  lVerLayout->addSpacing(30);

  rVerLayout = new QVBoxLayout(0);
  horLayout->addLayout(rVerLayout,1);
  createButton();

  horLayout->activate();

  readConfig();
  show();
#ifdef EDEBUG
  cout << "OnMediaPage Konstruktor ...Ok" << endl;
#endif
}

OnMediaPage::~OnMediaPage()
{
#ifdef EDEBUG
  cout << "Destruktor OnMediaPage" << endl;
#endif
}


void OnMediaPage::createPlayerBox()
{
#ifdef EDEBUG
  cout << "OnMediaPage::createPlayerBox" << endl;
#endif

  QFrame* playerFrame = new QFrame(this);
  playerFrame->setLineWidth(2);
  playerFrame->setFrameStyle(QFrame::Panel|QFrame::Sunken);

  lVerLayout->addWidget(playerFrame);

  QVBoxLayout* vbox = new QVBoxLayout(playerFrame, 3);;

  playerBox   = new KTabListBox(playerFrame, "fileBox", 2);
  vbox->addWidget(playerBox);
  playerBox->setColumn(0, "Format");
  playerBox->setColumn(1, "Player");
  playerBox->setColumnWidth(0, 75);
  playerBox->setColumnWidth(1, 150);
  playerBox->setSeparator  (':');
  vbox->activate();
}

void OnMediaPage::createButton()
{
#ifdef EDEBUG
  cout << "OnMediaPage::createBotton" << endl;
#endif
  QPushButton* btn;

  btn = new QPushButton(" Add ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotAdd()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);
  btn = new QPushButton(" Edit ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotEdit()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  btn = new QPushButton(" Delete ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotDelete()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  rVerLayout->addSpacing(10);

  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);
  rVerLayout->addStretch(10);
}

void OnMediaPage::readConfig()
{
#ifdef EDEBUG
  cout << "OnMediaPage::readConfig" << endl;
#endif
  KConfig* config=ircapp->getConfig();
  config->setGroup(ircapp->entryGroup);
  playerBox->clear();
  QStrList list;
  list.setAutoDelete(true);
  client->mediaPlayer->clear();
  int n=config->readListEntry("MediaPlayer", list, playerBox->separator());
  if (n>0){
     playerBox->appendStrList(&list);
     for (uint i=0;i<playerBox->count();i++){
        QString f = playerBox->text(i, 0);
	QString p = playerBox->text(i, 1);
	client->mediaPlayer->insert(f, qstrdup(p));
     }
  }
}

bool OnMediaPage::checkItem(QString f)
{
  for (uint i=0;i<playerBox->count();i++){
     QString t=playerBox->text(i, 0);
     if (!stricmp(f, t)){
       KMsgBox::message(this, "Add Dialog", "This format "+t+ " is already exist", 
			KMsgBox::INFORMATION, "OK");
       return true;
     }
  }
  return false;
}

void OnMediaPage::slotAdd()
{
  LineDialog ldlg(this, "", TRUE, "Add Media-Player");
  QStrList ll, le;
  ll.setAutoDelete(true);
  ll.append("Format :");
  ll.append("Player :");
  ldlg.setText(ll, le);
  if (ldlg.exec()){
     QString f = ldlg.getText(0);
     QString p = ldlg.getText(1);
     if (!f.isEmpty() && !p.isEmpty()){
        if (checkItem(f))
	   return;
        playerBox->appendItem(f+playerBox->separator()+p);
	playerBox->setCurrentItem(-1);
     } 
  }
}

void OnMediaPage::slotEdit()
{
  int idx = playerBox->currentItem();
  if (idx<0)
     return;
  LineDialog ldlg(this, "", TRUE, "Edit Media-Player");
  QStrList ll, le;
  ll.setAutoDelete(true);
  le.setAutoDelete(true);
  ll.append("Format :");
  ll.append("Player :");
  le.append(playerBox->text(idx, 0));
  le.append(playerBox->text(idx, 1));
  ldlg.setText(ll, le);
  if (ldlg.exec()){
     QString f = ldlg.getText(0);
     QString p = ldlg.getText(1);
     if (!f.isEmpty() && !p.isEmpty()){
        playerBox->changeItem(f+playerBox->separator()+p, idx);
	playerBox->setCurrentItem(idx);
     } 
  }
}

void OnMediaPage::slotDelete()
{
  int idx = playerBox->currentItem();
  if (idx>=0)
     playerBox->removeItem(idx);
  
}

void OnMediaPage::slotApply()
{
  KConfig* config=ircapp->getConfig();
  config->setGroup(ircapp->entryGroup);
  QStrList list;
  list.setAutoDelete(true);
  QString s;
  client->mediaPlayer->clear();
  for (uint i=0;i<playerBox->count();i++){
     QString f = playerBox->text(i, 0);
     QString p = playerBox->text(i, 1);
     s = f+playerBox->separator()+p;
     list.append(s);
     client->mediaPlayer->insert(f, qstrdup(p));
  }
  if (playerBox->count()>0){
     config->writeEntry("MediaPlayer", list, playerBox->separator());
     config->sync();
  }
}

