/* $Id: dlgSystem.cpp,v 1.2 1999/02/18 19:01:37 koss Exp $
   $Log: dlgSystem.cpp,v $
   Revision 1.2  1999/02/18 19:01:37  koss
   *** empty log message ***

   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.1  1999/02/07 17:11:28  matt
   source entered


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

extern "C" {
#include <mediatool.h>
}

#include <qlayout.h>

#include <kapp.h>
#include <kfontdialog.h>
#include <kaudio.h>
#include <kdebug.h>

#include <kio_linedit_dlg.h>

#include "dlgSystem.h"

extern QString getStringFromBool( bool x );
extern bool getBoolFromString( QString s );

DlgSystem::DlgSystem(QWidget *parent, const char *name, WFlags f)
  : QWidget(parent, name, f)
{

  QGridLayout *topGridLayout = new QGridLayout(this, 7, 6, 5);

  topGridLayout->addRowSpacing(0,10);
  topGridLayout->addRowSpacing(4,10);
  topGridLayout->addRowSpacing(6,10);

  topGridLayout->addColSpacing(0,5);
  topGridLayout->addColSpacing(5,5);

  topGridLayout->setRowStretch(0,5);
  topGridLayout->setRowStretch(1,10);
  topGridLayout->setRowStretch(2,10);
  topGridLayout->setRowStretch(3,10);
  topGridLayout->setRowStretch(4,10);
  topGridLayout->setRowStretch(5,10);
  topGridLayout->setRowStretch(6,5);
    
  topGridLayout->setColStretch(0,2);
  topGridLayout->setColStretch(1,5);
  topGridLayout->setColStretch(2,5);
  topGridLayout->setColStretch(3,5);
  topGridLayout->setColStretch(4,5);
  topGridLayout->setColStretch(5,2);

  // sound settings

  cb_useSound = new QCheckBox(i18n("Use Sounds"), this );
  cb_useSound->setMinimumSize( cb_useSound->sizeHint() );
  topGridLayout->addWidget( cb_useSound, 1, 1 );
  
  cmb_sounds = new QComboBox( this );

  cmb_sounds->insertItem( i18n("Finished") );
  cmb_sounds->insertItem( i18n("Finished All") );
  cmb_sounds->insertItem( i18n("Start Timed") );
  cmb_sounds->setFixedSize( cmb_sounds->sizeHint() );
  topGridLayout->addWidget( cmb_sounds, 1, 2 );

  pb_changesound = new QPushButton(i18n("Change"), this );
  pb_changesound->setFixedSize( pb_changesound->sizeHint() );
  topGridLayout->addWidget( pb_changesound, 1, 3 );
  connect( pb_changesound, SIGNAL( clicked() ), SLOT( setupSound() ) );

  pb_testsound = new QPushButton(i18n("Test"), this );
  pb_testsound->setFixedSize( pb_testsound->sizeHint() );
  topGridLayout->addWidget( pb_testsound, 1, 4 );
  connect( pb_testsound, SIGNAL( clicked() ), SLOT( testSound() ) );

  connect( cb_useSound, SIGNAL(toggled(bool)), cmb_sounds, SLOT(setEnabled(bool)) );
  connect( cb_useSound, SIGNAL(toggled(bool)), pb_changesound, SLOT(setEnabled(bool)) );
  connect( cb_useSound, SIGNAL(toggled(bool)), pb_testsound, SLOT(setEnabled(bool)) );

  // animation settings
  cb_useAnimation = new QCheckBox(i18n("Use Animation"), this );
  cb_useAnimation->setMinimumSize( cb_useAnimation->sizeHint() );
  topGridLayout->addMultiCellWidget( cb_useAnimation, 2, 2, 1, 2 );

  // dock settings
  cb_dock = new QCheckBox(i18n("Dock into a panel"), this );
  cb_dock->setMinimumSize( cb_dock->sizeHint() );
  topGridLayout->addMultiCellWidget( cb_dock, 3, 3, 1, 2 );

  // font groupbox
  gb_font = new QGroupBox(this, "gb_font");
  gb_font->setTitle(i18n("Font Settings"));
  topGridLayout->addMultiCellWidget( gb_font, 5, 5, 1, 4 );

  QGridLayout *gLayout = new QGridLayout( gb_font, 3, 2, 10 );

  gLayout->addRowSpacing(0, 10);
  gLayout->addRowSpacing(2, 10);

  gLayout->setRowStretch(0,1);
  gLayout->setRowStretch(1,2);
  gLayout->setRowStretch(2,2);
    
  gLayout->setColStretch(0,10);
  gLayout->setColStretch(1,5);

  lb_font = new QLabel(i18n("Dolor lpse"), gb_font);
  lb_font->setAlignment(AlignHCenter | AlignVCenter);
  lb_font->setBackgroundColor( QColor( white ));
  lb_font->setFrameStyle( QFrame::Box | QFrame::Sunken );
  gLayout->addWidget( lb_font, 1, 0 );

  pb_browse = new QPushButton(i18n("Change"), gb_font );
  pb_browse->setFixedSize( pb_browse->sizeHint() );
  connect( pb_browse, SIGNAL( clicked() ), SLOT( changeFont() ) );
  gLayout->addWidget( pb_browse, 1, 1 );

  topGridLayout->activate();

}


DlgSystem::~DlgSystem()
{
}


void DlgSystem::setupSound() {
  QString s, t;

  int id = cmb_sounds->currentItem();

  switch ( id ) {
  case 0:
    s = i18n( "Filename for finished sound :" );
    t = soundFinished;
    break;
  case 1:
    s = i18n( "Filename for finished-all sound :" );
    t = soundFinishedAll;
    break;
  case 2:
    s = i18n( "Filename for start-timed sound :" );
    t = soundStartTimed;
    break;
  }

  KLineEditDlg *box = new KLineEditDlg( s.data(), t.data(), this);
  box->show();

  if (!box->result())   /* cancelled */
    return;

  s = box->text();
  if ( s.isEmpty() ) /* answer is "" */
    return;

  switch ( id ) {
  case 0:
    soundFinished = s;
    break;
  case 1:
    soundFinishedAll = s;
    break;
  case 2:
    soundStartTimed = s;
    break;
  }
}



void DlgSystem::testSound() {

  int id = cmb_sounds->currentItem();

  KAudio *audio = new KAudio;
  if ( audio->serverStatus() ){
    kdebug( KDEBUG_ERROR, 5001, "Failed contacting audio server !");
    return;
  }

  switch ( id ) {
  case 0:
    audio->play( soundFinished );
    break;
  case 1:
    audio->play( soundFinishedAll );
    break;
  case 2:
    audio->play( soundStartTimed );
    break;
  }

}


void DlgSystem::changeFont()
{
  KFontDialog *fnd = new KFontDialog( this, "", true );
  fnd->setFont( lb_font->font() );

  if ( fnd->exec() )
    lb_font->setFont( fnd->font() );

  delete fnd;
}


void DlgSystem::setFontData( QFont font )
{
  lb_font->setFont( font );
}


QFont DlgSystem::getFontData() const
{
  return lb_font->font();
}


void DlgSystem::setData(QStrList *strList)
{

  bool useSound = getBoolFromString( strList->first() );
  cb_useSound->setChecked( useSound );
  cmb_sounds->setEnabled( useSound );
  pb_changesound->setEnabled( useSound );
  pb_testsound->setEnabled( useSound );

  soundFinished = strList->next();
  soundFinishedAll = strList->next();
  soundStartTimed = strList->next();

  cb_useAnimation->setChecked( getBoolFromString( strList->next() ) );
  cb_dock->setChecked( getBoolFromString( strList->next() ) );
}


static QStrList strList(true);

QStrList DlgSystem::getData() const
{
  strList.clear();
  
  strList.append( getStringFromBool( cb_useSound->isChecked() ) );

  strList.append( soundFinished.data() );
  strList.append( soundFinishedAll.data() );
  strList.append( soundStartTimed.data() );

  strList.append( getStringFromBool( cb_useAnimation->isChecked() ) );
  strList.append( getStringFromBool( cb_dock->isChecked() ) );

  return strList;
}

