#ifndef _BLINKLISTBOX_H
#define _BLINKLISTBOX_H

#include <kapp.h>
#include <kiconloader.h>
#include <qpixmap.h>
#include <qfont.h>
#include <qpainter.h>
#include <qlistbox.h>
#include <qpixmap.h>

enum blPaintMode { FREEZE, VANISH } ; 

class WBlinkListBoxItem : public QListBoxItem
{
public:
  WBlinkListBoxItem(const char*);
  WBlinkListBoxItem() ;
  void setPixmap(int,const QPixmap &) ;
  void setPixmapXY(int,int) ;
  void setPaintMode(blPaintMode) ;
  int togglePixmap();
  void resetPixmap();
  void setBlinking(int);
  int isBlinking();
  int pixmapMaxWidth() const;
  int pixmapMaxHeight() const;
  int pixmapX() { return pmapX ; }
  int pixmapY() { return pmapY ; }
protected:
  virtual void paint(QPainter*);
  virtual const QPixmap *pixmap();
  const QPixmap *activePixmap() const;
  virtual int height(const QListBox*) const;
  virtual int width(const QListBox*) const;
  int isBlinkingFlag;
  QPixmap pmap1, pmap2;
  KIconLoader *lLoader;
  int activePixmapNo;
  int pmapX,pmapY ;
  blPaintMode paintMode ;
private:
};

class WBlinkListBox : public QListBox
{
  Q_OBJECT
public:
  WBlinkListBox(QWidget *parent=0, const char *name=0, WFlags f=0);
  void setBlinkInterval(int);
  void setBlinking(int,int);
  int blinkItemsCount();
protected:
  int timerId;
  int blinkInterval;
  virtual void timerEvent(QTimerEvent*);
private:
};
#endif /* _BLINKLISTBOX_H */
