// $Id: emailwidget.cpp,v 1.3 1998/12/08 16:15:28 denis Exp $
// $Log: emailwidget.cpp,v $
// Revision 1.3  1998/12/08 16:15:28  denis
// Cleaned up a little before releasing
//

#include "emailwidget.h"

#include "emailwidget.moc"

EMailWidget::EMailWidget(QWidget *parent) : QWidget(parent)
{
  label1 = new QLabel("Enter the user's valid E-mail address:",this);
  emailbox = new QGroupBox("Search Users By E-mail", this);
  emailline = new QLineEdit(this);
  label2 = new QLabel(emailline, "EMail:", this);
}

EMailWidget::~EMailWidget()
{
  if(label1)
    delete label1;
  if(label2)
    delete label2;
  if(emailline)
    delete emailline;
  if(emailbox)
    delete emailbox;
}

void EMailWidget::resizeEvent(QResizeEvent *re)
{
  QSize label1size, label2size, emaillinesize;
  QWidget::resizeEvent(re);
  label1size = label1->sizeHint();
  label1->setGeometry(10,10,label1size.width(),label1size.height());
  emailbox->setGeometry(6,30,width()-13,height()-37);
  label2size = label2->sizeHint();
  emaillinesize = emailline->sizeHint();
  int h = QMAX(label2size.height(),emaillinesize.height());
  label2->setGeometry(15,30+(emailbox->height()-h)/2,label2size.width(),h);
  emailline->setGeometry(label2->width()+20,30+(emailbox->height()-h)/2,emailbox->width()-label2->width()-24,h);
}

const char *EMailWidget::email()
{
  return emailline->text();
}

void EMailWidget::clear()
{
  emailline->setText("");
}
