// $Id: infonotes.cpp,v 1.3 1998/12/08 16:18:18 denis Exp $
// $Log: infonotes.cpp,v $
// Revision 1.3  1998/12/08 16:18:18  denis
// Cleaned up a little before releasing
//

#include "infonotes.h"

#include "infonotes.moc"

NotesWidget::NotesWidget(QWidget *parent) : QWidget(parent)
{
  notesbox = new QMultiLineEdit(this);
}

NotesWidget::~NotesWidget()
{
  if(notesbox)
    delete notesbox;
}

void NotesWidget::resizeEvent(QResizeEvent *re)
{
  QWidget::resizeEvent(re);
  notesbox->setGeometry(6,6,width()-12,height()-12);
}

void NotesWidget::setInfo(const char *pnotes)
{
  notesbox->setText(pnotes);
}

QString NotesWidget::text()
{
  return notesbox->text();
}
