// $Id: prefproxy.cpp,v 1.2 1998/11/19 13:17:15 denis Exp $
// $Log: prefproxy.cpp,v $
// Revision 1.2  1998/11/19 13:17:15  denis
// Username/Password Auth with check box added
// Password input line's echo character changed
//

#include "prefproxy.h"

#include "prefproxy.moc"

ProxyWidget::ProxyWidget(QWidget *parent) : QWidget(parent)
{
  mainlabel = new QLabel("Enter Proxy Settings:",this);
  proxybox = new QGroupBox("SOCKS5 Proxy", this);
  usebox = new QCheckBox("Use SOCKS5 Proxy", this);
  connect(usebox, SIGNAL(toggled(bool)), SLOT(useToggled(bool)));
  hostline = new QLineEdit(this);
  hostlabel = new QLabel(hostline, "Server:", this);
  portline = new KIntegerLine(this);
  portlabel = new QLabel(portline, "Port:", this);
  authbox = new QCheckBox("RFC1929 Username/Password Authentication", this);
  connect(authbox, SIGNAL(toggled(bool)), SLOT(authToggled(bool)));
  userline = new QLineEdit(this);
  userlabel = new QLabel(hostline, "User:", this);
  passline = new QLineEdit(this);
  passline->setEchoMode(QLineEdit::Password);
  passlabel = new QLabel(hostline, "Password:", this);
}

ProxyWidget::~ProxyWidget()
{
  if(usebox)
    delete usebox;
  if(authbox)
    delete authbox;
  if(portlabel)
    delete portlabel;
  if(portline)
    delete portline;
  if(hostlabel)
    delete hostlabel;
  if(hostline)
    delete hostline;
  if(userline)
    delete userline;
  if(passline)
    delete passline;
  if(mainlabel)
    delete mainlabel;
  if(proxybox)
    delete proxybox;
}

void ProxyWidget::resizeEvent(QResizeEvent *re)
{
  QSize mainlblsize, portlblsize, hostlblsize, userlblsize, passlblsize,
    portlinesize, hostlinesize, userlinesize, passlinesize, useboxsize, authboxsize;
  QWidget::resizeEvent(re);
  mainlblsize = mainlabel->sizeHint();
  useboxsize = usebox->sizeHint();
  mainlabel->setGeometry(10,10,mainlblsize.width(),mainlblsize.height());
  usebox->setGeometry(10,15+mainlblsize.height(),useboxsize.width(),useboxsize.height());
  proxybox->setGeometry(7,30+useboxsize.height(),width()-13,height()-useboxsize.height()-37);
  hostlblsize = hostlabel->sizeHint();
  portlblsize = portlabel->sizeHint();
  userlblsize = userlabel->sizeHint();
  passlblsize = passlabel->sizeHint();
  hostlinesize = hostline->sizeHint();
  portlinesize = portline->sizeHint();
  authboxsize = authbox->sizeHint();
  userlinesize = userline->sizeHint();
  passlinesize = passline->sizeHint();
  int w = QMAX(QMAX(portlblsize.width(),hostlblsize.width()),
               QMAX(userlblsize.width(),passlblsize.width()));
  int h = QMAX(QMAX(QMAX(QMAX(portlblsize.height(), hostlblsize.height()),
                         QMAX(portlinesize.height(), hostlinesize.height())),
                    QMAX(QMAX(userlblsize.height(), passlblsize.height()),
                         QMAX(userlinesize.height(), passlinesize.height()))),authboxsize.height());
  hostlabel->resize(w,h);
  portlabel->resize(w,h);
  userlabel->resize(w,h);
  passlabel->resize(w,h);
  hostline->resize(width()-w-40,h);
  portline->resize(width()-w-40,h);
  authbox->resize(proxybox->width()-10,h);
  userline->resize(width()-w-40,h);
  passline->resize(width()-w-40,h);
  int mh = (proxybox->height()-20)/5;
  hostlabel->move(15,proxybox->y()+mh/2-h/2+15);
  hostline->move(w+23,proxybox->y()+mh/2-h/2+15);
  portlabel->move(15,proxybox->y()+mh+mh/2-h/2+15);
  portline->move(w+23,proxybox->y()+mh+mh/2-h/2+15);
  authbox->move(15,proxybox->y()+mh*2+mh/2-h/2+15);
  userlabel->move(15,proxybox->y()+mh*3+mh/2-h/2+15);
  userline->move(w+23,proxybox->y()+mh*3+mh/2-h/2+15);
  passlabel->move(15,proxybox->y()+mh*4+mh/2-h/2+15);
  passline->move(w+23,proxybox->y()+mh*4+mh/2-h/2+15);
}

void ProxyWidget::setInfo(int use, const char *host, int port, int auth, const char *user, const char *pass)
{
  usebox->setChecked(use);
  hostline->setText(host);
  portline->setValue(port);
  authbox->setChecked(auth);
  userline->setText(user);
  passline->setText(pass);
  if(!use)
  {
    hostline->setEnabled(FALSE);
    portline->setEnabled(FALSE);
    authbox->setEnabled(FALSE);
    userline->setEnabled(FALSE);
    passline->setEnabled(FALSE);
  }
  if(!auth)
  {
    userline->setEnabled(FALSE);
    passline->setEnabled(FALSE);
  }
}

int ProxyWidget::use()
{
  return usebox->isChecked();
}

const char *ProxyWidget::host()
{
  return hostline->text();
}

int ProxyWidget::port()
{
  return portline->value();
}

int ProxyWidget::auth()
{
  return authbox->isChecked();
}

const char *ProxyWidget::user()
{
  return userline->text();
}

const char *ProxyWidget::pass()
{
  return passline->text();
}

void ProxyWidget::useToggled(bool p)
{
  if(p)
  {
    hostline->setEnabled(TRUE);
    portline->setEnabled(TRUE);
    authbox->setEnabled(TRUE);
    if(authbox->isChecked())
    {
      userline->setEnabled(TRUE);
      passline->setEnabled(TRUE);
    }
    else
    {
      userline->setEnabled(FALSE);
      passline->setEnabled(FALSE);
    }
  }
  else
  {
    hostline->setEnabled(FALSE);
    portline->setEnabled(FALSE);
    authbox->setEnabled(FALSE);
    userline->setEnabled(FALSE);
    passline->setEnabled(FALSE);
  }
}

void ProxyWidget::authToggled(bool p)
{
  if(p)
  {
    userline->setEnabled(TRUE);
    passline->setEnabled(TRUE);
  }
  else
  {
    userline->setEnabled(FALSE);
    passline->setEnabled(FALSE);
  }
}
