// KDE headers
#include <kapp.h>
#include <drag.h>
#include <ktopwidget.h>
#include <kmenubar.h>
#include <kiconloader.h>
#include <klocale.h>
#include <ktreelist.h>
#include <knewpanner.h>
#include <ktabctl.h>

// QT headers
#include <qwidget.h>
#include <qpushbt.h>
#include <qcolor.h>
#include <qstring.h>
#include <qstring.h>
#include <qlabel.h>
#include <qmsgbox.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <qcombo.h>
#include <qfile.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qlistview.h>

// C/C++ headers
#include <time.h>
#include <iostream.h>
#include <map.h>
#include <vector.h>

// LDAP headers
#include <lber.h> // Muss unbedingt vor ldap.h stehen
#include <ldap.h>

#define ID_EXIT 0
#define ID_CONNECT 1
#define ID_ATTRIBUTE_LIST 2
#define ID_DELETE 3 
#define ID_ADD 4
#define ID_SEARCH 5

#define KLDAP_MODE_SEARCH 1

class MyConfig : QObject
{
  //Q_OBJECT
public:
  MyConfig(QString filename); // rowChar --> z.B. '\t'
  QString filename;
  map < const char*, vector<char*> > configMap;
};

class AttributeWidget : public QWidget
{
public:
  AttributeWidget(QWidget* parent);
  void newWidget(QWidget* widget);
private:
  QVBoxLayout* layout;
  QWidget* parent;
  QWidget* widget;
};

class LDAPItem : public KTreeListItem
{
public:
  LDAPItem(char* text, QPixmap* pixmap, char* dn);
  void setDN(char* dn);
  char* getDN();
private:
  char *dn;
};

class Kldapw : public KTreeList
{
  Q_OBJECT
public:
  Kldapw(QWidget* parent);
  char* getSelectedDN();
  LDAP* getLDAP();
  int modify(char* dn, int mod_op, char* mod_type, char* value);
  void deleteEntry();
  bool isBound();
  QPixmap getPixmap(char* name);
  LDAP* getldap();
  void setldap(LDAP* ldap);
  void unbind();
public slots:
  void expandLDAPTree(int itemIndex);
  void selectedSlot(int itemIndex);
  bool connect(char* host, int port, char* rootDN);
  void setRootDN(char* rootDN);
  char* getRootDN();
  void bind(char* who, char* cred, int method);
private:
  LDAP* ldap;
  bool refill;
  void buildTree(char* base, int itemIndex, int scope=LDAP_SCOPE_ONELEVEL);
  KIconLoader* loader;
  QPixmap pixRootNode;
  QPixmap pixOrganizationNode;
  QPixmap* pixmap;
  char* rootDN;
  void setRefill(bool refill);
  bool isRefill();
  bool bound;
};

class MainView : public QWidget
{
  Q_OBJECT
public:
  MainView(QWidget* parent);
  AttributeWidget* attributeWidget;
  Kldapw* kldapw;
public slots:
  void menuCallback(int);
private:  
  KNewPanner* panner; 
};

class MainWidget : public KTopLevelWidget
{
  Q_OBJECT
public:
  MainWidget(const char *name=0);
  QPushButton* btntest;
public slots:
};

class KldapPage : public QWidget
{
  Q_OBJECT
public:
  KldapPage(QWidget* parent, Kldapw* kldap);
  Kldapw* kldapw;
  LDAP* ldap;
  char* dn;
};

class ConnectPage : public KldapPage
{
  Q_OBJECT
public:
  ConnectPage(QWidget* widget, Kldapw* kldapw);
private:
  //Kldapw* kldapw;
  QLineEdit* txtName;
  QLineEdit* txtHost;
  QLineEdit* txtPort;
  QLineEdit* txtRootDN;
  QLineEdit* txtBindAs;
  QLineEdit* txtPassword;
  QListBox* listBox;
  QComboBox* cmbAuth;
  void writeValue(QTextStream* t, const char* value);
  void fillList();
  QString filename; // Filename (with Path) of the configuration file
public slots:
  void connect();
  void save();
  void loadConfiguration();
  void loadConfiguration(int index);
  void removeEntry();
  void removeEntry(int index);
};

//AttributeListPage is replaces by AttributeEditPage
/*
class AttributeListPage : public KldapPage
{
  Q_OBJECT
public:
  AttributeListPage(QWidget* widget, Kldapw* kldapw);
public slots:
  void displayValues(int);
  void addAttribute();
  void deleteAttribute();
  void addValue();
  void deleteValue();
private:
  //Kldapw* kldapw;
  //LDAP* ldap;
  //char* dn;
  QListBox* listBox;
  QListBox* valuesListBox;
  QLineEdit* txtNewAttribute;
  QLineEdit* txtNewValue;
  void fillList();
};
*/

class PageDialog : public QDialog
{
  Q_OBJECT
public:
  PageDialog(QWidget* parent);
  void addPage(KldapPage* page);
private:
  QGridLayout* layout;
};

class SearchDialog : public QDialog
{
  Q_OBJECT
public:
  Kldapw* kldapw;
  SearchDialog(QWidget* parent, Kldapw* kldapw);
public slots:
  void search();
  void edit();
  void itemSelectedSlot();
private:
  QLineEdit* txtQuery;
  QListView* listView;
  QPushButton* btnEdit;
};

class AttributeDialog : public QDialog
{
  Q_OBJECT
public:
  AttributeDialog(QWidget* parent, Kldapw* kldapw, int modifyType, char* dn, char* attributeName);
  QLineEdit* txtValue;
private:
  Kldapw* kldapw;
  int modifyType;
  char* dn;
  char* type;
  char* attributeName;
public slots:
  void modify();
};

class AttributeValueDialog : public QDialog
{
  Q_OBJECT
public:
  AttributeValueDialog(QWidget* parent, Kldapw* kldapw, int modifyType, char* dn, char* attributeName);
  QLineEdit* txtValue;
private:
  Kldapw* kldapw;
  int modifyType;
  char* dn;
  char* type;
  char* attributeName;
public slots:
  void valueTypeChanged(int);
  void modify();
};

class AttributeEditPage : public KldapPage
{
  Q_OBJECT
public:
  AttributeEditPage(QWidget*, Kldapw*, char* dn=NULL);
private:
  KTreeList* editTree;
  KIconLoader* loader;
  QPushButton* btnAdd;
  QPushButton* btnDel;
  QPushButton* btnModify;
  void fillList();
  void buildTree(char* attributeName, int itemIndex);
  void removeItems(int index);
  void switcher(int index);
  void addValue();
  void deleteValue();
public slots:
  void expandTree(int itemIndex);
  void selectedSlot(int itemIndex);
  void addAttribute();
  void deleteAttribute();
  void modifyValue();
  void highlightedItem(int);
};

class AddPage : public KldapPage
{
  Q_OBJECT
public:
  AddPage(QWidget* parent, Kldapw* kldapw);
  //Kldapw* kldapw;
  //char* dn;
  int parentIndex;
public slots:
  void add(); 
private: 
  QLineEdit* txtObjectClass;
  QLineEdit* txtFirstDNElement;
  QComboBox* cmbObjectClass;
  void fillList();
};

  
