  /*

  knat v 1.0.0

  Copyright (C) 2000 Luigi Genoni
  		     venom@DarkStar.sns.it
  */
  

#include <qlayout.h>
#include <qmultilinedit.h>
#include <qkeycode.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qstring.h>
#include <qstrlist.h>
#include <strings.h>

#include <kmsgbox.h>
#include <kiconloader.h>
#include <klocale.h>

#include "knat.h"

//#include "version.h"

// creating widgets
void knetfilter::setupknetfilterWidget() {

  QWidget *mainWidget = new QWidget(this);

  QBoxLayout *top = new QBoxLayout(mainWidget, QBoxLayout::LeftToRight, 10);
  QGridLayout *grid = new QGridLayout(10,10);
  top->addLayout(grid,10);

  QLabel *labelSourcePort = new QLabel(mainWidget);
  labelSourcePort->setText("Source Port:");

  addSourcePort = new QLineEdit(mainWidget);
  addSourcePort->setFixedHeight(addSourcePort->sizeHint().height());
  addSourcePort->setText("");

  QLabel *labelDestinationPort = new QLabel(mainWidget);
  labelDestinationPort->setText("Destination Port:");

  addDestinationPort = new QLineEdit(mainWidget);
  addDestinationPort->setFixedHeight(addDestinationPort->sizeHint().height());
  addDestinationPort->setText("");

  QLabel *labelIcmpType = new QLabel(mainWidget);
  labelIcmpType->setText("ICMP Type):");

  addIcmpType = new QLineEdit(mainWidget);
  addIcmpType->setFixedHeight(addIcmpType->sizeHint().height());
  addIcmpType->setText("");

  grid->addMultiCellWidget(labelSourcePort,0,0,0,1);
  grid->addMultiCellWidget(addSourcePort,0,0,2,3);

  grid->addMultiCellWidget(labelDestinationPort,1,1,0,1);
  grid->addMultiCellWidget(addDestinationPort,1,1,2,3);

  grid->addMultiCellWidget(labelIcmpType,2,2,0,1);
  grid->addMultiCellWidget(addIcmpType,2,2,2,3);

  QLabel *labelInterface = new QLabel(mainWidget);
  labelInterface->setText("Interface:");
  grid->addMultiCellWidget(labelInterface,4,4,0,1);

  interface = new QComboBox( FALSE, mainWidget, "interface");
  interface->insertItem("Please Select");
  interface->insertItem("eth");
  interface->insertItem("lo");
  interface->insertItem("slip");
  interface->insertItem("plip");
  interface->insertItem("ppp");
  interface->insertItem("ippp");
  interface->setFixedHeight(interface->sizeHint().height());
  connect(interface,SIGNAL(activated(int)), SLOT(interfaceActivated(int)));
  grid->addMultiCellWidget(interface,4,4,2,3);

  QLabel *labelInterfacenr = new QLabel(mainWidget);
  labelInterfacenr->setText("Interface nr:");
  grid->addMultiCellWidget(labelInterfacenr,5,5,0,1);

  interfacenr = new QComboBox( FALSE, mainWidget, "interface nr");
  interfacenr->insertItem("0");
  interfacenr->insertItem("1");
  interfacenr->insertItem("2");
  interfacenr->insertItem("3");
  interfacenr->insertItem("4");
  interfacenr->insertItem("5");
  interfacenr->setFixedHeight(interfacenr->sizeHint().height());
  connect(interfacenr,SIGNAL(activated(int)), SLOT(interfacenrActivated(int)));
  grid->addMultiCellWidget(interfacenr,5,5,2,3);

  QLabel *labelChain = new QLabel(mainWidget);
  labelChain->setText("Chain:");

  chain = new QComboBox( FALSE, mainWidget, "Chain");
  chain->insertItem("INPUT");
  chain->insertItem("OUTPUT");
  chain->insertItem("FORWARD");
  chain->setFixedHeight(chain->sizeHint().height());
  connect(chain,SIGNAL(activated(int)), SLOT(chainActivated(int)));

  grid->addMultiCellWidget(labelChain,0,0,5,6);
  grid->addMultiCellWidget(chain,0,0,6,7);

  QLabel *labelIp = 		new QLabel(mainWidget);
  QLabel *labelNetmask = 	new QLabel(mainWidget); 


  QLabel *labelPolicy = new QLabel(mainWidget);
  labelPolicy->setText("Policy:");

  policy = new QComboBox( FALSE, mainWidget, "Policy");
  policy->insertItem("DROP");
  policy->insertItem("REJECT");
  policy->insertItem("ACCEPT");
  policy->insertItem("RETURN");
  policy->insertItem("QUEUE");
  policy->setFixedHeight(policy->sizeHint().height());
  connect(policy,SIGNAL(activated(int)), SLOT(policyActivated(int)));

  grid->addMultiCellWidget(labelPolicy,1,1,5,6);
  grid->addMultiCellWidget(policy,1,1,6,7);

  QLabel *labelFlag = new QLabel(mainWidget);
  labelFlag->setText("tcp flags:");

  flags = new QComboBox( FALSE, mainWidget, "Flags");
  flags->insertItem(" ");
  flags->insertItem("SYN");
  flags->setFixedHeight(flags->sizeHint().height());
  connect(flags,SIGNAL(activated(int)), SLOT(flagsActivated(int)));

  grid->addMultiCellWidget(labelFlag,0,0,8,9);
  grid->addMultiCellWidget(flags,1,1,8,9);


  labelIp->setText("IP Adress:");
  labelNetmask->setText("Netmask:");

  ipAddr = 	new QLineEdit(mainWidget);
  netmaskAddr =	new QLineEdit(mainWidget);

  ipAddr->setFixedHeight(ipAddr->sizeHint().height());
  netmaskAddr->setFixedHeight(netmaskAddr->sizeHint().height());

  grid->addMultiCellWidget(labelIp,7,7,0,1);
  grid->addMultiCellWidget(labelNetmask,8,8,0,1);
  grid->addMultiCellWidget(ipAddr,7,7,2,3);
  grid->addMultiCellWidget(netmaskAddr,8,8,2,3);
  

    QLabel *labelextraNet = new QLabel(mainWidget);
    labelextraNet->setText("Extranet/Netmask:");

  extraNet  =  new QLineEdit(mainWidget);
  extraNetMask  =  new QLineEdit(mainWidget);

  extraNet->setFixedHeight(extraNet->sizeHint().height());
  extraNetMask->setFixedHeight(extraNetMask->sizeHint().height());

  grid->addMultiCellWidget(labelextraNet,9,9,0,1);
  grid->addMultiCellWidget(extraNet,9,9,2,3);
  grid->addMultiCellWidget(extraNetMask,9,9,4,5);
  
  
  messageLog = new QListBox(mainWidget);
  
  grid->addMultiCellWidget(messageLog,2,8,5,9);

  setView(mainWidget);

};


