#ifndef H_DEVICES
#define H_DEVICES

enum deviceTypes { DEVICE_NONE = 0, DEVICE_HD, DEVICE_FD, DEVICE_CDROM, 
			DEVICE_TAPE };
enum driverTypes { DRIVER_SCSI = 0, DRIVER_NET = 1, DRIVER_CDROM = 2,
		   DRIVER_PCMCIA = 3, DRIVER_FS = 4, 
		   DRIVER_PREREQ = 4, DRIVER_OTHER = 1000};
enum driverMinor { DRIVER_MINOR_NONE = 0, DRIVER_MINOR_ETHERNET,
		   DRIVER_MINOR_PLIP, DRIVER_MINOR_TR };

struct driver;

#define PERSIST_ALIAS	(1 << 0)
#define PERSIST_OPTIONS	(1 << 1)

struct deviceInfo {
    char * deviceName;
    char * info;
    int id;
    int bus;
    int type;
};

struct driversLoaded {
    struct driversLoaded * next;
    char ** argv;
    int argc;
    char * module;
    enum driverTypes type;
    enum driverMinor minor;
    int persistFlags;
} ;

typedef int (*driverOkayFn)(struct driver * dev);

const char * getModuleDescription(char * module);
int devMakeInode(char * name, char * path);
void devRemoveInode(char * path);

#define DEVICE_JUSTPROBE	(1 << 0)
#define DEVICE_NOPAUSE		(1 << 1)
#define DEVICE_NOPROBE		(1 << 2)

int loadDeviceDriver(enum driverTypes type, struct driversLoaded ** drlist,
		     int flags);
int removeDeviceDriver(enum driverTypes type, struct driversLoaded ** drlist);
int writeModuleConf(char * prefix, struct driversLoaded * dl, int append);
int readModuleConf(char * prefix, struct driversLoaded ** drlist);
int readModuleConfPersist(char * prefix, struct driversLoaded * drlist);
int loadModule(char * modName, enum driverTypes type, enum driverMinor minor,
	       struct driversLoaded ** drlist);
int removeModule(char * module);
int setupCDdevice(char ** cddev, struct driversLoaded ** dl);
int removeCDmodule(struct driversLoaded ** dl);
int loadFilesystem(char * modname, char * fsname, 
		   struct driversLoaded ** drlist);
int loadModuleDep(char * path);

/* returns a list of cd devices, NULL terminated */
char ** getCDnames(void);

/* hack -- plip is broken */
char * getPlipDeviceName(void);

#ifndef __sparc__
int findAtapi(char ** cddev);
#endif
int findSCSIcdrom(char ** cddev);

#endif
