/* ------------------------------------------------------------- 

    knghash.cpp (part of K News Grabber)

    (C) 1999 by Cengiz Tuztas

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Cengiz.Tuztas@uni-essen.de

    $Id: knghash.cpp,v 1.2 1999/05/19 20:45:04 ctuztas Exp $

   ------------------------------------------------------------- */

#include <knghash.h>


KNGHashEntry::KNGHashEntry()
{
  s = new QString();
  d = new QDate( QDate::currentDate() );
}

KNGHashEntry::KNGHashEntry( const char *str, const QDate *dt = 0)
{
  s = new QString( str );
  if ( ! dt )
    d = new QDate( QDate::currentDate() );
  else 
    d = new QDate( *dt );
}

KNGHashEntry::~KNGHashEntry()
{
  delete s;
  delete d;
}

void
KNGHashEntry::setDate( const QDate *dt )
{
  *d = *dt;
}

void
KNGHashEntry::setKey( const char *key )
{
  *s = key;
}

const QDate *
KNGHashEntry::date()
{
  return d;
}

const char *
KNGHashEntry::key()
{
  return *s;
}

KNGHash::KNGHash()
{
  KNGHash( false );
}

KNGHash::KNGHash( bool sm )
  :QDict( 1013 )
{
  s_mode = sm;
  QDir dir;
  QString lstr;
  setAutoDelete( true );

  if ( s_mode )
    {
      lstr = ( QDir::home() ).absPath();
      lstr.append( "/.kde" );
    }
  else 
    lstr = kapp->localkdedir();

  lstr.append( "/share/apps/kng" );
  dir.setPath( lstr );

  if ( ! dir.exists() )
    dir.mkdir( lstr );
  else
    {
      QFileInfo fi( dir, ".");
      if ( ! fi.isDir() )
	{
	  debug( "%s is not a directory", ( const char * ) lstr );
	  return;
	}
    }
  
  lstr.append( "/messages.db" );
  debug( "Checking for file %s", ( const char * ) lstr );

  file = new QFile( lstr );
  
  if ( file->exists() )
    readData();

}


KNGHash::~KNGHash()
{
  writeData();
  delete file;
}

void
KNGHash::writeData()
{
  uint ctr = count();
  if ( ! file->open( IO_WriteOnly ) )
    return;
  QDataStream ds( file );
  if ( count() )
    {
      ds << ctr << size();
      QDictIterator<KNGHashEntry> it ( *this );
      while ( it.current() )
	{
	  KNGHashEntry *hentry = it.current();
	  const QDate *dptr = hentry->date();
	  ds << hentry->key() << *dptr;
	  ++it;
	}
      file->close();
    }
  else 
    {
      file->remove();
    }
}

void
KNGHash::readData()
{
  uint ctr, ctr2;
  QString str;
  QDate cdate(QDate::currentDate() );
  QDate ldate;

  // This is probably not correct, but I will do it so for now
  clear();


  if ( ! file->open( IO_ReadOnly ) )
    return;

  QDataStream ds ( file );
  ds >> ctr >> ctr2;

  if ( ( ( ctr2 / 2 ) <= ctr ) && ( ctr2 > size() )  )
    {
      // Dictionary is 1/2+ full and Size of saved Dictionary > of current
      resize( ctr2 * 1.3 );
    }

  for ( uint i = 0; i < ctr; i++ )
    {
      KNGHashEntry *hentry;
      if ( ds.eof() )
	return;

      ds >> str >> ldate;
      if ( ldate.daysTo( cdate ) <= 7 )
	{
	  // This message is not older than 7 days
	  hentry = new KNGHashEntry( str, &ldate );
	  insert( str, hentry );
	}
      else
       {
       debug( "MessageID %s is from %s",
       	( const char * ) str, ( const char * ) ldate.toString() );
       }
    }
  file->close();
}

void
KNGHash::deletehashFile()
{
  if ( file->remove() )
    {
      clear();
      debug ( "File removed" );
    }
  else
    {
      clear();
      debug ( "File could not be removed" );
    }
  
}
