/***************************************************************************
                     knexpire.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "utilities.h"
#include "knexpire.h"
#include "knglobals.h"

KNExpire::KNExpire()
{
	KConfig *c=CONF();
	
	c->setGroup("EXPIRE");
	
	rDays=c->readNumEntry("readDays", 10);
	uDays=c->readNumEntry("unreadDays", 15);
	saveThr=c->readBoolEntry("saveThreads", true);
	
	expCount=0;
	leftCount=0;	
	
}



KNExpire::~KNExpire()
{
}



void KNExpire::doExpire(KNGroupEntry *en, bool withGui=false)
{
	KNReadHeaderList &hList=en->hList;
	expCount=0;	

	int expDays, idRef, foundId;	
	KNReadHeader *ref;			
		
	if(!en->loadHdrs()) return;
				
	//find all expired
		
	for(uint i=0; i<hList.length(); i++) {
					
		if(hList[i]->isRead()) expDays=rDays;
		else expDays=uDays;
		
		hList[i]->setExpired((hList[i]->age >= expDays));
			
	}
		
			
	//save threads
	if(saveThr) {
			
		for(uint i=0; i<hList.length(); i++) {
			
			if(!hList[i]->isExpired()) {
				idRef=hList[i]->idRef;
									
				while(idRef!=0) {
					ref=hList.byID(idRef);
					ref->setExpired(false);
					idRef=ref->idRef;
				}
			}
		}
	}				
					
		
	//restore threading		
	for(uint i=0; i<hList.length(); i++) {
			
		if(!hList[i]->isExpired()) {
				
			idRef=hList[i]->idRef, foundId=0;
							
			while(foundId==0 && idRef!=0) {
				ref=hList.byID(idRef);
				if(!ref->isExpired()) foundId=ref->id;
				idRef=ref->idRef;
			}
			hList[i]->idRef=foundId;
		}
	}
							
					
	for(uint i=0; i<hList.length(); i++)
		if(hList[i]->isExpired()) {
			hList[i]->clearData();
			if(hList[i]->isRead()) en->mRead--;
			expCount++;
		}
		
	if(expCount>0) {
		en->saveStaticData(hList.length(), true);
		en->saveDynamicData(hList.length(), true);
		en->mCount-=expCount;
		en->mNewCnt=0;
		en->clearHdrList();
	}
	else en->syncDynamicData();
	
	en->saveInfo();
	
	
	leftCount=en->mCount;
	
	if(withGui) {
			
		QString tmp;
		tmp.sprintf("%s\nexpired:\t%d\nleft:\t%d", en->name().data(), expCount, leftCount);
		MBox(inf,tmp);
				
	}	
		
}



