/***************************************************************************
                     kngroupselectdialog.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kngroupselectdialog.h"
#include <qlayout.h>
#include <qlabel.h>
#include "knglobals.h"

KNGroupSelectDialog::KNGroupSelectDialog(QWidget *parent=0, const char *name=0,
	QStrList *groups=0) : QDialog(parent,name,true)
{
	QLabel *lab1=new QLabel(i18n("all groups"), this);
	QLabel *lab2=new QLabel(i18n("selected groups"), this);
	lab1->setAlignment(AlignCenter);
	lab2->setAlignment(AlignCenter);
	lab1->setFrameStyle(QFrame::Panel | QFrame ::Sunken);
	lab2->setFrameStyle(QFrame::Panel | QFrame ::Sunken);
	lab1->setMinimumSize(lab1->sizeHint());
	lab2->setMinimumSize(lab2->sizeHint());
	
	
	glw=new KNGroupListWidget(this, 0, xTop->gManager()->activeList());
	glw->setMinimumSize(glw->sizeHint());
	
	add=new QPushButton("",this);
	add->setPixmap(ICON("arrow_right.xpm"));
	add->setFixedSize(50,35);
	
	
	del=new QPushButton("",this);
	del->setPixmap(ICON("arrow_left.xpm"));
	del->setFixedSize(50,35);
	
	lb=new QListBox(this);
	lb->setMinimumSize(glw->sizeHint());
	
	ok=new QPushButton(i18n("OK"), this);
	ok->setMinimumSize(ok->sizeHint());
	cancel=new QPushButton(i18n("Cancel"), this);
	cancel->setMinimumSize(cancel->sizeHint());
	//help=new QPushButton(i18n("Help"), this);
	//help->setMinimumSize(help->sizeHint());
			
	QGridLayout *topLayout=new QGridLayout(this, 3,3,10);
	QVBoxLayout *btnLayout=new QVBoxLayout(10);
	QHBoxLayout *btn2Layout=new QHBoxLayout(10);
		
	
	topLayout->addWidget(lab1,0,0);
	topLayout->addWidget(lab2,0,2);
	topLayout->addWidget(glw,1,0);
	
	topLayout->addLayout(btnLayout,1,1);
	btnLayout->addStretch(1);
	btnLayout->addWidget(add);
	btnLayout->addStretch(1);
	btnLayout->addWidget(del);
	btnLayout->addStretch(1);
	
	topLayout->addWidget(lb,1,2);
	topLayout->addLayout(btn2Layout, 2,2);
	
	//topLayout->addWidget(help, 2,0);
		
	btn2Layout->addStretch(1);
	btn2Layout->addWidget(ok);
	btn2Layout->addWidget(cancel);

	topLayout->setColStretch(0,1);
	topLayout->setColStretch(2,1);
	topLayout->setRowStretch(1,1);
	topLayout->addColSpacing(1,80);
		
	topLayout->activate();
	
	connect(glw, SIGNAL(itemSelected(const char*)),
		this, SLOT(slotAdd(const char*)));
		
	connect(add, SIGNAL(clicked()), this, SLOT(slotAddBtn()));
	connect(del, SIGNAL(clicked()), this, SLOT(slotRemoveBtn()));
	connect(lb, SIGNAL(selected(int)), this, SLOT(slotRemove(int)));
	
	connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
	connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));
	
	selGroups=groups;
	if(!groups->isEmpty()) lb->insertStrList(groups);
	
	setCaption(i18n("select newsgroups"));
	
		
}



KNGroupSelectDialog::~KNGroupSelectDialog()
{
}


void KNGroupSelectDialog::addToSelected(const char *text)
{
	bool inList=false;
	for(uint idx=0; idx<lb->count(); idx++)
		if(strcmp(lb->text(idx),text)==0) inList=true;
	if(!inList) lb->insertItem(text);
}



void KNGroupSelectDialog::slotAddBtn()
{
	if(glw->currentText()) addToSelected(glw->currentText());
}


				
void KNGroupSelectDialog::slotRemoveBtn()
{
	if(lb->currentItem()>-1) lb->removeItem(lb->currentItem());
}


			
void KNGroupSelectDialog::slotAdd(const char *text)
{
	addToSelected(text);
}



void KNGroupSelectDialog::slotRemove(int i)
{
	lb->removeItem(i);
}



void KNGroupSelectDialog::applyResult()
{
	selGroups->clear();
	for(uint i=0; i<lb->count(); i++) selGroups->append(lb->text(i));
}

		





















