/***************************************************************************
                     knheaderbase.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <mimelib/datetime.h>
#include <stdio.h>
#include "knheaderbase.h"
#include "knhdrviewitem.h"

KNHeaderBase::KNHeaderBase()
{
	time=0; id=-1; lines=0; item=0;
}



KNHeaderBase::~KNHeaderBase()
{
	delete item;
}



QString& KNHeaderBase::tString()
{
	char string[21];
	
	if(timeString.isNull()) {
		DwDateTime dt, curr;
	  dt.FromUnixTime(time);
		if(curr.Year()!=dt.Year())
			sprintf(string,"%.2d.%.2d.%d (%.2d:%.2d)",dt.Day(),dt.Month(), dt.Year(),
				dt.Hour(),dt.Minute());
		else
			sprintf(string,"%.2d.%.2d. (%.2d:%.2d)",dt.Day(),dt.Month(),
				dt.Hour(),dt.Minute());
		
		timeString=string;}
			
	return timeString;	
}



void KNHeaderBase::clearData()
{
	email.resize(0);
	replyTo.resize(0);
	from.resize(0);
	subject.resize(0);
	timeString.resize(0);
}



void KNHeaderBase::setItem(KNHdrViewItem *it)	
{	
	it->entry=this;
	item=it;
}





