/***************************************************************************
                     knlvitembase.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNLVITEMBASE_H
#define KNLVITEMBASE_H

#include <qlistview.h>


class KNLVItemBase : public QListViewItem  {
	
	public:
		
		KNLVItemBase(QListView *view);
		KNLVItemBase(QListViewItem *item);
		~KNLVItemBase();
		
		void paintCell(QPainter *p, const QColorGroup &cg, int column, int width, int alignment);
		void paintFocus(QPainter * p, const QColorGroup & cg, const QRect & r) {}
		int width(const QFontMetrics &fm, const QListView *lv, int column);
		
		bool greyOut()									{ return mGreyOut; }
		void setGreyOut(bool g)					{ mGreyOut=g; }
				
		bool firstColBold()							{ return mFirstColBold; }
		void setFirstColBold(bool b) 		{ mFirstColBold=b; }
		
		
	
	private:
		bool mFirstColBold, mGreyOut;
	
		
};

#endif









