/***************************************************************************
                     knmessagecomp.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNMESSAGECOMP_H
#define KNMESSAGECOMP_H

#include <qwidget.h>
#include <ktoolbar.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <keditcl.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <kstatusbar.h>
#include <qstring.h>

#include "knsendmessage.h"

class KNPostHeader;

class KNMessageComp : public QWidget  {
   	
   	Q_OBJECT
	
	public:
		
		KNMessageComp(KNPostHeader *h);
		~KNMessageComp();
	
	  enum Action {send_now,send_later,save,del,unknown};
	
	  Action getResult() 						{ return result;}
	 	bool hasValidData();
	  bool hasText() 								{ return (!edit->text().isEmpty()); }
	  KNPostHeader* header()				{ return hdr; }
	
	  void setData();
		
	protected:
		void resizeEvent(QResizeEvent *);
		void updateRects();
		void closeEvent(QCloseEvent *e);
	
		void init();
		QLabel* initLabel(const char *text);
		void updateGroups();
		void appendSig();		
		
		KToolBar *tb;
		
		QPopupMenu *popUp;
		KStatusBar *sb;
		
		QFrame *inpFrame;
		QLineEdit *subj;
		QLineEdit *groups;
		QComboBox *fup;
		QLabel *subjL, *groupsL, *fupL;
		KEdit *edit;
		QPushButton *groupsBtn;
		QCheckBox *enableFup;
		Action result;
		QStrList *groupList;
		
		int sigPos;
		KNPostHeader *hdr;
		
		
	protected slots:
		void slotGroupsBtn();
		void slotTBCallback(int _id);
		void slotSubjectChanged(const char *t);
			
				
	signals:
		void composerDone(KNMessageComp*);
};


#define BTN_SEND_NOW	10001
#define BTN_SEND_LAT	10002
#define BTN_SAVE			10003
#define BTN_SIG				10004
#define BTN_DEL				10005


#endif














































