/***************************************************************************
                     knntpclient.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNNTPCLIENT_H
#define KNNTPCLIENT_H

#include <mimelib/mimepp.h>
#include <qstrlist.h>
#include <qstring.h>
#include <qtimer.h>

class NNTP;  //needed for deklaration of KNntpObserver

class KNntpObserver : public DwObserver {

	public :
		KNntpObserver(NNTP *);
		virtual ~KNntpObserver();
		void Notify();
		void clearBuffer() { receivedBuffer->clear(); }
		QStrList *buffer() { return receivedBuffer; }
		
	private :
 		NNTP *client;
		QStrList *receivedBuffer;
};





class NNTP :  public QObject, public  DwNntpClient  {

	Q_OBJECT
		
	friend class KNntpObserver;   // TextResponse() is protected

	public:
		
		NNTP();
		~NNTP();
	
	  void setServer(char *s ,int p)	{ server=s; port=p; }
	  void readConfig();	
		
	  bool cmdConnect(bool setGroup=true);	
	  bool cmdGroup(const char * groupname);
		QStrList* cmdList();

    QStrList* cmdArticle(const char *mID);
    QStrList* cmdArticle(const uint artNr);

    QStrList* cmdXOver(int from, int to);
    bool sendMsg(DwString &msg);

    const uint firstArtNum()	{ return first; }
    const uint lastArtNum()  	{ return last; }
    bool isConnected() 				{ return bConnected; }

    const char* serverResponse();

 	public slots:
   	bool cmdDisconnect();
		
	private:
				
		uint first, last;		
		KNntpObserver 	*observer;
		QString server, user, pass;
		int port, timeout;
		bool	bConnected;
   	QTimer *timer;
		
   	bool logon();
		int sendCommand(const char *cmd);


	signals:
		void connected(bool);
		//void nntpError(const char *);
		
          		
};

#endif
























