/***************************************************************************
                     knodeview.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNODEVIEW_H 
#define KNODEVIEW_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 



#include <kapp.h>
#include <knewpanner.h>

#include "knmsgview.h"
#include "knentrybase.h"
#include "knheaderbase.h"
#include "knlistview.h"


class KNodeView : public KNewPanner
{
  Q_OBJECT

 	friend class KNodeApp;
 	
 	public:
 		 	
 		KNodeView(KApplication* a=0, QWidget *parent = 0);
 		~KNodeView();
  	 		
 		int sepPos(int s);
 		void setSepPos(int s, int p);
 		
 		void headersSize(QStrList *lst);
 		void setHeadersSize(QStrList *lst);
 		 		
 		void setEntryMenu(QPopupMenu *p) 	{ entryMenu=p; }
 		void setHdrMenu(QPopupMenu *p) 		{ hdrMenu=p; }	

 		void nextHdr();
 		void prevHdr();
 		void nextUnreadHdr();
 		void nextUnreadThread();
 		

  protected:
 		void initEntryView();
    void initHdrView();
 		
 		KNewPanner *PanHorz;
 	 	KNMsgView *msgView;
 	 	KNListView *hdrView;
   	KNListView *entryView;

    QPopupMenu *entryMenu, *hdrMenu;



  protected slots:
  	void slotEMenu(QListViewItem *it, const QPoint &p, int c);
  	void slotHMenu(QListViewItem *it, const QPoint &p, int c);

};

#endif // KNODEVIEW_H 





























































