/***************************************************************************
                     knoptionsdialog.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knoptionsdialog.h"
#include "utilities.h"
#include <qlayout.h>
#include <kapp.h>





KNOptionsDialog::KNOptionsDialog(QWidget *parent, const char *name ) :
	QDialog(parent,name, true)
{
	
	bServer=true;
	bRead=false;
	bPost=false;
	bFntCol=false;
	
	
	tabs=new KTabCtl(this);
			
	mServer=new KNServerOptions(tabs);
	mRead=new KNReadOptions(tabs);
	mPost=new KNPostOptions(tabs);
	mFntCol=new KNFntColOptions(tabs);
	
	SIZE(mServer); SIZE(mRead); SIZE(mPost); SIZE(mFntCol);
	
	tabs->addTab(mServer, i18n("Server"));
	tabs->addTab(mRead, i18n("read news"));
	tabs->addTab(mPost, i18n("post news"));
	tabs->addTab(mFntCol, i18n("fonts && colors"));
	
	
	ok=new QPushButton(i18n("OK"), this);
	/*ok=new QToolButton(this);
	ok->setIconSet(QIconSet(ICON("delete.xpm"), QIconSet::Large));
	ok->setTextLabel("Test");
	ok->setUsesTextLabel(true); */
	
	cancel=new QPushButton(i18n("Cancel"), this);
	help=new QPushButton(i18n("Help"), this);
	help->setEnabled(false);
	
	QVBoxLayout *topL=new QVBoxLayout(this, 10);
	QHBoxLayout *btnL=new QHBoxLayout(10);
	
	topL->addWidget(tabs, 1);
	topL->addLayout(btnL, 0);
	
	btnL->addWidget(help);
	
	btnL->addStretch(1);
	btnL->addWidget(ok);
	btnL->addWidget(cancel);
	
	SIZE(help); SIZE(ok); SIZE(cancel);
	
	topL->activate();
	
	connect(ok ,SIGNAL(clicked()), this, SLOT(accept()));
	connect(cancel ,SIGNAL(clicked()), this, SLOT(reject()));
	
	connect(tabs, SIGNAL(tabSelected(int)), this, SLOT(slotTabSelected(int)));
	
	setCaption(i18n("Preferences"));
	
}



KNOptionsDialog::~KNOptionsDialog()
{
}



void KNOptionsDialog::slotTabSelected(int id)
{
	switch(id) {
		
		case 0: bServer=true; break;
		case 1: bRead=true; break;
		case 2: bPost=true; break;
		case 3: bFntCol=true; break;
	}
}







