/***************************************************************************
                          knthread.h  -  description
                             -------------------
    
    copyright            : (C) 1999 by Christian Thurner
    email                : cthurner@freepage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KNTHREAD_H
#define KNTHREAD_H

#include <qlist.h>
#include "knreadheader.h"
#include "knreadheaderlist.h"


class KNThread {
	
	public:
		KNThread();
		KNThread(KNReadHeaderList *l, KNReadHeader *h);
		~KNThread();
	
		void setSource(KNReadHeaderList *l)		{ src=l; }
		void createThreadOf(KNReadHeader *h);
		
		int count()														{ return hdrs->count(); }
		
		void add(KNReadHeader *h)							{ hdrs->append(h); }
		bool remove(KNReadHeader *h)					{ return hdrs->remove(h); }
		
		int setRead(bool r, int &newCnt);
		void setScore(short s);
		void kill() {}
		
		
  protected:
  	
  	QList<KNReadHeader> *hdrs;
  	KNReadHeaderList *src;
	

};

#endif




