//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// This file os part of KRN, a newsreader for the KDE project.              //
// KRN is distributed under the GNU General Public License.                 //
// Read the acompanying file COPYING for more info.                         //
//                                                                          //
// KRN wouldn't be possible without these libraries, whose authors have     //
// made free to use on non-commercial software:                             //
//                                                                          //
// MIME++ by Doug Sauder                                                    //
// Qt     by Troll Tech                                                     //
//                                                                          //
// This file is copyright 1997 by                                           //
// Roberto Alsina <ralsina@unl.edu.ar>                                      //
// Magnus Reftel  <d96reftl@dtek.chalmers.se>                               //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include <stdlib.h>
#include <unistd.h>

#include "NNTP.h"

#include <kmsgbox.h>
#include <kconfig.h>
#include <kapp.h>

#include <qlist.h>
#include <qfile.h>
#include <qtstream.h>
#include <qapp.h>
#include <qregexp.h>
#include <qdict.h>

#include <kalarmtimer.h>

extern QString krnpath,cachepath,artinfopath;

#include <mimelib/mimepp.h>

char debugbuf[1024];

#include "kfileio.h"
#include "article.h"
extern dbDatabase db;
extern dbCursor <Article> cursor;

#include "TooManydlg.h"
TooManyDlg *toomanydlg=0;



extern KConfig *conf;
extern QDict <NewsGroup> groupDict;

void QStringSplit (const QString &data,char sep,QStrList &splitted);

#define NNTP_PORT 119
#define RECV_BUFFER_SIZE  8192
#define SEND_BUFFER_SIZE  1024


/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
//  NNTP class. Implements the NNTP protocol (I hope)
//
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////


NNTP::NNTP(char *host): DwNntpClient()
{
    if (host)
        hostname=host;
    else
        hostname="";
    Connected=false;
    Readonly=false;
    reportBytes=false;
    reportCommands=false;
    byteCounter=0;
    commandCounter=0;
}

void NNTP::PGetTextResponse()
{
    mTextResponse = "";

    // Get a line at a time until we get CR LF . CR LF

    while (1) {
        char* ptr=0;
        int len;
        int err = PGetLine(&ptr, &len);

        // Check for an error

        if (err) {
            mReplyCode = 0;
            return;
        }
        if (!ptr) {
            mReplyCode = 0;
            return;
        }

        // Check for '.' on a line by itself, which indicates end of multiline
        // response

        if (len >= 3 && ptr[0] == '.' && ptr[1] == '\r' && ptr[2] == '\n')
        {
            break;
        }

        // Remove '.' at beginning of line

        if (*ptr == '.') ++ptr;

        mTextResponse.append(ptr, len);
        byteCounter=mTextResponse.length();
        qApp->processEvents();

        //        debug ("reportBytes = %d, oldbytes %ld, byteCounter %ld",
        //               reportBytes,oldbytes,byteCounter);
        if (reportBytes && (byteCounter - oldbytes)>512 )
        {
            //            debug ("reporting");
            char *buffer=new char[100];
            sprintf (buffer,klocale->translate("Received %.2f Kb"),
                     ((double)byteCounter)/1024);
            emit newStatus(buffer);
            qApp->processEvents();
            delete[] buffer;
            oldbytes=byteCounter;
        }
    }
}

void NNTP::resetCounters( bool byte,bool command)
{
    if (byte)
        byteCounter=0;
    if (command)
        commandCounter=0;
}
void NNTP::reportCounters (bool byte,bool command)
{
    reportBytes=byte;
    reportCommands=command;
}


NNTP::~NNTP()
{
}
bool NNTP::connect()
{

    //There are a lot of "Connected=false" which are not needed. That is
    //intentional.

    if (Connected)
        return true;
    int status;
    conf->setGroup("NNTP");
    hostname=conf->readEntry("NNTPServer");

    if (!hostname) // no server in the env, nowhere to connect
    {
        Connected=false;
        return false;
    }
    else
    {
        KDEBUG (KDEBUG_INFO,3300,"Connecting to ...")
            KDEBUG (KDEBUG_INFO,3300,hostname.data());
        status=Open(hostname.data());
    }
    if (status!=200 && status!=201)
    {
        Connected=false;
        return false;
    }
    if (status==201)
        Readonly=true;
    if (!status)
    {
        Connected=false;
        return false;
    }

    //this is needed sometimes for some versions of INN
    status=setMode("reader");
    if (!status)
    {
        Connected=false;
        return false;
    }

    status=listOverview();
    if (!status)
    {
        Connected=false;
        return false;
    }

    Connected=true;
    return true;
}
bool NNTP::disconnect()
{
    int status=Quit();
    debug ("Quit -> %d",status);
    status=Close();
    debug ("Close -> %d",status);
    Connected=false;
    return true;
}

int NNTP::authinfo(const char *username,const char *password)
{
    if (username)
    {
        sprintf (mSendBuffer,"authinfo user %s\r\n",username);
        cout << "C: " << mSendBuffer << endl;

        mReplyCode = -1;
        int bufferLen = strlen(mSendBuffer);
        int numSent = PSend(mSendBuffer, bufferLen);
        if (numSent == bufferLen)
        {
            PGetStatusResponse();
            cout <<"S: " << StatusResponse() << endl;
        }
    }
    if (password)
    {
        sprintf (mSendBuffer,"authinfo pass %s\r\n",password);

        // This prints the password. Not really a smart thing :-)
        // cout << "C: " << mSendBuffer << endl;

        mReplyCode = -1;
        int bufferLen = strlen(mSendBuffer);
        int numSent = PSend(mSendBuffer, bufferLen);
        if (numSent == bufferLen)
        {
            PGetStatusResponse();
            cout <<"S: " << StatusResponse() << endl;
        }
    }
    return mReplyCode;
}

int NNTP::listOverview()
{
    strcpy(mSendBuffer, "LIST overview.fmt\r\n");

    // for debugging
    cout << "C: " << mSendBuffer << endl;

    mReplyCode = -1;
    int bufferLen = strlen(mSendBuffer);
    int numSent = PSend(mSendBuffer, bufferLen);
    if (numSent == bufferLen) {
        PGetStatusResponse();
        cout <<"S: " << StatusResponse() << endl;
        if (mReplyCode/100%10 == 2)
        {
            PGetTextResponse();
            QString of=TextResponse().data();
            int index;

            index=of.find ("Subject");
            if (index!=-1)
                OffsetSubject=of.left(index).contains('\n')+1;
            else
                OffsetSubject=0;

            index=of.find ("From");
            if (index!=-1)
                OffsetFrom=of.left(index).contains('\n')+1;
            else
                OffsetFrom=0;

            index=of.find ("Lines");
            if (index!=-1)
                OffsetLines=of.left(index).contains('\n')+1;
            else
                OffsetLines=0;

            index=of.find ("Message-ID");
            if (index!=-1)
                OffsetID=of.left(index).contains('\n')+1;
            else
                OffsetID=0;

            index=of.find ("Date");
            if (index!=-1)
                OffsetDate=of.left(index).contains('\n')+1;
            else
                OffsetDate=0;

            index=of.find ("References");
            if (index!=-1)
                OffsetRef=of.left(index).contains('\n')+1;
            else
                OffsetRef=0;
        }
        else
        {
            OffsetSubject=1;
            OffsetFrom=2;
            OffsetDate=3;
            OffsetID=4;
            OffsetRef=5;
            OffsetLines=7;
        }
        sprintf (debugbuf,"Offsets:%d,%d,%d,%d,%d,%d",OffsetSubject,OffsetFrom,OffsetLines,OffsetID,OffsetDate,OffsetRef);
        KDEBUG(KDEBUG_INFO,3300,debugbuf);
    }
    return mReplyCode;
}


int NNTP::setMode (char *mode)
{
    sprintf (mSendBuffer,"mode %s\r\n",mode);
    cout << "C: " << mSendBuffer << endl;

    mReplyCode = -1;
    int bufferLen = strlen(mSendBuffer);
    int numSent = PSend(mSendBuffer, bufferLen);
    if (numSent == bufferLen)
    {
        PGetStatusResponse();
        cout <<"S: " << StatusResponse() << endl;
    }
    return mReplyCode;
}

int NNTP::listXover(int from,int to,NewsGroup *n)
{
    char *buffer=new char[1024];
    unsigned int counter=0;
    counter=n->artList.count();
    DwString gi;
    reportCounters (true,false);
    setGroup(n->name);
    debug ("first-->%d,last-->%d,from-->%d,to-->%d",first,last,from,to);
    if (from <first)
        from=first;
    if (to > last)
        to=last;
    if (to<from)
    {
        debug ("weird xover with to <from");
        to=from;
    }

    conf->setGroup("NNTP");
    int toomany=conf->readNumEntry("TooMany");
    if ((to-from)>toomany)
    {
        debug ("Way too many!");
        if (!toomanydlg)
        {
            toomanydlg=new TooManyDlg ();
        }
        toomanydlg->setTooMany(to-from);
        toomanydlg->exec();

        if (toomanydlg->frombottom)
        {
            from=(n->lastArticle(*this)>?first);
            to=from+toomanydlg->howmany;
        }
        else
        {
            to=last;
            from=to-toomanydlg->howmany;
        }
    }

    int reallast=from-1;

    if (to)
        sprintf(mSendBuffer, "xover %d-%d\r\n",from,to);
    else
        sprintf(mSendBuffer, "xover %d-\r\n",from);

    // for debugging
    cout << "C: " << mSendBuffer << endl;

    mReplyCode = 0;
    mStatusResponse = mTextResponse = "";

    int bufferLen = strlen(mSendBuffer);
    int numSent = PSend(mSendBuffer, bufferLen);
    if (numSent == bufferLen)
    {
        PGetStatusResponse();
        cout <<"S: " << StatusResponse() << endl;
        if (mReplyCode/100%10 == 2)
        {
            PGetTextResponse();
            debug ("resp length = %d",mTextResponse.length());


            //FIXME this should be a static method of something
            debug ("getting or creating reference to group");
            dbReference <class group> groupRef;
            dbCursor <class group> groupCursor (dbCursorForUpdate);
            dbQuery q1;
            q1="name = ",GroupName.data();
            if (groupCursor.select(q1)) //This group does exist
            {
                debug ("using existent reference");
                groupRef=groupCursor.currentId();
            }
            else
            {
                debug ("inserting and using reference to new entry");
                class group groupitem;
                groupitem.name=GroupName.data();
                groupRef=insert (groupitem);
            }

            QString qit;
            //First break it up in an article list

            QString xoverdata(mTextResponse.c_str());
            int index=0;
            int oldindex=0;
            DwDateTime date;
            dbQuery q;
            while (1)
            {
                class Article art;
                index=xoverdata.find('\n',oldindex);
                if (index==-1)
                    break;
                QString line=xoverdata.mid (oldindex,index-oldindex);
                oldindex=index+1;
                if (line.isEmpty())
                    continue;
                QStrList templ;
                templ.setAutoDelete (true);

                QStringSplit (line,'\t',templ);

                reallast=QString (templ.at(0)).toInt();

                q="ID = ",templ.at(OffsetID);
                if (! (cursor.select(q))) //Article doesn'talready exists
                {
                    art.ID=qstrdup(templ.at(OffsetID));

                    art.Subject=qstrdup(templ.at(OffsetSubject));
                    art.From=qstrdup(templ.at(OffsetFrom));

                    date.FromString(DwString(templ.at(OffsetDate)));
                    date.Parse();
                    art.Date=dbDateTime((time_t)date.AsUnixTime());
                    if (art.Date.stamp==-1)
                        debug ("Invalid date!");

                    art.Lines=atoi(templ.at(OffsetLines));

                    QString t;
                    t.sprintf ("%s@%s",group(),templ.at(0));
                    art.desperate=qstrdup(t.data());
                    art.Ref=qstrdup(templ.at(OffsetRef));

                    art.groups.append(groupRef);
                    art.save(false);
                }
                else //Just add a reference to the article in the article
                {
                    dbCursor <class group> *gcursor=new dbCursor <class group>;
                    bool repeated=false;
                    int l=cursor->groups.length();
                    for (int i=0;i<l;i++)
                    {
                        gcursor->at(cursor->groups[i]);
                        //if this group is in this
                        //article already
                        if (!strcmp((*gcursor)->name,name()))
                        {
                            repeated=true;
                            break;
                        }
                    }
                    if (!repeated)
                    {
                        cursor->groups.append(groupRef);
                        cursor.update();
                    }
                }

                counter++;
                //Write the article ID to the newsgroup file
                gi+=templ.at(OffsetID);
                gi+="\n";
                if (!(counter%10))
                    sprintf (buffer,"Parsed %d articles from Xover",counter);
                emit newStatus(buffer);
                mTextResponse.clear();
            }
            db.commit();
            n->saveLastArticle(*this,reallast);
        }
        else
        {
            warning ("Can't get XOVER data from your server");
            warning ("Server said %s",StatusResponse().data());
        }
    }
    delete[] buffer;
    resetCounters (true,true);
    return mReplyCode;
}

void QStringSplit (const QString &data,char sep,QStrList &splitted);



void NNTP::groupList(bool fromserver)
{
    QString ac;
    ac=krnpath+"/active";

    if (fromserver)
    {
        reportCounters (true,false);
        debug ("Getting LIST");
        int status=List();
        if (!status)
        {
            debug ("Connection failed when asking for LIST");
            emit lostServer();
            return;
        }
        else if (status!=215)
        {
            sprintf (debugbuf,"error getting group list\nServer said %s\n",
                     StatusResponse().c_str());
            KMsgBox::message (NULL,i18n(debugbuf));
            resetCounters (true,true);
            return;
        };
        TextResponse();
        if (!mTextResponse.length())
        {
            debug ("Connection failed while asking for LIST contents");
            emit lostServer();
            return;
        }

        QString tstr;
        if (QFile::exists(ac.data()))
            tstr=kFileToString(ac.data());
        tstr+=mTextResponse.c_str();
        if(kStringToFile(tstr,ac.data(),false,true))
        {
            QString command="cat ";
            command=command+ac+"| cut -d\" \" -f1 |sort|uniq >"+ac+"1; mv "+ac+"1 "+ac;
            system (command.data());
        }
        mTextResponse.clear();
        groupList(false);
    }
    else //read it from the active file
    {
        groupDict.clear();
        QStrList groupnames;
        QString data;
        data=kFileToString (ac);
        QStringSplit (data,'\n',groupnames);
        QStrListIterator it(groupnames);

        for (;it.current();++it)
        {
            char *s=it.current();
            NewsGroup *gr=new NewsGroup(s);
            groupDict.insert(s,gr);
        }
    };
    resetCounters (true,true);
}

bool NNTP::setGroup(const char *groupname)
{
    bool success=false;
    GroupName=groupname;

    int status=Group(GroupName.data());
    if (!status)
    {
        emit lostServer();
        return false;
    }

    if (status!=211)
    {
        sprintf (debugbuf,"can't change group!\nserver said: %s\n",
                 StatusResponse().data());
        KDEBUG(KDEBUG_ERROR,3300,debugbuf);
        GroupName="";
    }
    else
    {
        int j;
        QString l=StatusResponse().data();
        j=l.find(' ');
        l=l.right(l.length()-j-1);
        j=l.find(' ');
        howmany=l.left(j).toInt();
        l=l.right(l.length()-j-1);

        j=l.find(' ');
        first=l.left(j).toInt();
        l=l.right(l.length()-j-1);

        j=l.find(' ');
        last=l.left(j).toInt();
        success=true;
    }
    return success;
}



bool NNTP::artList(int from,int to,NewsGroup *n)
{
    int status=listXover(from,to,n);
    if (!status)
    {
        emit lostServer();
        return false;
    }
    return (status>199);
}

MessageParts NNTP::isCached (const char *_id)
{
    QString id=saneID(_id);
    int result=0;
    QString path=cachepath+"/"+id;
    if (QFile::exists(path.data()))
        result=result|PART_ALL;
    path=cachepath+"/"+id+".head";
    if (QFile::exists(path.data()))
        result=result|PART_HEAD;
    path=cachepath+"/"+id+".body";
    if (QFile::exists(path.data()))
        result=result|PART_BODY;
    return (MessageParts)result;
}

void NNTP::article(const char *_id, QString &data)
{
    data="";
    emit newStatus(klocale->translate("Getting Article"));
    QString id=saneID(_id);
    QString p=cachepath;
    p=p+id;
    if (isCached (id) == PART_ALL)//it exists and is fully cached
    {
        debug ("has all, getting nothing");
        if (QFile::exists(p)) //old style cache
            data=kFileToString(p);
        else
        {
            data=kFileToString(p+".head");
            data.append("\n\n");
            data.append(kFileToString(p+".body"));
        }
        return;
    }

    else if (isCached (id)==PART_NONE) //get all of it, write it and return it
    {
        debug ("has nothing, getting all");
        bool success=false;
        int status=Article (id);

        if (!status)
        {
            emit lostServer();
            return;
        }

        debug ("1status-->%d",status);
        if (status==220)
        {
            QString a(TextResponse().c_str());
            int limit=a.find("\r\n\r\n");
            debug ("limit-->%d",limit);
            kStringToFile(a.left(limit),p+".head",FALSE,FALSE,TRUE);
            kStringToFile(a.right(a.length()-limit-4),p+".body",FALSE,FALSE,TRUE);
            article(id,data);
            success=true;
        }
        //for some reason some INN servers force
        //readers to get head and body separately!
        else if (status==223)
        {
            status=Head(id);
            if (status==221)
            {
                QString s(TextResponse().c_str());
                kStringToFile(s,p+".head",FALSE,FALSE,TRUE);
                status=Body(id);
                if (status==222)
                {
                    s=(TextResponse().c_str());
                    kStringToFile(s,p+".body",FALSE,FALSE,TRUE);
                }
                else
                    success=false;
            }
            else success=false;
        }
        if (!success) //desperate way to get articles from broken servers
            //that don't support "article <ID>"
        {
            QString despstr;
            try
            {
                class Article artie(_id);
                debug ("desper->%s",artie.desperate);
                despstr=artie.desperate;
            }
            catch (int exc)
            {
                debug ("Trying to load an article desperately, but it\n"
                       "is not in the DB, so I have no 'desperate' information\n"
                       "so it won't work.");
                despstr="";
            }
            if (despstr.isEmpty())
            {
                success=false;
            }
            else
            {
                int sep=despstr.find('@');
                if (sep==-1)
                {
                    success=false;
                }
                else
                {
                    QString g=despstr.left(sep);
                    QString ind=despstr.right(despstr.length()-sep-1);
                    debug ("q-->%s+++ind-->%s+++",g.data(),ind.data());
                    //if not in the right group and can't go to it
                    //we're screwed
                    if (GroupName!=g && (!setGroup(g)))
                    {
                        success=false;
                    }
                    else //I got to the right group, soI get it by number
                    {
                        int status=Article (ind);

                        if (!status)
                        {
                            emit lostServer();
                            return;
                        }

                        debug ("2status-->%d",status);
                        if (status==220)
                        {
                            QString a(TextResponse().c_str());
                            int limit=a.find("\r\n\r\n");
                            debug ("limit-->%d",limit);
                            kStringToFile(a.left(limit),p+".head",FALSE,FALSE,TRUE);
                            kStringToFile(a.right(a.length()-limit-4),p+".body",FALSE,FALSE,TRUE);
                            article(id,data);
                            success=true;
                        }
                        else
                            success=false;
                    }
                }
            }

        }
        if (!success)
        {
            warning ("error getting data\nserver said %s\n",StatusResponse().c_str());
            data="";
        }
    }

    else if (isCached(id)==PART_HEAD)
    {
        debug ("has head, getting body");
        body(id,data);
        article(id,data);
    }

    else if (isCached(id)==PART_BODY)
    {
        debug ("has body, getting head");
        head(id,data);
    }

    emit newStatus(klocale->translate("Article Received"));
    return;
}
void NNTP::head(const char *_id,QString &data)
{
    QString id=saneID(_id);
    data="";
    QString p=cachepath+id;
    if (isCached(id) & PART_HEAD)
        data=kFileToString(p+".head");
    else
    {
        int status=Head(id);
        if (status==221)
        {
            data=TextResponse().c_str();
            kStringToFile(data,p+".head",FALSE,FALSE,TRUE);
        }
    }
    return;
}
void NNTP::body(const char *_id, QString &data)
{
    QString id=saneID(_id);
    data="";
    QString p=cachepath+id;
    if (isCached(id) & PART_BODY)
        data=kFileToString(p+".body");
    else
    {
        int status=Body(id);
        if (status==222)
        {
            data.append(TextResponse().c_str());
            kStringToFile(data,p+".body",FALSE,FALSE,TRUE);
        }
    }
    return;
}

bool NNTP::getMissingParts(MessageParts parts,const char *id)
{
    bool success=false;

    if (parts & PART_NONE)
        return true;
    QString data;
    if (parts == PART_ALL)
    {
        if (isCached(id)!=PART_ALL)
            article(id,data);
    }

    else if (parts == PART_BODY)
    {
        if (!(isCached(id)&PART_BODY))
            body(id,data);
    }
    else if (parts == PART_HEAD)
    {
        if (!(isCached(id)&PART_HEAD))
            head(id,data);
    }
    if (!(data.isEmpty()))
        success=true;
    return success;
}


QString NNTP::saneID(const char *id)
{
    QString r(id);
    // Why some braindead newsreader create ID's with slashes?????
    // A virtual cookie to who guess which one does this...
    return r.replace (QRegExp("/"),"\\#slash#\\");
}

void NNTP::refresh()
{
    debug ("refreshing");
    qApp->processEvents();
    debug ("refreshed");
}

bool NNTP::checkDisconnection()
{
    if (!mReplyCode)
        return false;
    return true;
}

