#include "findArtDlg.h"

#include <qcombo.h>
#include <qchkbox.h>
#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>
#include <kapp.h>

#include "typelayout.h"
#include "tlform.h"
#include "artlist.h"
#include "article.h"


#define Inherited QWidget


findArtDlg::findArtDlg (QWidget* parent,const char* name):Inherited( parent, name )
{

    QVBoxLayout *vl=new QVBoxLayout (this);
    QWidget *top=new QWidget (this);
    vl->addWidget(top,0);
    results=new ArtList(this);
    results->setMaximumHeight(0);
    vl->addWidget(results,10);

    setCaption (klocale->translate("KRN - Article Searcher"));

    TLForm *f=new TLForm("expiration",
                         klocale->translate("KRN - Article Searcher"),
                         top);

    KTypeLayout *l=f->layout;

    l->addGroup("entries","",true);

    l->addLabel("l1",klocale->translate("Find Articles With:"));
    l->newLine();
    expr=(QLineEdit *)(l->addLineEdit("expr","")->widget);
    l->newLine();

    l->addLabel("l2",klocale->translate("In Field:"));
    l->newLine();

    QStrList *fields=new QStrList;
    fields->append( "Subject" );
    fields->append( "Sender" );
    fields->append( "Cached Header" );
    fields->append( "Cached Body" );
    fields->append( "Cached Message" );
    fields->append( "Header" );
    fields->append( "Body" );
    fields->append( "Message" );
    field=(QComboBox *)(l->addComboBox("field",fields)->widget);
    delete fields;

    l->newLine();
    
    l->addGroup("gg","",false);
    casesen=(QCheckBox *)(l->addCheckBox("casesen",
                                         klocale->translate("Case Sensitive"),
                                         false)->widget);
    wildmode=(QCheckBox *)(l->addCheckBox("wildmode",
                                         klocale->translate("Wildcard Mode"),
                                         false)->widget);
    l->endGroup();
    
    l->endGroup();

    l->newLine();

    l->addGroup("buttons","",false);
    QPushButton *b1=(QPushButton *)(l->addButton("b1",klocale->translate("Find"))->widget);
    QPushButton *b2=(QPushButton *)(l->addButton("b1",klocale->translate("Find All"))->widget);
    QPushButton *b3=(QPushButton *)(l->addButton("b2",klocale->translate("Close"))->widget);
    l->endGroup();

    l->activate();

    vl->activate();
    
    expr->setFocus();
    
    b1->setDefault(true);
    QObject::connect(b1,SIGNAL(clicked()),this,SLOT(findAll()));
    QObject::connect(b3,SIGNAL(clicked()),this,SLOT(close()));
    QObject::connect(expr,SIGNAL(returnPressed()),b1,SIGNAL(clicked()));
    resize (0,0);
}


findArtDlg::~findArtDlg()
{
}

void findArtDlg::close()
{
    hide();
}

void findArtDlg::findAll()
{
    emit FindAll (expr->text(),field->currentText(),
                   casesen->isChecked(),wildmode->isChecked());
}

void findArtDlg::gotMatches(QStrList &matches)
{
    results->clear();
    QStrListIterator it(matches);
    for (it.toFirst();it.current();++it)
    {
        Article *art=new Article(it.current());
        new ArticleItem(results,art);
        delete art;
    }
    results->setMinimumHeight(6*results->fontMetrics().height());
    results->setMaximumHeight(600*results->fontMetrics().height());
}