/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* urlitem.cpp */

#include <qmsgbox.h>
#include "urlitem.h"

extern QString g_data_file;

// Constructor for new Items
UrlItem::UrlItem()
{
    strcpy(m_Url, "");
    strcpy(m_Alias, "");
    strcpy(m_HowOften, "");
    strcpy(m_LastTime, "");
    m_pNextTime = 0, 
    m_Result = NOT_YET_CHECKED;
    strcpy(m_LastModified, "");
    m_OldUrl = 0;
}

UrlItem::~UrlItem()
{
}

// Constructor for Items read from disk
UrlItem::UrlItem( const char* alias, 
		  const char* url,
		  const char* how,
		  bool use_default_browser,
		  const char* browser_path,
		  bool best_guess,
		  bool skip_tags,
		  const char* last,
		  QDateTime* pNextTime,
		  int result,
		  const char* last_modified,
		  long size )
{
    strcpy( m_Url, url);
    strcpy( m_Alias, alias );
    strcpy( m_HowOften, how );
    strcpy( m_LastTime, last );
    m_pNextTime = pNextTime;
    m_Result = result;
    strcpy( m_LastModified, last_modified );
    m_Size = size;
	
    m_UseDefaultBrowser = use_default_browser;
    strcpy( m_BrowserPath, browser_path );
    m_BestGuess = best_guess;
    m_SkipTags = skip_tags;
    m_OldUrl = 0;
	
    ParseUrl();
}	


int UrlItem::WriteToDisk()
{
    int rc = 0;
	
    url_data 	data_to_store;
    datum 	key_datum;
    datum 	data_datum;
	
    memset( &data_to_store, '\0', sizeof( data_to_store ) );
	
    DBM* dbm_ptr;
    dbm_ptr = dbm_open( g_data_file, O_RDWR | O_CREAT, S_IRUSR | S_IWUSR );

    if( dbm_ptr )
    {
	strcpy( data_to_store.url, m_Url );
	strcpy( data_to_store.alias, m_Alias );
	strcpy( data_to_store.how_often, m_HowOften );
	strcpy( data_to_store.last_time, m_LastTime );
	strcpy( data_to_store.next_time, m_pNextTime->toString() );
	strcpy( data_to_store.browser_path, m_BrowserPath );
	data_to_store.best_guess = m_BestGuess;
	data_to_store.skip_tags = m_SkipTags;
	data_to_store.use_default_browser = m_UseDefaultBrowser;
	data_to_store.result = m_Result;
	data_to_store.size = m_Size;
		
	strcpy( data_to_store.last_modified, m_LastModified );
		
	// Alias is our key
	key_datum.dptr = m_Alias;
	key_datum.dsize = strlen(m_Alias);
		
	data_datum.dptr = (char*)&data_to_store;
	data_datum.dsize = sizeof(data_to_store);
		
	rc = dbm_store( dbm_ptr, key_datum, data_datum, DBM_REPLACE );
			
	dbm_close( dbm_ptr );	
    }
    else
	warning( "ERROR saving URL: Could not open database");
    return rc;
}

void UrlItem::ParseUrl()
{
    // parse the url into a host and a filename
    char* temp = new char[URL_LEN];
    strcpy(temp, GetUrl());
	
    // strip off "http://" if it's there
    if( strlen( temp ) > strlen( "http://" ) )
    {
	char* pFind = strstr( temp, "http://");
   
	if( pFind )
	{
	    for( unsigned int i = 0; i< strlen( "http://"); i++ )
		pFind++;
	   
	    strcpy( temp, pFind ); 
	}
    }
	
    // add a slash in case we just have a domain name
    char* pFind2 = strstr( temp, "/" );
    if( !pFind2 )
	strcat( temp, "/" );
		
    char* pHost = temp;
    while( *temp != '\0' && *temp != '/')
    {
	temp++;
    }
	
    strncpy( m_Fname, temp, REMOTE_FILE_LEN );  //store our page name
    *temp = '\0'; //place a null terminator on top of the '/'
	
    strncpy( m_Host, pHost, HOST_LEN ); //store our host name

    delete[] pHost;
}


bool UrlItem::LookForLastModifiedDate( char* server_text )
{   
    char date[100];
    bool bRtn = FALSE;

    // look for "Last-modified: " inside our line
    char mod_string[]=  "Last-Modified: ";
    char* pTemp = strstr( server_text, mod_string );
	 
    if( !pTemp )
    {
	pTemp = strstr( server_text,"Last-modified: ");
    }
	   
    if( pTemp ) // we found a "Last-modified" date
    {
	// move our pointer to just after the ": "
	for( unsigned int i=1; i<sizeof(mod_string); i++ )
	    pTemp++;
	   
	// look for "GMT" inside our temp string
	int length;
	char* pEnd = strstr( pTemp, "GMT" );
	if (pEnd)
	{
	    length = pEnd - pTemp + 3;
	    strncpy( date, pTemp, length );
	    date[length] = '\0'; //null terminate
	   	           	   
	    // store the last-modifed string that the server returned
	    SetLastModified( date );
	       
	    bRtn = TRUE;
	}
    } 
 
    return bRtn;
}


bool UrlItem:: FileBodyLengthChanged( int fd, char* server_text )
{
    bool bRtn = FALSE;
    int n = 0;
    char body_buff[MAXLINE + 1];
    char tmp[300];

    long total_body = strlen( server_text );
       
    // point to the end of the headers
    char* pBody = strstr( server_text, "\r\n\r\n" );
    if( pBody )
    {
	char* pStart = strstr( server_text, "HTTP/1" );
	if ( pStart )
	    total_body -= ( pBody + 4 - pStart ); // subtract the header count
	    
	strcpy( body_buff, pBody );
    }
    else // we only have a header with no body
    {
	strcpy( body_buff, server_text );
    }

    // Read till the end of the file    
    do
    {
	n = read(fd, body_buff, MAXLINE);
	total_body += n;
	kapp->processEvents();
    }
    while (n != 0);
				     
    sprintf(tmp, "new size: %ld", total_body);
    warning( tmp); 
    sprintf(tmp, "previous size: %ld", m_Size );
    warning(tmp);
	    				      
    if ( m_Size != total_body )
    {
	bRtn = TRUE;
	m_Size = total_body;
    }

    return bRtn;
}

// How many chars are in page, not including what is inside the HTML tags
bool UrlItem:: LengthNotCountingTagsChanged( int fd, char* server_text )
{
    bool bRtn = FALSE;
    int n = 0;
    char body_buff[MAXLINE + 1];
    char tmp[300];

    long total_body = strlen( server_text );
       
    // point to the end of the headers
    char* pBody = strstr( server_text, "\r\n\r\n" );
    if( pBody )
    {
	char* pStart = strstr( server_text, "HTTP/1" );
	if ( pStart )
	    total_body -= ( pBody + 4 - pStart ); // subtract the header count
	    
	strcpy( body_buff, pBody );
    }
	
    long char_count = 0;
    int tag_count= 0;
    
    // Read till the end of the file    
    do
    {
	char_count += CountCharsOutsideOfTags(body_buff, tag_count /*by ref*/);
	//   char_count += CountWords( body_buff );
	n = read(fd, body_buff, MAXLINE);
	body_buff[n] = '\0'; //null terminate
	kapp->processEvents();
    }
    while (n != 0);
	 
    char_count += CountCharsOutsideOfTags( body_buff, tag_count/*by ref*/ );

    sprintf(tmp, "new size: %ld", char_count);
    warning(tmp);
    sprintf(tmp, "previous size: %ld", m_Size );
    warning(tmp);
	 
    if ( m_Size != char_count )
    {
	bRtn = TRUE;
	m_Size = char_count;
    }

    return bRtn;
}

void UrlItem::UpdateNextTime( )
{
    // Calculate NextTime from HowOften and the current time
    QDateTime dt= QDateTime::currentDateTime();	
			  	
    // find the timechoices[] index of our HowOften string	
    int i;
    for(i=0; strcmp (timechoices[i], GetHowOften()); i++);
	
    // Convert HowOften into seconds
    int secs = time_in_seconds[i];
	
    // Add the HowOften value to the current time to get our NextTime value
    QDateTime next_time = dt.addSecs( secs );

    QDateTime* pDateTime = GetDateTimeFromString( next_time.toString() );
		
    SetNextTime( pDateTime );
}

void UrlItem::UpdateLastTime()
{
    // update the item's last_time checked field to the current time
    QDateTime dt = QDateTime::currentDateTime();
    QString strLastTime = dt.toString();
    SetLastTime( strLastTime );
}

void UrlItem::SetOldUrl( const char* Url )
{ 
    if(!m_OldUrl)
       m_OldUrl = new char[URL_LEN];

       strcpy( m_OldUrl, Url );
}
