/**************************************************************************
   * libXicq - Originally written by tnc (xtrophy@it.dk)                     *
   *'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''*
   * main.h                                                                  *
   * Glues the library together                                              *
   **************************************************************************/


#ifndef _LIBXICQ_H
#define _LIBXICQ_H


#include <iostream.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <fcntl.h>

#include "config.h"
#include "structs.h"
#include "net.h"
#include "misc.h"
#include "parse.h"
#include "packets.h"
#include "contact.h"
#include "ui2lib.h"

struct UNKNOWNS
{
    int sock;
    unsigned short int len;
    unsigned char *data, *rpacket;
};

extern struct timeval tv;
extern fd_set fd1, fd2;

void setupCallbacks( CALLBACK_FUNCTIONS cbf );
int icq_init( USER_CONFIGURATION *user_cfg );  // Library initialization
void icq_printInfo();                         // Prints library information
int icq_main();                              // Call this again and again...
int icq_login();                	     // start ICQ TCP server

#endif
