/**************************************************************************
   * libXicq - Originally written by tnc (xtrophy@it.dk)                     *
   *'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''*
   * packets.cpp                                                             *
   * Create packets                                                          *
   **************************************************************************/


#include "packets.h"
#include "net.h"

extern NET_INFORMATION net_information;
extern USER_CONFIGURATION user_config;

ICQ_PACKET packet;

int c_sequence = 1;          // Sequence number
int s_sequence = 1;          // Search sequence
int i_sequence = 1; 	    // Search info

/*
   ** 
   ** Creates a header
*/
void packets_header( ICQ_PACKET &packet )
{
    unsigned short int version = ( unsigned short int ) ICQ_VER;
    unsigned short int command = ( unsigned short int ) packet.command;
    unsigned short int sequence = ( unsigned short int ) packet.sequence;
    unsigned int uin = ( unsigned int ) user_config.uin;

    unsigned char *tmp;
    tmp = packet.data;

    memcpy( tmp, &version, 2 ); tmp += 2;
    memcpy( tmp, &command, 2 ); tmp += 2;
    memcpy( tmp, &sequence, 2 ); tmp += 2;
    memcpy( tmp, &uin, 4 ); tmp += 4;

    packet.length = tmp - packet.data;
}


/*
   ** 
   ** Creates an ack packet
*/
ICQ_PACKET packets_ack( int sequence )
{
    packet.command = C_ACK;
    packet.sequence = sequence;
    //   packets_header(packet);
    unsigned short int len = 0;
    unsigned short int version = ( unsigned short int ) ICQ_VER;
    unsigned short int command = ( unsigned short int ) packet.command;
    unsigned short int tsequence = ( unsigned short int ) packet.sequence;
    unsigned int uin = ( unsigned int ) user_config.uin;

    unsigned char *tmp;
    tmp = packet.data;

    memcpy( tmp, &version, 2 ); tmp += 2; len += 2;
    memcpy( tmp, &command, 2 ); tmp += 2; len += 2;
    memcpy( tmp, &tsequence, 2 ); tmp += 2; len += 2;
    memcpy( tmp, &uin, 4 ); tmp += 4; len += 4;

    packet.length = len;

    misc_printPacket( &packet );
    return packet;
}


/*
   ** 
   ** Creates a message ack packet
*/
ICQ_PACKET packets_msgAck( int sequence )
{
    packet.command = C_ACK_MSG;
    packet.sequence = sequence;
    packets_header( packet );
    misc_printPacket( &packet );
    return packet;
}


/*
   ** 
   ** Creates a keep alive packet
*/
ICQ_PACKET packets_keepAlive()
{
    packet.command = C_KEEP_ALIVE;
    packet.sequence = c_sequence++;
    packets_header( packet );

    return packet;
}


/*
   ** 
   ** Creates a login packet
*/
ICQ_PACKET packets_login()
{
    packet.command = C_LOGIN;
    packet.sequence = c_sequence++;

    //   packets_header(packet);
    //net_information.clientPort=1889;
    unsigned int port = net_information.clientPort;
    unsigned short int pwdlen = strlen( user_config.password ) + 1;
    char pwd[ NAMESIZE ];
    strcpy( pwd, user_config.password );
    int len = 0;
    unsigned short int version = ( unsigned short int ) ICQ_VER;
    unsigned short int command = ( unsigned short int ) packet.command;
    unsigned short int sequence = ( unsigned short int ) packet.sequence;
    unsigned int uin = ( unsigned int ) user_config.uin;

    unsigned char *tmp;
    tmp = packet.data;

    memcpy( tmp, &version, 2 ); tmp += 2; len += 2;
    memcpy( tmp, &command, 2 ); tmp += 2; len += 2;
    memcpy( tmp, &sequence, 2 ); tmp += 2; len += 2;
    memcpy( tmp, &uin, 4 ); tmp += 4; len += 4;

    // packet.length = tmp - packet.data;


    unsigned int	X1	= 120;
    unsigned int	ip	= ipToIcq( net_information.clientAddr );
    unsigned char X2	= 04;
    unsigned int	status	= 0;
    unsigned int	X3	= 2;
    unsigned short int	lseq	= 1;
    unsigned int	X4	= 0;
    unsigned int	X5	= 7864328;
    //unsigned char *tmp;
    // tmp = packet.data + packet.length;
    memcpy( tmp, &port, 4 ); tmp += 4; len += 4;
    memcpy( tmp, &pwdlen, 2 ); tmp += 2; len += 2;
    memcpy( tmp, pwd, pwdlen ); tmp += pwdlen; len += pwdlen;
    memcpy( tmp, &X1, 4 ); tmp += 4; len += 4;
    memcpy( tmp, &ip, 4 ); tmp += 4; len += 4;
    memcpy( tmp, &X2, 1 ); tmp += 1; len += 1;
    memcpy( tmp, &status, 4 ); tmp += 4; len += 4;
    memcpy( tmp, &X3, 4 ); tmp += 4; len += 4;
    memcpy( tmp, &lseq, 2 ); tmp += 2; len += 2;
    memcpy( tmp, &X4, 4 ); tmp += 4; len += 4;
    memcpy( tmp, &X5, 4 ); tmp += 4; len += 4;

    packet.length = len;
    return packet;
}


/*
   ** 
   ** This is sent during login, don't know the exact purpose
*/
ICQ_PACKET packets_login_1()
{
    packet.command = C_LOGIN_1;
    packet.sequence = c_sequence++;
    packets_header( packet );

    return packet;
}


/*
   ** 
   ** Creates a contactList
*/
ICQ_PACKET packets_contactList()
{
    packet.command = C_CONTACT_LIST;
    packet.sequence = c_sequence++;
    packets_header( packet );



    unsigned char *tmp;
    tmp = packet.data + packet.length;

    unsigned short int length = contact_length();
    memcpy( tmp, &length, 1 ); tmp += 1;

    CONTACT contact;
    for ( int i = 0; i < contact_length(); i++ )
    {
        contact = contact_returnItemNum( i );
        memcpy( tmp, &contact.uin, 4 ); tmp += 4;
    }

    packet.length = tmp - packet.data;

    return packet;
}


/*
   ** 
   ** Creates a message to be sent through the server
*/
ICQ_PACKET packets_messageS( unsigned int receiver, char *message )
{
    packet.command = C_SEND_MESSAGE;
    packet.sequence = c_sequence++;
    packets_header( packet );

    unsigned char *tmp;
    tmp = packet.data + packet.length;

    unsigned short int type = 1;  // Normal message
    unsigned short int msgLength = strlen( message ) + 1;

    memcpy( tmp, &receiver, 4 ); tmp += 4;
    memcpy( tmp, &type, 2 ); tmp += 2;
    memcpy( tmp, &msgLength, 2 ); tmp += 2;
    memcpy( tmp, message, msgLength ); tmp += msgLength;

    packet.length = tmp - packet.data;
    misc_printPacket( &packet );
    return packet;
}


/*
   **
   ** Creates a URL to be sent through the server.
*/
ICQ_PACKET packets_urlS( unsigned int receiver, char *url, char *desc )
{
    packet.command = C_SEND_MESSAGE;
    packet.sequence = c_sequence++;
    packets_header( packet );

    unsigned char *tmp;
    tmp = packet.data + packet.length;

    unsigned short int type = 4;  // URL

    unsigned char message[ BUFSIZE ];
    bzero( message, BUFSIZE );
    strcpy( ( char * ) message, desc );
    message[ strlen( ( char * ) message ) ] = 0xFE;
    message[ strlen( ( char * ) message ) + 1 ] = '\0';

    strcat( ( char * ) message, url );
    if (KXDEBUG) printf("URL: %s, [%s]\n",message,url);
    unsigned short int msgLength = strlen( ( char * ) message ) + 1;

    memcpy( tmp, &receiver, 4 ); tmp += 4;
    memcpy( tmp, &type, 2 ); tmp += 2;
    memcpy( tmp, &msgLength, 2 ); tmp += 2;
    memcpy( tmp, message, msgLength ); tmp += msgLength;

    packet.length = tmp - packet.data;

    return packet;
}


/*
   ** 
   ** Change your online status
*/
ICQ_PACKET packets_statusChange( unsigned int status )
{
    packet.command = C_STATUS_CHANGE;
    packet.sequence = c_sequence++;
    packets_header( packet );

    unsigned char *tmp;
    tmp = packet.data + packet.length;

    memcpy( tmp, &status, 4 ); tmp += 4;

    packet.length = tmp - packet.data;

    return packet;
}

ICQ_PACKET packets_request_new_user( const char *passwd )
{
    packet.command = C_NEW_USER_REG;
    packet.sequence = c_sequence++;
    //   packets_header(packet);
    unsigned short int len;

    unsigned short int version = ( unsigned short int ) ICQ_VER;
    unsigned short int command = ( unsigned short int ) packet.command;
    unsigned short int sequence = ( unsigned short int ) packet.sequence;
    unsigned int tmpn = ( unsigned int ) 0x0002;
    char leeg[ 2 ];
    leeg[ 0 ] = 0;
    leeg[ 1 ] = 0;
    unsigned char *tmp;
    tmp = packet.data;
    unsigned short int l = 0;
    memcpy( tmp, &version, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &command, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &sequence, 2 ); tmp += 2; l += 2;
    memcpy( tmp, "\x02\x00", 2 ); tmp += 2; l += 2;
    len = ( unsigned short int ) strlen( passwd );
    memcpy( tmp, &len, 2 ); tmp += 2; l += 2;
    memcpy( tmp, passwd, len + 1 ); tmp += len; l += len;
    //  memcpy(tmp, leeg, 1);                        tmp+=1;
    tmpn = ( unsigned int ) 0x0072;
    memcpy( tmp, &tmpn, 4 ); tmp += 4; l += 4;
    tmpn = ( unsigned int ) 0x0000;
    memcpy( tmp, &tmpn, 4 ); tmp += 4; l += 4;


    packet.length = l;

    //s_sequence++;
    misc_printPacket( &packet );
    return packet;
}


ICQ_PACKET packets_add_user2list( UIN uin )
{
    packet.command = C_ADD_TO_LIST;
    packet.sequence = c_sequence++;
    //   packets_header(packet);

    unsigned short int version = ( unsigned short int ) ICQ_VER;
    unsigned short int command = ( unsigned short int ) packet.command;
    unsigned short int sequence = ( unsigned short int ) packet.sequence;
    unsigned int Euin = ( unsigned int ) user_config.uin;

    unsigned char *tmp;
    tmp = packet.data;
    unsigned short int l = 0;
    memcpy( tmp, &version, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &command, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &sequence, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &Euin, 4 ); tmp += 4; l += 4;
    memcpy( tmp, &uin, 4 ); tmp += 4; l += 4;

    packet.length = l;

    //s_sequence++;
    misc_printPacket( &packet );
    return packet;
}



ICQ_PACKET packets_change_info( const char *email, const char *nick, const char *first, const char *last	)
{
    packet.command = C_UPDATE_INFO;
    packet.sequence = c_sequence++;
    //   packets_header(packet);
    unsigned short int len;

    unsigned short int version = ( unsigned short int ) ICQ_VER;
    unsigned short int command = ( unsigned short int ) packet.command;
    unsigned short int sequence = ( unsigned short int ) packet.sequence, esequence = ( unsigned short int ) c_sequence++;
    unsigned int Euin = ( unsigned int ) user_config.uin;

    unsigned char *tmp;
    tmp = packet.data;
    unsigned short int l = 0;
    memcpy( tmp, &version, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &command, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &sequence, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &Euin, 4 ); tmp += 4; l += 4;
    memcpy( tmp, &esequence, 2 ); tmp += 2; l += 2;
    char leeg[ 2 ];
    leeg[ 0 ] = 0;
    leeg[ 1 ] = 0;
    len = ( unsigned short int ) strlen( nick ) + 1;
    memcpy( tmp, &len, 2 ); tmp += 2; l += 2;
    memcpy( tmp, nick, len - 1 ); tmp += len - 1; l += len;
    memcpy( tmp, leeg, 1 ); tmp += 1;
    len = ( unsigned short int ) strlen( first ) + 1;
    memcpy( tmp, &len, 2 ); tmp += 2; l += 2;
    memcpy( tmp, first, len - 1 ); tmp += len - 1; l += len;
    memcpy( tmp, leeg, 1 ); tmp += 1;
    len = ( unsigned short int ) strlen( last ) + 1;
    memcpy( tmp, &len, 2 ); tmp += 2; l += 2;
    memcpy( tmp, last, len - 1 ); tmp += len - 1; l += len;
    memcpy( tmp, leeg, 1 ); tmp += 1;
    len = ( unsigned short int ) strlen( email ) + 1;
    memcpy( tmp, &len, 2 ); tmp += 2; l += 2;
    memcpy( tmp, email, len - 1 ); tmp += len - 1; l += len;
    memcpy( tmp, leeg, 1 ); tmp += 1;
    memcpy( tmp, leeg, 1 ); tmp += 1; l += 1;

    packet.length = l;

    //s_sequence++;
    misc_printPacket( &packet );
    if ( KXDEBUG ) printf( "[%s] [%s] [%s] [%s]\n", email, nick, first, last );
    return packet;
}


/*
   ** 
   ** Search for info on a user (UIN search)
*/
ICQ_PACKET packets_uinSearch( unsigned int uin )
{
    packet.command = C_SEARCH_UIN;
    packet.sequence = c_sequence++;
    packets_header( packet );

    unsigned char *tmp;
    tmp = packet.data + packet.length;

    memcpy( tmp, &s_sequence, 2 ); tmp += 2;
    memcpy( tmp, &uin, 4 ); tmp += 4;

    packet.length = tmp - packet.data;

    s_sequence++;

    return packet;
}


/*
   ** 
   ** Send a text code to the server. Used for logoff etc
*/
ICQ_PACKET packets_sendTextCode( char *textCode, unsigned short int X1 )
{
    packet.command = C_SEND_TEXT_CODE;
    packet.sequence = c_sequence++;
    packets_header( packet );

    unsigned char *tmp;
    tmp = packet.data + packet.length;

    unsigned short int length = strlen( textCode ) + 1;

    memcpy( tmp, &length, 2 ); tmp += 2;
    memcpy( tmp, &textCode, length ); tmp += length;
    memcpy( tmp, &X1, 2 ); tmp += 2;

    packet.length = tmp - packet.data;

    return packet;
}


ICQ_PACKET packets_userSearch( const char *email, const char *nick, const char *first, const char *last, unsigned short int *t )
{
    packet.command = C_SEARCH_USER;
    packet.sequence = c_sequence++;
    //   packets_header(packet);
    unsigned short int len;

    unsigned short int version = ( unsigned short int ) ICQ_VER;
    unsigned short int command = ( unsigned short int ) packet.command;
    unsigned short int sequence = ( unsigned short int ) packet.sequence;
    unsigned int Euin = ( unsigned int ) user_config.uin;

    unsigned char *tmp;
    tmp = packet.data;
    unsigned short int l = 0;
    memcpy( tmp, &version, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &command, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &sequence, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &Euin, 4 ); tmp += 4; l += 4;

    sequence = ( unsigned short int ) s_sequence++;
    *t = sequence;
    memcpy( tmp, &sequence, 2 ); tmp += 2; l += 2;
    char leeg[ 2 ];
    leeg[ 0 ] = 0;
    leeg[ 1 ] = 0;
    len = ( unsigned short int ) strlen( nick ) + 1;
    memcpy( tmp, &len, 2 ); tmp += 2; l += 2;
    memcpy( tmp, nick, len - 1 ); tmp += len - 1; l += len;
    memcpy( tmp, leeg, 1 ); tmp += 1;
    len = ( unsigned short int ) strlen( first ) + 1;
    memcpy( tmp, &len, 2 ); tmp += 2; l += 2;
    memcpy( tmp, first, len - 1 ); tmp += len - 1; l += len;
    memcpy( tmp, leeg, 1 ); tmp += 1;
    len = ( unsigned short int ) strlen( last ) + 1;
    memcpy( tmp, &len, 2 ); tmp += 2; l += 2;
    memcpy( tmp, last, len - 1 ); tmp += len - 1; l += len;
    memcpy( tmp, leeg, 1 ); tmp += 1;
    len = ( unsigned short int ) strlen( email ) + 1;
    memcpy( tmp, &len, 2 ); tmp += 2; l += 2;
    memcpy( tmp, email, len - 1 ); tmp += len - 1; l += len;
    memcpy( tmp, leeg, 1 ); tmp += 1;
    packet.length = l;

    //s_sequence++;
    misc_printPacket( &packet );
    if ( KXDEBUG ) printf( "[%d] [%s] [%s] [%s] [%s] %d [%s]\n", *t, email, nick, first, last, l, packet.data );
    return packet;
}
ICQ_PACKET packets_infoReply( unsigned int uin, unsigned short int *t )
{
    packet.command = C_INFO_REQ;
    packet.sequence = c_sequence++;
    //   packets_header(packet);

    unsigned short int version = ( unsigned short int ) ICQ_VER;
    unsigned short int command = ( unsigned short int ) packet.command;
    unsigned short int sequence = ( unsigned short int ) packet.sequence;
    unsigned int Euin = ( unsigned int ) user_config.uin;

    unsigned char *tmp;
    tmp = packet.data;
    unsigned short int l = 0;
    memcpy( tmp, &version, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &command, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &sequence, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &Euin, 4 ); tmp += 4; l += 4;

    sequence = ( unsigned short int ) s_sequence++;
    *t = sequence;
    memcpy( tmp, &sequence, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &uin, 4 ); tmp += 4; l += 4;

    packet.length = l;
    misc_printPacket( &packet );
    return packet;

}
ICQ_PACKET packets_extInfoReply( unsigned int uin, unsigned short int *t )
{
    packet.command = C_EXT_INFO_REQ;
    packet.sequence = c_sequence++;
    //   packets_header(packet);
    //unsigned short int len;

    unsigned short int version = ( unsigned short int ) ICQ_VER;
    unsigned short int command = ( unsigned short int ) packet.command;
    unsigned short int sequence = ( unsigned short int ) packet.sequence;
    unsigned int Euin = ( unsigned int ) user_config.uin;

    unsigned char *tmp;
    tmp = packet.data;
    unsigned short int l = 0;
    memcpy( tmp, &version, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &command, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &sequence, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &Euin, 4 ); tmp += 4; l += 4;

    sequence = ( unsigned short int ) s_sequence++;
    *t = sequence;
    memcpy( tmp, &sequence, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &uin, 4 ); tmp += 4; l += 4;

    packet.length = l;
    misc_printPacket( &packet );
    return packet;

}
ICQ_PACKET packets_sendAuth( unsigned int uin )
{
    packet.command = C_REQ_ADD_TO_LIST;
    packet.sequence = c_sequence++;
    //   packets_header(packet);
    //unsigned short int len;

    unsigned short int version = ( unsigned short int ) ICQ_VER;
    unsigned short int command = ( unsigned short int ) packet.command;
    unsigned short int sequence = ( unsigned short int ) packet.sequence;
    unsigned int Euin = ( unsigned int ) user_config.uin;

    unsigned char *tmp;
    tmp = packet.data;
    unsigned short int l = 0;
    memcpy( tmp, &version, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &command, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &sequence, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &Euin, 4 ); tmp += 4; l += 4;

    memcpy( tmp, &uin, 4 ); tmp += 4; l += 4;
    unsigned int tmpl=0x00010008;
    memcpy( tmp, &tmpl, 4 ); tmp += 4; l += 4;
    unsigned short int tmls=0;
    memcpy( tmp, &tmls, 1 ); tmp += 1; l += 1;
    
    packet.length = l;
    misc_printPacket( &packet );
    return packet;

}
ICQ_PACKET packets_web()
{
    packet.command = C_WEB;
    packet.sequence = c_sequence++;
    //   packets_header(packet);
    //unsigned short int len;

    unsigned short int version = ( unsigned short int ) ICQ_VER;
    unsigned short int command = ( unsigned short int ) packet.command;
    unsigned short int sequence = ( unsigned short int ) packet.sequence;
    unsigned int Euin = ( unsigned int ) user_config.uin;

    unsigned char *tmp;
    tmp = packet.data;
    unsigned short int l = 0;
    memcpy( tmp, &version, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &command, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &sequence, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &Euin, 4 ); tmp += 4; l += 4;

    char status=STATUS_ONLINE;
    memcpy( tmp, &status, 1 ); tmp+=1; l+=1;
    status=0x4;
    memcpy( tmp, &status, 1 ); tmp+=1; l+=1;
    status=0x1;
    memcpy( tmp, &status, 1 ); tmp+=1; l+=1;
    memcpy( tmp, &status, 1 ); tmp+=1; l+=1;
    memcpy( tmp, &status, 1 ); tmp+=1; l+=1;

    packet.length = l;
    misc_printPacket( &packet );
    return packet;
}
ICQ_PACKET packets_web_finisch()
{
    packet.command = C_WEB_FINISCH;
    packet.sequence = c_sequence++;
    //   packets_header(packet);
    //unsigned short int len;

    unsigned short int version = ( unsigned short int ) ICQ_VER;
    unsigned short int command = ( unsigned short int ) packet.command;
    unsigned short int sequence = ( unsigned short int ) packet.sequence;
    unsigned int Euin = ( unsigned int ) user_config.uin;

    unsigned char *tmp;
    tmp = packet.data;
    unsigned short int l = 0;
    memcpy( tmp, &version, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &command, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &sequence, 2 ); tmp += 2; l += 2;
    memcpy( tmp, &Euin, 4 ); tmp += 4; l += 4;

    char status=0x0;
    memcpy( tmp, &status, 1 ); tmp+=1; l+=1;
    status=0x2;
    memcpy( tmp, &status, 1 ); tmp+=1; l+=1;
    status=0x1;
    memcpy( tmp, &status, 1 ); tmp+=1; l+=1;
    status=0x0;
    memcpy( tmp, &status, 1 ); tmp+=1; l+=1;

    packet.length = l;
    misc_printPacket( &packet );
    return packet;

}

